/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ecgost;

import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.crypto.DSA;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.GOST3411Digest;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.crypto.signers.ECGOST3410Signer;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ec.ECUtil;
import com.timevale.tgtext.bouncycastle.jce.interfaces.ECKey;
import com.timevale.tgtext.bouncycastle.jce.interfaces.ECPublicKey;
import com.timevale.tgtext.bouncycastle.jce.interfaces.GOST3410Key;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.jce.provider.GOST3410Util;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends java.security.SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest = new GOST3411Digest();
    private DSA signer = new ECGOST3410Signer();

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param;
        if (publicKey instanceof ECPublicKey) {
            param = ECUtil.generatePublicKeyParameter(publicKey);
        } else if (publicKey instanceof GOST3410Key) {
            param = GOST3410Util.generatePublicKeyParameter(publicKey);
        } else {
            try {
                byte[] bytes = publicKey.getEncoded();
                publicKey = BouncyCastleProvider.getPublicKey(SubjectPublicKeyInfo.getInstance(bytes));
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
                param = ECUtil.generatePublicKeyParameter(publicKey);
            }
            catch (Exception exception) {
                throw new InvalidKeyException("can't recognise key type in DSA based signer");
            }
        }
        this.digest.reset();
        this.signer.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = privateKey instanceof ECKey ? ECUtil.generatePrivateKeyParameter(privateKey) : GOST3410Util.generatePrivateKeyParameter(privateKey);
        this.digest.reset();
        if (this.appRandom != null) {
            this.signer.init(true, new ParametersWithRandom(param, this.appRandom));
            return;
        }
        this.signer.init(true, param);
    }

    @Override
    protected void engineUpdate(byte b2) throws SignatureException {
        this.digest.update(b2);
    }

    @Override
    protected void engineUpdate(byte[] b2, int off, int len) throws SignatureException {
        this.digest.update(b2, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] sigBytes = new byte[64];
            BigInteger[] sig = this.signer.generateSignature(hash);
            byte[] r2 = sig[0].toByteArray();
            byte[] s2 = sig[1].toByteArray();
            if (s2[0] != 0) {
                System.arraycopy(s2, 0, sigBytes, 32 - s2.length, s2.length);
            } else {
                System.arraycopy(s2, 1, sigBytes, 32 - (s2.length - 1), s2.length - 1);
            }
            if (r2[0] != 0) {
                System.arraycopy(r2, 0, sigBytes, 64 - r2.length, r2.length);
            } else {
                System.arraycopy(r2, 1, sigBytes, 64 - (r2.length - 1), r2.length - 1);
            }
            return sigBytes;
        }
        catch (Exception e2) {
            throw new SignatureException(e2.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger[] sig;
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] r2 = new byte[32];
            byte[] s2 = new byte[32];
            System.arraycopy(sigBytes, 0, s2, 0, 32);
            System.arraycopy(sigBytes, 32, r2, 0, 32);
            BigInteger[] bigIntegerArray = new BigInteger[2];
            sig = bigIntegerArray;
            bigIntegerArray[0] = new BigInteger(1, r2);
            sig[1] = new BigInteger(1, s2);
        }
        catch (Exception exception) {
            throw new SignatureException("error decoding signature bytes.");
        }
        return this.signer.verifySignature(hash, sig[0], sig[1]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }
}

