/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.digests;

import com.timevale.tgtext.bouncycastle.crypto.digests.GeneralDigest;

public class RIPEMD160Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 20;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int[] X = new int[16];
    private int xOff;

    public RIPEMD160Digest() {
        this.reset();
    }

    public RIPEMD160Digest(RIPEMD160Digest t2) {
        super(t2);
        this.H0 = t2.H0;
        this.H1 = t2.H1;
        this.H2 = t2.H2;
        this.H3 = t2.H3;
        this.H4 = t2.H4;
        System.arraycopy(t2.X, 0, this.X, 0, t2.X.length);
        this.xOff = t2.xOff;
    }

    @Override
    public String getAlgorithmName() {
        return "RIPEMD160";
    }

    @Override
    public int getDigestSize() {
        return 20;
    }

    @Override
    protected void processWord(byte[] in, int inOff) {
        this.X[this.xOff++] = in[inOff] & 0xFF | (in[inOff + 1] & 0xFF) << 8 | (in[inOff + 2] & 0xFF) << 16 | (in[inOff + 3] & 0xFF) << 24;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)bitLength;
        this.X[15] = (int)(bitLength >>> 32);
    }

    private void unpackWord(int word, byte[] out, int outOff) {
        out[outOff] = (byte)word;
        out[outOff + 1] = (byte)(word >>> 8);
        out[outOff + 2] = (byte)(word >>> 16);
        out[outOff + 3] = word >> 24;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        this.unpackWord(this.H0, out, outOff);
        this.unpackWord(this.H1, out, outOff + 4);
        this.unpackWord(this.H2, out, outOff + 8);
        this.unpackWord(this.H3, out, outOff + 12);
        this.unpackWord(this.H4, out, outOff + 16);
        this.reset();
        return 20;
    }

    @Override
    public void reset() {
        super.reset();
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }

    private int RL(int x2, int n2) {
        return x2 << n2 | x2 >>> 32 - n2;
    }

    private int f1(int x2, int y2, int z2) {
        return x2 ^ y2 ^ z2;
    }

    private int f2(int x2, int y2, int z2) {
        return x2 & y2 | ~x2 & z2;
    }

    private int f3(int x2, int y2, int z2) {
        return (x2 | ~y2) ^ z2;
    }

    private int f4(int x2, int y2, int z2) {
        return x2 & z2 | y2 & ~z2;
    }

    private int f5(int x2, int y2, int z2) {
        return x2 ^ (y2 | ~z2);
    }

    @Override
    protected void processBlock() {
        int ee2;
        int dd2;
        int cc2;
        int bb2;
        int aa2;
        int a2 = aa2 = this.H0;
        int b2 = bb2 = this.H1;
        int c2 = cc2 = this.H2;
        int d2 = dd2 = this.H3;
        int e2 = ee2 = this.H4;
        a2 = this.RL(a2 + this.f1(b2, c2, d2) + this.X[0], 11) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f1(a2, b2, c2) + this.X[1], 14) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f1(e2, a2, b2) + this.X[2], 15) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f1(d2, e2, a2) + this.X[3], 12) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f1(c2, d2, e2) + this.X[4], 5) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f1(b2, c2, d2) + this.X[5], 8) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f1(a2, b2, c2) + this.X[6], 7) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f1(e2, a2, b2) + this.X[7], 9) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f1(d2, e2, a2) + this.X[8], 11) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f1(c2, d2, e2) + this.X[9], 13) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f1(b2, c2, d2) + this.X[10], 14) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f1(a2, b2, c2) + this.X[11], 15) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f1(e2, a2, b2) + this.X[12], 6) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f1(d2, e2, a2) + this.X[13], 7) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f1(c2, d2, e2) + this.X[14], 9) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f1(b2, c2, d2) + this.X[15], 8) + e2;
        c2 = this.RL(c2, 10);
        aa2 = this.RL(aa2 + this.f5(bb2, cc2, dd2) + this.X[5] + 1352829926, 8) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f5(aa2, bb2, cc2) + this.X[14] + 1352829926, 9) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f5(ee2, aa2, bb2) + this.X[7] + 1352829926, 9) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f5(dd2, ee2, aa2) + this.X[0] + 1352829926, 11) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f5(cc2, dd2, ee2) + this.X[9] + 1352829926, 13) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f5(bb2, cc2, dd2) + this.X[2] + 1352829926, 15) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f5(aa2, bb2, cc2) + this.X[11] + 1352829926, 15) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f5(ee2, aa2, bb2) + this.X[4] + 1352829926, 5) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f5(dd2, ee2, aa2) + this.X[13] + 1352829926, 7) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f5(cc2, dd2, ee2) + this.X[6] + 1352829926, 7) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f5(bb2, cc2, dd2) + this.X[15] + 1352829926, 8) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f5(aa2, bb2, cc2) + this.X[8] + 1352829926, 11) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f5(ee2, aa2, bb2) + this.X[1] + 1352829926, 14) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f5(dd2, ee2, aa2) + this.X[10] + 1352829926, 14) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f5(cc2, dd2, ee2) + this.X[3] + 1352829926, 12) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f5(bb2, cc2, dd2) + this.X[12] + 1352829926, 6) + ee2;
        cc2 = this.RL(cc2, 10);
        e2 = this.RL(e2 + this.f2(a2, b2, c2) + this.X[7] + 1518500249, 7) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f2(e2, a2, b2) + this.X[4] + 1518500249, 6) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f2(d2, e2, a2) + this.X[13] + 1518500249, 8) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f2(c2, d2, e2) + this.X[1] + 1518500249, 13) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f2(b2, c2, d2) + this.X[10] + 1518500249, 11) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f2(a2, b2, c2) + this.X[6] + 1518500249, 9) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f2(e2, a2, b2) + this.X[15] + 1518500249, 7) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f2(d2, e2, a2) + this.X[3] + 1518500249, 15) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f2(c2, d2, e2) + this.X[12] + 1518500249, 7) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f2(b2, c2, d2) + this.X[0] + 1518500249, 12) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f2(a2, b2, c2) + this.X[9] + 1518500249, 15) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f2(e2, a2, b2) + this.X[5] + 1518500249, 9) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f2(d2, e2, a2) + this.X[2] + 1518500249, 11) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f2(c2, d2, e2) + this.X[14] + 1518500249, 7) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f2(b2, c2, d2) + this.X[11] + 1518500249, 13) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f2(a2, b2, c2) + this.X[8] + 1518500249, 12) + d2;
        b2 = this.RL(b2, 10);
        ee2 = this.RL(ee2 + this.f4(aa2, bb2, cc2) + this.X[6] + 1548603684, 9) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f4(ee2, aa2, bb2) + this.X[11] + 1548603684, 13) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f4(dd2, ee2, aa2) + this.X[3] + 1548603684, 15) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f4(cc2, dd2, ee2) + this.X[7] + 1548603684, 7) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f4(bb2, cc2, dd2) + this.X[0] + 1548603684, 12) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f4(aa2, bb2, cc2) + this.X[13] + 1548603684, 8) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f4(ee2, aa2, bb2) + this.X[5] + 1548603684, 9) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f4(dd2, ee2, aa2) + this.X[10] + 1548603684, 11) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f4(cc2, dd2, ee2) + this.X[14] + 1548603684, 7) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f4(bb2, cc2, dd2) + this.X[15] + 1548603684, 7) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f4(aa2, bb2, cc2) + this.X[8] + 1548603684, 12) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f4(ee2, aa2, bb2) + this.X[12] + 1548603684, 7) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f4(dd2, ee2, aa2) + this.X[4] + 1548603684, 6) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f4(cc2, dd2, ee2) + this.X[9] + 1548603684, 15) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f4(bb2, cc2, dd2) + this.X[1] + 1548603684, 13) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f4(aa2, bb2, cc2) + this.X[2] + 1548603684, 11) + dd2;
        bb2 = this.RL(bb2, 10);
        d2 = this.RL(d2 + this.f3(e2, a2, b2) + this.X[3] + 1859775393, 11) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f3(d2, e2, a2) + this.X[10] + 1859775393, 13) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f3(c2, d2, e2) + this.X[14] + 1859775393, 6) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f3(b2, c2, d2) + this.X[4] + 1859775393, 7) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f3(a2, b2, c2) + this.X[9] + 1859775393, 14) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f3(e2, a2, b2) + this.X[15] + 1859775393, 9) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f3(d2, e2, a2) + this.X[8] + 1859775393, 13) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f3(c2, d2, e2) + this.X[1] + 1859775393, 15) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f3(b2, c2, d2) + this.X[2] + 1859775393, 14) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f3(a2, b2, c2) + this.X[7] + 1859775393, 8) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f3(e2, a2, b2) + this.X[0] + 1859775393, 13) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f3(d2, e2, a2) + this.X[6] + 1859775393, 6) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f3(c2, d2, e2) + this.X[13] + 1859775393, 5) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f3(b2, c2, d2) + this.X[11] + 1859775393, 12) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f3(a2, b2, c2) + this.X[5] + 1859775393, 7) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f3(e2, a2, b2) + this.X[12] + 1859775393, 5) + c2;
        a2 = this.RL(a2, 10);
        dd2 = this.RL(dd2 + this.f3(ee2, aa2, bb2) + this.X[15] + 1836072691, 9) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f3(dd2, ee2, aa2) + this.X[5] + 1836072691, 7) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f3(cc2, dd2, ee2) + this.X[1] + 1836072691, 15) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f3(bb2, cc2, dd2) + this.X[3] + 1836072691, 11) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f3(aa2, bb2, cc2) + this.X[7] + 1836072691, 8) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f3(ee2, aa2, bb2) + this.X[14] + 1836072691, 6) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f3(dd2, ee2, aa2) + this.X[6] + 1836072691, 6) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f3(cc2, dd2, ee2) + this.X[9] + 1836072691, 14) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f3(bb2, cc2, dd2) + this.X[11] + 1836072691, 12) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f3(aa2, bb2, cc2) + this.X[8] + 1836072691, 13) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f3(ee2, aa2, bb2) + this.X[12] + 1836072691, 5) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f3(dd2, ee2, aa2) + this.X[2] + 1836072691, 14) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f3(cc2, dd2, ee2) + this.X[10] + 1836072691, 13) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f3(bb2, cc2, dd2) + this.X[0] + 1836072691, 13) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f3(aa2, bb2, cc2) + this.X[4] + 1836072691, 7) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f3(ee2, aa2, bb2) + this.X[13] + 1836072691, 5) + cc2;
        aa2 = this.RL(aa2, 10);
        c2 = this.RL(c2 + this.f4(d2, e2, a2) + this.X[1] + -1894007588, 11) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f4(c2, d2, e2) + this.X[9] + -1894007588, 12) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f4(b2, c2, d2) + this.X[11] + -1894007588, 14) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f4(a2, b2, c2) + this.X[10] + -1894007588, 15) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f4(e2, a2, b2) + this.X[0] + -1894007588, 14) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f4(d2, e2, a2) + this.X[8] + -1894007588, 15) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f4(c2, d2, e2) + this.X[12] + -1894007588, 9) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f4(b2, c2, d2) + this.X[4] + -1894007588, 8) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f4(a2, b2, c2) + this.X[13] + -1894007588, 9) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f4(e2, a2, b2) + this.X[3] + -1894007588, 14) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f4(d2, e2, a2) + this.X[7] + -1894007588, 5) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f4(c2, d2, e2) + this.X[15] + -1894007588, 6) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f4(b2, c2, d2) + this.X[14] + -1894007588, 8) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f4(a2, b2, c2) + this.X[5] + -1894007588, 6) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f4(e2, a2, b2) + this.X[6] + -1894007588, 5) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f4(d2, e2, a2) + this.X[2] + -1894007588, 12) + b2;
        e2 = this.RL(e2, 10);
        cc2 = this.RL(cc2 + this.f2(dd2, ee2, aa2) + this.X[8] + 2053994217, 15) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f2(cc2, dd2, ee2) + this.X[6] + 2053994217, 5) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f2(bb2, cc2, dd2) + this.X[4] + 2053994217, 8) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f2(aa2, bb2, cc2) + this.X[1] + 2053994217, 11) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f2(ee2, aa2, bb2) + this.X[3] + 2053994217, 14) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f2(dd2, ee2, aa2) + this.X[11] + 2053994217, 14) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f2(cc2, dd2, ee2) + this.X[15] + 2053994217, 6) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f2(bb2, cc2, dd2) + this.X[0] + 2053994217, 14) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f2(aa2, bb2, cc2) + this.X[5] + 2053994217, 6) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f2(ee2, aa2, bb2) + this.X[12] + 2053994217, 9) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f2(dd2, ee2, aa2) + this.X[2] + 2053994217, 12) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f2(cc2, dd2, ee2) + this.X[13] + 2053994217, 9) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f2(bb2, cc2, dd2) + this.X[9] + 2053994217, 12) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f2(aa2, bb2, cc2) + this.X[7] + 2053994217, 5) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f2(ee2, aa2, bb2) + this.X[10] + 2053994217, 15) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f2(dd2, ee2, aa2) + this.X[14] + 2053994217, 8) + bb2;
        ee2 = this.RL(ee2, 10);
        b2 = this.RL(b2 + this.f5(c2, d2, e2) + this.X[4] + -1454113458, 9) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f5(b2, c2, d2) + this.X[0] + -1454113458, 15) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f5(a2, b2, c2) + this.X[5] + -1454113458, 5) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f5(e2, a2, b2) + this.X[9] + -1454113458, 11) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f5(d2, e2, a2) + this.X[7] + -1454113458, 6) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f5(c2, d2, e2) + this.X[12] + -1454113458, 8) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f5(b2, c2, d2) + this.X[2] + -1454113458, 13) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f5(a2, b2, c2) + this.X[10] + -1454113458, 12) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f5(e2, a2, b2) + this.X[14] + -1454113458, 5) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f5(d2, e2, a2) + this.X[1] + -1454113458, 12) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f5(c2, d2, e2) + this.X[3] + -1454113458, 13) + a2;
        d2 = this.RL(d2, 10);
        a2 = this.RL(a2 + this.f5(b2, c2, d2) + this.X[8] + -1454113458, 14) + e2;
        c2 = this.RL(c2, 10);
        e2 = this.RL(e2 + this.f5(a2, b2, c2) + this.X[11] + -1454113458, 11) + d2;
        b2 = this.RL(b2, 10);
        d2 = this.RL(d2 + this.f5(e2, a2, b2) + this.X[6] + -1454113458, 8) + c2;
        a2 = this.RL(a2, 10);
        c2 = this.RL(c2 + this.f5(d2, e2, a2) + this.X[15] + -1454113458, 5) + b2;
        e2 = this.RL(e2, 10);
        b2 = this.RL(b2 + this.f5(c2, d2, e2) + this.X[13] + -1454113458, 6) + a2;
        d2 = this.RL(d2, 10);
        bb2 = this.RL(bb2 + this.f1(cc2, dd2, ee2) + this.X[12], 8) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f1(bb2, cc2, dd2) + this.X[15], 5) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f1(aa2, bb2, cc2) + this.X[10], 12) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f1(ee2, aa2, bb2) + this.X[4], 9) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f1(dd2, ee2, aa2) + this.X[1], 12) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f1(cc2, dd2, ee2) + this.X[5], 5) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f1(bb2, cc2, dd2) + this.X[8], 14) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f1(aa2, bb2, cc2) + this.X[7], 6) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f1(ee2, aa2, bb2) + this.X[6], 8) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f1(dd2, ee2, aa2) + this.X[2], 13) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f1(cc2, dd2, ee2) + this.X[13], 6) + aa2;
        dd2 = this.RL(dd2, 10);
        aa2 = this.RL(aa2 + this.f1(bb2, cc2, dd2) + this.X[14], 5) + ee2;
        cc2 = this.RL(cc2, 10);
        ee2 = this.RL(ee2 + this.f1(aa2, bb2, cc2) + this.X[0], 15) + dd2;
        bb2 = this.RL(bb2, 10);
        dd2 = this.RL(dd2 + this.f1(ee2, aa2, bb2) + this.X[3], 13) + cc2;
        aa2 = this.RL(aa2, 10);
        cc2 = this.RL(cc2 + this.f1(dd2, ee2, aa2) + this.X[9], 11) + bb2;
        ee2 = this.RL(ee2, 10);
        bb2 = this.RL(bb2 + this.f1(cc2, dd2, ee2) + this.X[11], 11) + aa2;
        dd2 = this.RL(dd2, 10);
        this.H1 = this.H2 + d2 + ee2;
        this.H2 = this.H3 + e2 + aa2;
        this.H3 = this.H4 + a2 + bb2;
        this.H4 = this.H0 + b2 + cc2;
        this.H0 = dd2 += c2 + this.H1;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }
}

