/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.generators;

import com.timevale.tgtext.bouncycastle.crypto.params.GOST3410Parameters;
import com.timevale.tgtext.bouncycastle.crypto.params.GOST3410ValidationParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class GOST3410ParametersGenerator {
    private int size;
    private int typeproc;
    private SecureRandom init_random;
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    public void init(int size, int typeproc, SecureRandom random) {
        this.size = size;
        this.typeproc = typeproc;
        this.init_random = random;
    }

    private int procedure_A(int x0, int c2, BigInteger[] pq, int size) {
        while (x0 < 0 || x0 > 65536) {
            x0 = this.init_random.nextInt() / 32768;
        }
        while (c2 < 0 || c2 > 65536 || c2 / 2 == 0) {
            c2 = this.init_random.nextInt() / 32768 + 1;
        }
        BigInteger C = new BigInteger(Integer.toString(c2));
        BigInteger constA16 = new BigInteger("19381");
        BigInteger[] bigIntegerArray = new BigInteger[1];
        BigInteger[] y2 = bigIntegerArray;
        bigIntegerArray[0] = new BigInteger(Integer.toString(x0));
        int[] nArray = new int[1];
        int[] t2 = nArray;
        nArray[0] = size;
        int s2 = 0;
        int i2 = 0;
        while (t2[i2] >= 17) {
            int[] tmp_t = new int[t2.length + 1];
            System.arraycopy(t2, 0, tmp_t, 0, t2.length);
            t2 = new int[tmp_t.length];
            System.arraycopy(tmp_t, 0, t2, 0, tmp_t.length);
            t2[i2 + 1] = t2[i2] / 2;
            s2 = i2 + 1;
            ++i2;
        }
        BigInteger[] bigIntegerArray2 = new BigInteger[s2 + 1];
        BigInteger[] p2 = bigIntegerArray2;
        bigIntegerArray2[s2] = new BigInteger("8003", 16);
        int m2 = s2 - 1;
        for (int i3 = 0; i3 < s2; ++i3) {
            int rm = t2[m2] / 16;
            block4: while (true) {
                BigInteger[] tmp_y = new BigInteger[y2.length];
                System.arraycopy(y2, 0, tmp_y, 0, y2.length);
                y2 = new BigInteger[rm + 1];
                System.arraycopy(tmp_y, 0, y2, 0, tmp_y.length);
                for (int j2 = 0; j2 < rm; ++j2) {
                    y2[j2 + 1] = y2[j2].multiply(constA16).add(C).mod(TWO.pow(16));
                }
                BigInteger Ym = new BigInteger("0");
                for (int j3 = 0; j3 < rm; ++j3) {
                    Ym = Ym.add(y2[j3].multiply(TWO.pow(j3 * 16)));
                }
                y2[0] = y2[rm];
                BigInteger N = TWO.pow(t2[m2] - 1).divide(p2[m2 + 1]).add(TWO.pow(t2[m2] - 1).multiply(Ym).divide(p2[m2 + 1].multiply(TWO.pow(rm * 16))));
                if (N.mod(TWO).compareTo(ONE) == 0) {
                    N = N.add(ONE);
                }
                int k2 = 0;
                while (true) {
                    p2[m2] = p2[m2 + 1].multiply(N.add(BigInteger.valueOf(k2))).add(ONE);
                    if (p2[m2].compareTo(TWO.pow(t2[m2])) == 1) continue block4;
                    if (TWO.modPow(p2[m2 + 1].multiply(N.add(BigInteger.valueOf(k2))), p2[m2]).compareTo(ONE) == 0 && TWO.modPow(N.add(BigInteger.valueOf(k2)), p2[m2]).compareTo(ONE) != 0) break block4;
                    k2 += 2;
                }
                break;
            }
            if (--m2 >= 0) continue;
            pq[0] = p2[0];
            pq[1] = p2[1];
            return y2[0].intValue();
        }
        return y2[0].intValue();
    }

    private long procedure_Aa(long x0, long c2, BigInteger[] pq, int size) {
        while (x0 < 0L || x0 > 0x100000000L) {
            x0 = this.init_random.nextInt() << 1;
        }
        while (c2 < 0L || c2 > 0x100000000L || c2 / 2L == 0L) {
            c2 = (this.init_random.nextInt() << 1) + 1;
        }
        BigInteger C = new BigInteger(Long.toString(c2));
        BigInteger constA32 = new BigInteger("97781173");
        BigInteger[] bigIntegerArray = new BigInteger[1];
        BigInteger[] y2 = bigIntegerArray;
        bigIntegerArray[0] = new BigInteger(Long.toString(x0));
        int[] nArray = new int[1];
        int[] t2 = nArray;
        nArray[0] = size;
        int s2 = 0;
        int i2 = 0;
        while (t2[i2] >= 33) {
            int[] tmp_t = new int[t2.length + 1];
            System.arraycopy(t2, 0, tmp_t, 0, t2.length);
            t2 = new int[tmp_t.length];
            System.arraycopy(tmp_t, 0, t2, 0, tmp_t.length);
            t2[i2 + 1] = t2[i2] / 2;
            s2 = i2 + 1;
            ++i2;
        }
        BigInteger[] bigIntegerArray2 = new BigInteger[s2 + 1];
        BigInteger[] p2 = bigIntegerArray2;
        bigIntegerArray2[s2] = new BigInteger("8000000B", 16);
        int m2 = s2 - 1;
        for (int i3 = 0; i3 < s2; ++i3) {
            int rm = t2[m2] / 32;
            block4: while (true) {
                BigInteger[] tmp_y = new BigInteger[y2.length];
                System.arraycopy(y2, 0, tmp_y, 0, y2.length);
                y2 = new BigInteger[rm + 1];
                System.arraycopy(tmp_y, 0, y2, 0, tmp_y.length);
                for (int j2 = 0; j2 < rm; ++j2) {
                    y2[j2 + 1] = y2[j2].multiply(constA32).add(C).mod(TWO.pow(32));
                }
                BigInteger Ym = new BigInteger("0");
                for (int j3 = 0; j3 < rm; ++j3) {
                    Ym = Ym.add(y2[j3].multiply(TWO.pow(j3 * 32)));
                }
                y2[0] = y2[rm];
                BigInteger N = TWO.pow(t2[m2] - 1).divide(p2[m2 + 1]).add(TWO.pow(t2[m2] - 1).multiply(Ym).divide(p2[m2 + 1].multiply(TWO.pow(rm * 32))));
                if (N.mod(TWO).compareTo(ONE) == 0) {
                    N = N.add(ONE);
                }
                int k2 = 0;
                while (true) {
                    p2[m2] = p2[m2 + 1].multiply(N.add(BigInteger.valueOf(k2))).add(ONE);
                    if (p2[m2].compareTo(TWO.pow(t2[m2])) == 1) continue block4;
                    if (TWO.modPow(p2[m2 + 1].multiply(N.add(BigInteger.valueOf(k2))), p2[m2]).compareTo(ONE) == 0 && TWO.modPow(N.add(BigInteger.valueOf(k2)), p2[m2]).compareTo(ONE) != 0) break block4;
                    k2 += 2;
                }
                break;
            }
            if (--m2 >= 0) continue;
            pq[0] = p2[0];
            pq[1] = p2[1];
            return y2[0].longValue();
        }
        return y2[0].longValue();
    }

    /*
     * Unable to fully structure code
     */
    private void procedure_B(int x0, int c, BigInteger[] pq) {
        while (x0 < 0 || x0 > 65536) {
            x0 = this.init_random.nextInt() / 32768;
        }
        while (c < 0 || c > 65536 || c / 2 == 0) {
            c = this.init_random.nextInt() / 32768 + 1;
        }
        qp = new BigInteger[2];
        C = new BigInteger(Integer.toString(c));
        constA16 = new BigInteger("19381");
        x0 = this.procedure_A(x0, c, qp, 256);
        q = qp[0];
        x0 = this.procedure_A(x0, c, qp, 512);
        Q = qp[0];
        v0 = new BigInteger[65];
        y = v0;
        v0[0] = new BigInteger(Integer.toString(x0));
        while (true) {
            for (j = 0; j < 64; ++j) {
                y[j + 1] = y[j].multiply(constA16).add(C).mod(GOST3410ParametersGenerator.TWO.pow(16));
            }
            Y = new BigInteger("0");
            for (j = 0; j < 64; ++j) {
                Y = Y.add(y[j].multiply(GOST3410ParametersGenerator.TWO.pow(j * 16)));
            }
            y[0] = y[64];
            N = GOST3410ParametersGenerator.TWO.pow(1023).divide(q.multiply(Q)).add(GOST3410ParametersGenerator.TWO.pow(1023).multiply(Y).divide(q.multiply(Q).multiply(GOST3410ParametersGenerator.TWO.pow(1024))));
            if (N.mod(GOST3410ParametersGenerator.TWO).compareTo(GOST3410ParametersGenerator.ONE) == 0) {
                N = N.add(GOST3410ParametersGenerator.ONE);
            }
            k = 0;
            while (true) {
                if ((p = q.multiply(Q).multiply(N.add(BigInteger.valueOf(k))).add(GOST3410ParametersGenerator.ONE)).compareTo(GOST3410ParametersGenerator.TWO.pow(1024)) == 1) ** continue;
                if (GOST3410ParametersGenerator.TWO.modPow(q.multiply(Q).multiply(N.add(BigInteger.valueOf(k))), p).compareTo(GOST3410ParametersGenerator.ONE) == 0 && GOST3410ParametersGenerator.TWO.modPow(q.multiply(N.add(BigInteger.valueOf(k))), p).compareTo(GOST3410ParametersGenerator.ONE) != 0) {
                    pq[0] = p;
                    pq[1] = q;
                    return;
                }
                k += 2;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void procedure_Bb(long x0, long c, BigInteger[] pq) {
        while (x0 < 0L || x0 > 0x100000000L) {
            x0 = this.init_random.nextInt() << 1;
        }
        while (c < 0L || c > 0x100000000L || c / 2L == 0L) {
            c = (this.init_random.nextInt() << 1) + 1;
        }
        qp = new BigInteger[2];
        C = new BigInteger(Long.toString(c));
        constA32 = new BigInteger("97781173");
        x0 = this.procedure_Aa(x0, c, qp, 256);
        q = qp[0];
        x0 = this.procedure_Aa(x0, c, qp, 512);
        Q = qp[0];
        v0 = new BigInteger[33];
        y = v0;
        v0[0] = new BigInteger(Long.toString(x0));
        while (true) {
            for (j = 0; j < 32; ++j) {
                y[j + 1] = y[j].multiply(constA32).add(C).mod(GOST3410ParametersGenerator.TWO.pow(32));
            }
            Y = new BigInteger("0");
            for (j = 0; j < 32; ++j) {
                Y = Y.add(y[j].multiply(GOST3410ParametersGenerator.TWO.pow(j * 32)));
            }
            y[0] = y[32];
            N = GOST3410ParametersGenerator.TWO.pow(1023).divide(q.multiply(Q)).add(GOST3410ParametersGenerator.TWO.pow(1023).multiply(Y).divide(q.multiply(Q).multiply(GOST3410ParametersGenerator.TWO.pow(1024))));
            if (N.mod(GOST3410ParametersGenerator.TWO).compareTo(GOST3410ParametersGenerator.ONE) == 0) {
                N = N.add(GOST3410ParametersGenerator.ONE);
            }
            k = 0;
            while (true) {
                if ((p = q.multiply(Q).multiply(N.add(BigInteger.valueOf(k))).add(GOST3410ParametersGenerator.ONE)).compareTo(GOST3410ParametersGenerator.TWO.pow(1024)) == 1) ** continue;
                if (GOST3410ParametersGenerator.TWO.modPow(q.multiply(Q).multiply(N.add(BigInteger.valueOf(k))), p).compareTo(GOST3410ParametersGenerator.ONE) == 0 && GOST3410ParametersGenerator.TWO.modPow(q.multiply(N.add(BigInteger.valueOf(k))), p).compareTo(GOST3410ParametersGenerator.ONE) != 0) {
                    pq[0] = p;
                    pq[1] = q;
                    return;
                }
                k += 2;
            }
            break;
        }
    }

    private BigInteger procedure_C(BigInteger p2, BigInteger q2) {
        BigInteger a2;
        BigInteger d2;
        BigInteger pSub1 = p2.subtract(ONE);
        BigInteger pSub1DivQ = pSub1.divide(q2);
        int length = p2.bitLength();
        while ((d2 = new BigInteger(length, this.init_random)).compareTo(ONE) <= 0 || d2.compareTo(pSub1) >= 0 || (a2 = d2.modPow(pSub1DivQ, p2)).compareTo(ONE) == 0) {
        }
        return a2;
    }

    public GOST3410Parameters generateParameters() {
        BigInteger[] pq = new BigInteger[2];
        if (this.typeproc == 1) {
            int x0 = this.init_random.nextInt();
            int c2 = this.init_random.nextInt();
            switch (this.size) {
                case 512: {
                    this.procedure_A(x0, c2, pq, 512);
                    break;
                }
                case 1024: {
                    this.procedure_B(x0, c2, pq);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Ooops! key size 512 or 1024 bit.");
                }
            }
            BigInteger p2 = pq[0];
            BigInteger q2 = pq[1];
            BigInteger a2 = this.procedure_C(p2, q2);
            return new GOST3410Parameters(p2, q2, a2, new GOST3410ValidationParameters(x0, c2));
        }
        long x0L = this.init_random.nextLong();
        long cL = this.init_random.nextLong();
        switch (this.size) {
            case 512: {
                this.procedure_Aa(x0L, cL, pq, 512);
                break;
            }
            case 1024: {
                this.procedure_Bb(x0L, cL, pq);
                break;
            }
            default: {
                throw new IllegalStateException("Ooops! key size 512 or 1024 bit.");
            }
        }
        BigInteger p2 = pq[0];
        BigInteger q2 = pq[1];
        BigInteger a2 = this.procedure_C(p2, q2);
        return new GOST3410Parameters(p2, q2, a2, new GOST3410ValidationParameters(x0L, cL));
    }
}

