/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.signers;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DSA;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSASigner
implements DSA {
    DSAKeyParameters key;
    SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (DSAPrivateKeyParameters)rParam.getParameters();
                return;
            }
            this.random = new SecureRandom();
            this.key = (DSAPrivateKeyParameters)param;
            return;
        }
        this.key = (DSAPublicKeyParameters)param;
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger k2;
        DSAParameters params = this.key.getParameters();
        BigInteger m2 = this.calculateE(params.getQ(), message);
        int qBitLength = params.getQ().bitLength();
        while ((k2 = new BigInteger(qBitLength, this.random)).compareTo(params.getQ()) >= 0) {
        }
        BigInteger r2 = params.getG().modPow(k2, params.getP()).mod(params.getQ());
        k2 = k2.modInverse(params.getQ()).multiply(m2.add(((DSAPrivateKeyParameters)this.key).getX().multiply(r2)));
        BigInteger s2 = k2.mod(params.getQ());
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger[] res = bigIntegerArray;
        bigIntegerArray[0] = r2;
        res[1] = s2;
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        DSAParameters params = this.key.getParameters();
        BigInteger m2 = this.calculateE(params.getQ(), message);
        BigInteger zero = BigInteger.valueOf(0L);
        if (zero.compareTo(r2) >= 0 || params.getQ().compareTo(r2) <= 0) {
            return false;
        }
        if (zero.compareTo(s2) >= 0 || params.getQ().compareTo(s2) <= 0) {
            return false;
        }
        BigInteger w2 = s2.modInverse(params.getQ());
        BigInteger u1 = m2.multiply(w2).mod(params.getQ());
        BigInteger u2 = r2.multiply(w2).mod(params.getQ());
        u1 = params.getG().modPow(u1, params.getP());
        u2 = ((DSAPublicKeyParameters)this.key).getY().modPow(u2, params.getP());
        BigInteger v2 = u1.multiply(u2).mod(params.getP()).mod(params.getQ());
        return v2.equals(r2);
    }

    private BigInteger calculateE(BigInteger n2, byte[] message) {
        if (n2.bitLength() >= message.length << 3) {
            return new BigInteger(1, message);
        }
        byte[] trunc = new byte[n2.bitLength() / 8];
        System.arraycopy(message, 0, trunc, 0, trunc.length);
        return new BigInteger(1, trunc);
    }
}

