/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric;

import com.timevale.tgtext.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.crypto.CipherKeyGenerator;
import com.timevale.tgtext.bouncycastle.crypto.engines.GOST28147Engine;
import com.timevale.tgtext.bouncycastle.crypto.macs.GOST28147Mac;
import com.timevale.tgtext.bouncycastle.crypto.modes.CBCBlockCipher;
import com.timevale.tgtext.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import com.timevale.tgtext.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class GOST28147 {
    private GOST28147() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = GOST28147.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.GOST28147", PREFIX + "$ECB");
            provider.addAlgorithm("Alg.Alias.Cipher.GOST", "GOST28147");
            provider.addAlgorithm("Alg.Alias.Cipher.GOST-28147", "GOST28147");
            provider.addAlgorithm("Cipher." + CryptoProObjectIdentifiers.gostR28147_cbc, PREFIX + "$CBC");
            provider.addAlgorithm("KeyGenerator.GOST28147", PREFIX + "$KeyGen");
            provider.addAlgorithm("Alg.Alias.KeyGenerator.GOST", "GOST28147");
            provider.addAlgorithm("Alg.Alias.KeyGenerator.GOST-28147", "GOST28147");
            provider.addAlgorithm("Alg.Alias.KeyGenerator." + CryptoProObjectIdentifiers.gostR28147_cbc, "GOST28147");
            provider.addAlgorithm("Mac.GOST28147MAC", PREFIX + "$Mac");
            provider.addAlgorithm("Alg.Alias.Mac.GOST28147", "GOST28147MAC");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "GOST IV";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for AES parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("GOST28147", BouncyCastleProvider.PROVIDER_NAME);
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e2) {
                throw new RuntimeException(e2.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int keySize) {
            super("GOST28147", keySize, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new GOST28147Mac());
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new GOST28147Engine()), 64);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new GOST28147Engine());
        }
    }
}

