/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.CertStatus;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.RevokedInfo;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.SingleResponse;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import com.timevale.tgtext.bouncycastle.ocsp.CertificateID;
import com.timevale.tgtext.bouncycastle.ocsp.RevokedStatus;
import com.timevale.tgtext.bouncycastle.ocsp.UnknownStatus;
import java.security.cert.X509Extension;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class SingleResp
implements X509Extension {
    SingleResponse resp;

    public SingleResp(SingleResponse resp) {
        this.resp = resp;
    }

    public CertificateID getCertID() {
        return new CertificateID(this.resp.getCertID());
    }

    public Object getCertStatus() {
        CertStatus s2 = this.resp.getCertStatus();
        if (s2.getTagNo() == 0) {
            return null;
        }
        if (s2.getTagNo() == 1) {
            return new RevokedStatus(RevokedInfo.getInstance(s2.getStatus()));
        }
        return new UnknownStatus();
    }

    public Date getThisUpdate() {
        try {
            return this.resp.getThisUpdate().getDate();
        }
        catch (ParseException e2) {
            throw new IllegalStateException("ParseException: " + e2.getMessage());
        }
    }

    public Date getNextUpdate() {
        if (this.resp.getNextUpdate() == null) {
            return null;
        }
        try {
            return this.resp.getNextUpdate().getDate();
        }
        catch (ParseException e2) {
            throw new IllegalStateException("ParseException: " + e2.getMessage());
        }
    }

    public X509Extensions getSingleExtensions() {
        return X509Extensions.getInstance(this.resp.getSingleExtensions());
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        HashSet<String> set = new HashSet<String>();
        X509Extensions extensions = this.getSingleExtensions();
        if (extensions != null) {
            Enumeration e2 = extensions.oids();
            while (e2.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e2.nextElement();
                com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
        }
        return set;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension ext;
        X509Extensions exts = this.getSingleExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            try {
                return ext.getValue().getEncoded("DER");
            }
            catch (Exception e2) {
                throw new RuntimeException("error encoding " + e2.toString());
            }
        }
        return null;
    }
}

