/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.crmf;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.EnvelopedData;
import com.timevale.tgtext.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.crmf.EncryptedKey;
import com.timevale.tgtext.bouncycastle.asn1.crmf.PKIArchiveOptions;
import com.timevale.tgtext.bouncycastle.cert.crmf.CRMFException;
import com.timevale.tgtext.bouncycastle.cert.crmf.Control;
import com.timevale.tgtext.bouncycastle.cms.CMSEnvelopedData;
import com.timevale.tgtext.bouncycastle.cms.CMSException;

public class PKIArchiveControl
implements Control {
    public static final int encryptedPrivKey = 0;
    public static final int keyGenParameters = 1;
    public static final int archiveRemGenPrivKey = 2;
    private static final ASN1ObjectIdentifier type = CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions;
    private final PKIArchiveOptions pkiArchiveOptions;

    public PKIArchiveControl(PKIArchiveOptions pkiArchiveOptions) {
        this.pkiArchiveOptions = pkiArchiveOptions;
    }

    @Override
    public ASN1ObjectIdentifier getType() {
        return type;
    }

    @Override
    public ASN1Encodable getValue() {
        return this.pkiArchiveOptions;
    }

    public int getArchiveType() {
        return this.pkiArchiveOptions.getType();
    }

    public boolean isEnvelopedData() {
        EncryptedKey encKey = EncryptedKey.getInstance(this.pkiArchiveOptions.getValue());
        return !encKey.isEncryptedValue();
    }

    public CMSEnvelopedData getEnvelopedData() throws CRMFException {
        try {
            EncryptedKey encKey = EncryptedKey.getInstance(this.pkiArchiveOptions.getValue());
            EnvelopedData data = EnvelopedData.getInstance(encKey.getValue());
            return new CMSEnvelopedData(new ContentInfo(CMSObjectIdentifiers.envelopedData, data));
        }
        catch (CMSException e2) {
            throw new CRMFException("CMS parsing error: " + e2.getMessage(), e2.getCause());
        }
        catch (Exception e3) {
            throw new CRMFException("CRMF parsing error: " + e3.getMessage(), e3);
        }
    }
}

