/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.RandUtils;
import java.security.SecureRandom;

public class GF2mField {
    private int degree = 0;
    private int polynomial;

    public GF2mField(int degree) {
        if (degree >= 32) {
            throw new IllegalArgumentException(" Error: the degree of field is too large ");
        }
        if (degree <= 0) {
            throw new IllegalArgumentException(" Error: the degree of field is non-positive ");
        }
        this.degree = degree;
        this.polynomial = PolynomialRingGF2.getIrreduciblePolynomial(degree);
    }

    public GF2mField(int degree, int poly) {
        if (degree != PolynomialRingGF2.degree(poly)) {
            throw new IllegalArgumentException(" Error: the degree is not correct");
        }
        if (!PolynomialRingGF2.isIrreducible(poly)) {
            throw new IllegalArgumentException(" Error: given polynomial is reducible");
        }
        this.degree = degree;
        this.polynomial = poly;
    }

    public GF2mField(byte[] enc) {
        if (enc.length != 4) {
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        this.polynomial = LittleEndianConversions.OS2IP(enc);
        if (!PolynomialRingGF2.isIrreducible(this.polynomial)) {
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        this.degree = PolynomialRingGF2.degree(this.polynomial);
    }

    public GF2mField(GF2mField field) {
        this.degree = field.degree;
        this.polynomial = field.polynomial;
    }

    public int getDegree() {
        return this.degree;
    }

    public int getPolynomial() {
        return this.polynomial;
    }

    public byte[] getEncoded() {
        return LittleEndianConversions.I2OSP(this.polynomial);
    }

    public int add(int a2, int b2) {
        return a2 ^ b2;
    }

    public int mult(int a2, int b2) {
        return PolynomialRingGF2.modMultiply(a2, b2, this.polynomial);
    }

    public int exp(int a2, int k2) {
        if (a2 == 0) {
            return 0;
        }
        if (a2 == 1) {
            return 1;
        }
        int result = 1;
        if (k2 < 0) {
            a2 = this.inverse(a2);
            k2 = -k2;
        }
        while (k2 != 0) {
            if ((k2 & 1) == 1) {
                result = this.mult(result, a2);
            }
            a2 = this.mult(a2, a2);
            k2 >>>= 1;
        }
        return result;
    }

    public int inverse(int a2) {
        int d2 = (1 << this.degree) - 2;
        return this.exp(a2, d2);
    }

    public int sqRoot(int a2) {
        for (int i2 = 1; i2 < this.degree; ++i2) {
            a2 = this.mult(a2, a2);
        }
        return a2;
    }

    public int getRandomElement(SecureRandom sr) {
        int result = RandUtils.nextInt(sr, 1 << this.degree);
        return result;
    }

    public int getRandomNonZeroElement() {
        return this.getRandomNonZeroElement(new SecureRandom());
    }

    public int getRandomNonZeroElement(SecureRandom sr) {
        int count;
        int result = RandUtils.nextInt(sr, 1 << this.degree);
        for (count = 0; result == 0 && count < 0x100000; ++count) {
            result = RandUtils.nextInt(sr, 1 << this.degree);
        }
        if (count == 0x100000) {
            result = 1;
        }
        return result;
    }

    public boolean isElementOfThisField(int e2) {
        if (this.degree == 31) {
            return e2 >= 0;
        }
        return e2 >= 0 && e2 < 1 << this.degree;
    }

    public String elementToStr(int a2) {
        String s2 = "";
        for (int i2 = 0; i2 < this.degree; ++i2) {
            s2 = ((byte)a2 & 1) == 0 ? "0" + s2 : "1" + s2;
            a2 >>>= 1;
        }
        return s2;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2mField)) {
            return false;
        }
        GF2mField otherField = (GF2mField)other;
        return this.degree == otherField.degree && this.polynomial == otherField.polynomial;
    }

    public int hashCode() {
        return this.polynomial;
    }

    public String toString() {
        String str = "Finite Field GF(2^" + this.degree + ") = GF(2)[X]/<" + GF2mField.polyToString(this.polynomial) + "> ";
        return str;
    }

    private static String polyToString(int p2) {
        String str = "";
        if (p2 == 0) {
            str = "0";
        } else {
            byte b2 = (byte)(p2 & 1);
            if (b2 == 1) {
                str = "1";
            }
            p2 >>>= 1;
            int i2 = 1;
            while (p2 != 0) {
                b2 = (byte)(p2 & 1);
                if (b2 == 1) {
                    str = str + "+x^" + i2;
                }
                p2 >>>= 1;
                ++i2;
            }
        }
        return str;
    }
}

