/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.tsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Boolean;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1GeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.tsp.Accuracy;
import com.timevale.tgtext.bouncycastle.asn1.tsp.MessageImprint;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import java.util.Enumeration;

public class TSTInfo
extends ASN1Object {
    private ASN1Integer version;
    private ASN1ObjectIdentifier tsaPolicyId;
    private MessageImprint messageImprint;
    private ASN1Integer serialNumber;
    private ASN1GeneralizedTime genTime;
    private Accuracy accuracy;
    private ASN1Boolean ordering;
    private ASN1Integer nonce;
    private GeneralName tsa;
    private Extensions extensions;

    public static TSTInfo getInstance(Object o2) {
        if (o2 instanceof TSTInfo) {
            return (TSTInfo)o2;
        }
        if (o2 != null) {
            return new TSTInfo(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private TSTInfo(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        this.version = ASN1Integer.getInstance(e2.nextElement());
        this.tsaPolicyId = ASN1ObjectIdentifier.getInstance(e2.nextElement());
        this.messageImprint = MessageImprint.getInstance(e2.nextElement());
        this.serialNumber = ASN1Integer.getInstance(e2.nextElement());
        this.genTime = ASN1GeneralizedTime.getInstance(e2.nextElement());
        this.ordering = ASN1Boolean.getInstance(false);
        block4: while (e2.hasMoreElements()) {
            ASN1Object o2 = (ASN1Object)e2.nextElement();
            if (o2 instanceof ASN1TaggedObject) {
                DERTaggedObject tagged = (DERTaggedObject)o2;
                switch (tagged.getTagNo()) {
                    case 0: {
                        this.tsa = GeneralName.getInstance(tagged, true);
                        continue block4;
                    }
                    case 1: {
                        this.extensions = Extensions.getInstance(tagged, false);
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Unknown tag value " + tagged.getTagNo());
            }
            if (o2 instanceof ASN1Sequence || o2 instanceof Accuracy) {
                this.accuracy = Accuracy.getInstance(o2);
                continue;
            }
            if (o2 instanceof ASN1Boolean) {
                this.ordering = ASN1Boolean.getInstance(o2);
                continue;
            }
            if (!(o2 instanceof ASN1Integer)) continue;
            this.nonce = ASN1Integer.getInstance(o2);
        }
    }

    public TSTInfo(ASN1ObjectIdentifier tsaPolicyId, MessageImprint messageImprint, ASN1Integer serialNumber, ASN1GeneralizedTime genTime, Accuracy accuracy, ASN1Boolean ordering, ASN1Integer nonce, GeneralName tsa, Extensions extensions) {
        this.version = new ASN1Integer(1L);
        this.tsaPolicyId = tsaPolicyId;
        this.messageImprint = messageImprint;
        this.serialNumber = serialNumber;
        this.genTime = genTime;
        this.accuracy = accuracy;
        this.ordering = ordering;
        this.nonce = nonce;
        this.tsa = tsa;
        this.extensions = extensions;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public ASN1ObjectIdentifier getPolicy() {
        return this.tsaPolicyId;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public Accuracy getAccuracy() {
        return this.accuracy;
    }

    public ASN1GeneralizedTime getGenTime() {
        return this.genTime;
    }

    public ASN1Boolean getOrdering() {
        return this.ordering;
    }

    public ASN1Integer getNonce() {
        return this.nonce;
    }

    public GeneralName getTsa() {
        return this.tsa;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector seq = new ASN1EncodableVector();
        seq.add(this.version);
        seq.add(this.tsaPolicyId);
        seq.add(this.messageImprint);
        seq.add(this.serialNumber);
        seq.add(this.genTime);
        if (this.accuracy != null) {
            seq.add(this.accuracy);
        }
        if (this.ordering != null && this.ordering.isTrue()) {
            seq.add(this.ordering);
        }
        if (this.nonce != null) {
            seq.add(this.nonce);
        }
        if (this.tsa != null) {
            seq.add(new DERTaggedObject(true, 0, this.tsa));
        }
        if (this.extensions != null) {
            seq.add(new DERTaggedObject(false, 1, this.extensions));
        }
        return new DERSequence(seq);
    }
}

