/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttCertIssuer;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import com.timevale.tgtext.bouncycastle.asn1.x509.V2Form;
import com.timevale.tgtext.bouncycastle.jce.X509Principal;
import com.timevale.tgtext.bouncycastle.util.Selector;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class AttributeCertificateIssuer
implements Selector,
CertSelector {
    final ASN1Encodable form;

    public AttributeCertificateIssuer(AttCertIssuer issuer) {
        this.form = issuer.getIssuer();
    }

    public AttributeCertificateIssuer(X500Principal principal) throws IOException {
        this(new X509Principal(principal.getEncoded()));
    }

    public AttributeCertificateIssuer(X509Principal principal) {
        this.form = new V2Form(GeneralNames.getInstance(new DERSequence(new GeneralName(principal))));
    }

    private Object[] getNames() {
        GeneralNames name = this.form instanceof V2Form ? ((V2Form)this.form).getIssuerName() : (GeneralNames)this.form;
        GeneralName[] names = name.getNames();
        ArrayList<X500Principal> l2 = new ArrayList<X500Principal>(names.length);
        for (int i2 = 0; i2 != names.length; ++i2) {
            if (names[i2].getTagNo() != 4) continue;
            try {
                l2.add(new X500Principal(names[i2].getName().toASN1Primitive().getEncoded()));
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("badly formed Name object");
            }
        }
        return l2.toArray(new Object[l2.size()]);
    }

    public Principal[] getPrincipals() {
        Object[] p2 = this.getNames();
        ArrayList<Object> l2 = new ArrayList<Object>();
        for (int i2 = 0; i2 != p2.length; ++i2) {
            if (!(p2[i2] instanceof Principal)) continue;
            l2.add(p2[i2]);
        }
        return l2.toArray(new Principal[l2.size()]);
    }

    private boolean matchesDN(X500Principal subject, GeneralNames targets) {
        GeneralName[] names = targets.getNames();
        for (int i2 = 0; i2 != names.length; ++i2) {
            GeneralName gn = names[i2];
            if (gn.getTagNo() != 4) continue;
            try {
                if (!new X500Principal(gn.getName().toASN1Primitive().getEncoded()).equals(subject)) continue;
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    @Override
    public Object clone() {
        return new AttributeCertificateIssuer(AttCertIssuer.getInstance(this.form));
    }

    @Override
    public boolean match(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Cert = (X509Certificate)cert;
        if (this.form instanceof V2Form) {
            V2Form issuer = (V2Form)this.form;
            if (issuer.getBaseCertificateID() != null) {
                return issuer.getBaseCertificateID().getSerial().getValue().equals(x509Cert.getSerialNumber()) && this.matchesDN(x509Cert.getIssuerX500Principal(), issuer.getBaseCertificateID().getIssuer());
            }
            GeneralNames name = issuer.getIssuerName();
            if (this.matchesDN(x509Cert.getSubjectX500Principal(), name)) {
                return true;
            }
        } else {
            GeneralNames name = (GeneralNames)this.form;
            if (this.matchesDN(x509Cert.getSubjectX500Principal(), name)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributeCertificateIssuer)) {
            return false;
        }
        AttributeCertificateIssuer other = (AttributeCertificateIssuer)obj;
        return this.form.equals(other.form);
    }

    public int hashCode() {
        return this.form.hashCode();
    }

    @Override
    public boolean match(Object obj) {
        if (!(obj instanceof X509Certificate)) {
            return false;
        }
        return this.match((Certificate)obj);
    }
}

