/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ntru.polynomial;

import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.BigIntPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.TernaryPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.util.ArrayEncoder;
import com.timevale.tgtext.bouncycastle.math.ntru.util.Util;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SparseTernaryPolynomial
implements TernaryPolynomial {
    private static final int BITS_PER_INDEX = 11;
    private int N;
    private int[] ones;
    private int[] negOnes;

    SparseTernaryPolynomial(int N, int[] ones, int[] negOnes) {
        this.N = N;
        this.ones = ones;
        this.negOnes = negOnes;
    }

    public SparseTernaryPolynomial(IntegerPolynomial intPoly) {
        this(intPoly.coeffs);
    }

    public SparseTernaryPolynomial(int[] coeffs) {
        this.N = coeffs.length;
        this.ones = new int[this.N];
        this.negOnes = new int[this.N];
        int onesIdx = 0;
        int negOnesIdx = 0;
        block5: for (int i2 = 0; i2 < this.N; ++i2) {
            int c2 = coeffs[i2];
            switch (c2) {
                case 1: {
                    this.ones[onesIdx++] = i2;
                    continue block5;
                }
                case -1: {
                    this.negOnes[negOnesIdx++] = i2;
                    continue block5;
                }
                case 0: {
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value: " + c2 + ", must be one of {-1, 0, 1}");
                }
            }
        }
        this.ones = Arrays.copyOf(this.ones, onesIdx);
        this.negOnes = Arrays.copyOf(this.negOnes, negOnesIdx);
    }

    public static SparseTernaryPolynomial fromBinary(InputStream is, int N, int numOnes, int numNegOnes) throws IOException {
        int bitsPerIndex = 32 - Integer.numberOfLeadingZeros(2047);
        int data1Len = (numOnes * bitsPerIndex + 7) / 8;
        byte[] data1 = Util.readFullLength(is, data1Len);
        int[] ones = ArrayEncoder.decodeModQ(data1, numOnes, 2048);
        int data2Len = (numNegOnes * bitsPerIndex + 7) / 8;
        byte[] data2 = Util.readFullLength(is, data2Len);
        int[] negOnes = ArrayEncoder.decodeModQ(data2, numNegOnes, 2048);
        return new SparseTernaryPolynomial(N, ones, negOnes);
    }

    public static SparseTernaryPolynomial generateRandom(int N, int numOnes, int numNegOnes, SecureRandom random) {
        int[] coeffs = Util.generateRandomTernary(N, numOnes, numNegOnes, random);
        return new SparseTernaryPolynomial(coeffs);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2) {
        int k2;
        int j2;
        int i2;
        int idx;
        int[] b2 = poly2.coeffs;
        if (poly2.coeffs.length != this.N) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        int[] c2 = new int[this.N];
        for (idx = 0; idx != this.ones.length; ++idx) {
            i2 = this.ones[idx];
            j2 = this.N - 1 - i2;
            for (k2 = this.N - 1; k2 >= 0; --k2) {
                int n2 = k2;
                c2[n2] = c2[n2] + b2[j2];
                if (--j2 >= 0) continue;
                j2 = this.N - 1;
            }
        }
        for (idx = 0; idx != this.negOnes.length; ++idx) {
            i2 = this.negOnes[idx];
            j2 = this.N - 1 - i2;
            for (k2 = this.N - 1; k2 >= 0; --k2) {
                int n3 = k2;
                c2[n3] = c2[n3] - b2[j2];
                if (--j2 >= 0) continue;
                j2 = this.N - 1;
            }
        }
        return new IntegerPolynomial(c2);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2, int modulus) {
        IntegerPolynomial c2 = this.mult(poly2);
        c2.mod(modulus);
        return c2;
    }

    @Override
    public BigIntPolynomial mult(BigIntPolynomial poly2) {
        int k2;
        int j2;
        int i2;
        int idx;
        BigInteger[] b2 = poly2.coeffs;
        if (poly2.coeffs.length != this.N) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        BigInteger[] c2 = new BigInteger[this.N];
        for (int i3 = 0; i3 < this.N; ++i3) {
            c2[i3] = BigInteger.ZERO;
        }
        for (idx = 0; idx != this.ones.length; ++idx) {
            i2 = this.ones[idx];
            j2 = this.N - 1 - i2;
            for (k2 = this.N - 1; k2 >= 0; --k2) {
                c2[k2] = c2[k2].add(b2[j2]);
                if (--j2 >= 0) continue;
                j2 = this.N - 1;
            }
        }
        for (idx = 0; idx != this.negOnes.length; ++idx) {
            i2 = this.negOnes[idx];
            j2 = this.N - 1 - i2;
            for (k2 = this.N - 1; k2 >= 0; --k2) {
                c2[k2] = c2[k2].subtract(b2[j2]);
                if (--j2 >= 0) continue;
                j2 = this.N - 1;
            }
        }
        return new BigIntPolynomial(c2);
    }

    @Override
    public int[] getOnes() {
        return this.ones;
    }

    @Override
    public int[] getNegOnes() {
        return this.negOnes;
    }

    public byte[] toBinary() {
        byte[] bin1 = ArrayEncoder.encodeModQ(this.ones, 2048);
        byte[] bin2 = ArrayEncoder.encodeModQ(this.negOnes, 2048);
        byte[] bin = Arrays.copyOf(bin1, bin1.length + bin2.length);
        System.arraycopy(bin2, 0, bin, bin1.length, bin2.length);
        return bin;
    }

    @Override
    public IntegerPolynomial toIntegerPolynomial() {
        int i2;
        int idx;
        int[] coeffs = new int[this.N];
        for (idx = 0; idx != this.ones.length; ++idx) {
            i2 = this.ones[idx];
            coeffs[i2] = 1;
        }
        for (idx = 0; idx != this.negOnes.length; ++idx) {
            i2 = this.negOnes[idx];
            coeffs[i2] = -1;
        }
        return new IntegerPolynomial(coeffs);
    }

    @Override
    public int size() {
        return this.N;
    }

    @Override
    public void clear() {
        int i2;
        for (i2 = 0; i2 < this.ones.length; ++i2) {
            this.ones[i2] = 0;
        }
        for (i2 = 0; i2 < this.negOnes.length; ++i2) {
            this.negOnes[i2] = 0;
        }
    }

    public int hashCode() {
        int result = 31 + this.N;
        result = result * 31 + Arrays.hashCode(this.negOnes);
        result = result * 31 + Arrays.hashCode(this.ones);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseTernaryPolynomial other = (SparseTernaryPolynomial)obj;
        if (this.N != other.N) {
            return false;
        }
        if (!Arrays.areEqual(this.negOnes, other.negOnes)) {
            return false;
        }
        return Arrays.areEqual(this.ones, other.ones);
    }
}

