/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Exception;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.BERApplicationSpecificParser;
import com.timevale.tgtext.bouncycastle.asn1.BEROctetStringParser;
import com.timevale.tgtext.bouncycastle.asn1.BERSequenceParser;
import com.timevale.tgtext.bouncycastle.asn1.BERSetParser;
import com.timevale.tgtext.bouncycastle.asn1.BERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.BERTaggedObjectParser;
import com.timevale.tgtext.bouncycastle.asn1.DERApplicationSpecific;
import com.timevale.tgtext.bouncycastle.asn1.DERExternalParser;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetStringParser;
import com.timevale.tgtext.bouncycastle.asn1.DERSequenceParser;
import com.timevale.tgtext.bouncycastle.asn1.DERSetParser;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.InMemoryRepresentable;
import com.timevale.tgtext.bouncycastle.asn1.a;
import com.timevale.tgtext.bouncycastle.asn1.c;
import com.timevale.tgtext.bouncycastle.asn1.d;
import com.timevale.tgtext.bouncycastle.asn1.e;
import com.timevale.tgtext.bouncycastle.asn1.i;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;
    private final byte[][] tmpBuffers;

    public ASN1StreamParser(InputStream in) {
        this(in, i.a(in));
    }

    public ASN1StreamParser(InputStream in, int limit) {
        this._in = in;
        this._limit = limit;
        this.tmpBuffers = new byte[11][];
    }

    public ASN1StreamParser(byte[] encoding) {
        this(new ByteArrayInputStream(encoding), encoding.length);
    }

    ASN1Encodable readIndef(int tagValue) throws IOException {
        switch (tagValue) {
            case 8: {
                return new DERExternalParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 16: {
                return new BERSequenceParser(this);
            }
            case 17: {
                return new BERSetParser(this);
            }
        }
        throw new ASN1Exception("unknown BER object encountered: 0x" + Integer.toHexString(tagValue));
    }

    ASN1Encodable readImplicit(boolean constructed, int tag) throws IOException {
        if (this._in instanceof e) {
            if (!constructed) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            return this.readIndef(tag);
        }
        if (constructed) {
            switch (tag) {
                case 17: {
                    return new DERSetParser(this);
                }
                case 16: {
                    return new DERSequenceParser(this);
                }
                case 4: {
                    return new BEROctetStringParser(this);
                }
            }
        } else {
            switch (tag) {
                case 17: {
                    throw new ASN1Exception("sequences must use constructed encoding (see X.690 8.9.1/8.10.1)");
                }
                case 16: {
                    throw new ASN1Exception("sets must use constructed encoding (see X.690 8.11.1/8.12.1)");
                }
                case 4: {
                    return new DEROctetStringParser((d)this._in);
                }
            }
        }
        throw new RuntimeException("implicit tagging not implemented");
    }

    ASN1Primitive readTaggedObject(boolean constructed, int tag) throws IOException {
        if (!constructed) {
            d defIn = (d)this._in;
            return new DERTaggedObject(false, tag, new DEROctetString(defIn.b()));
        }
        ASN1EncodableVector v2 = this.readVector();
        if (this._in instanceof e) {
            if (v2.size() == 1) {
                return new BERTaggedObject(true, tag, v2.get(0));
            }
            return new BERTaggedObject(false, tag, a.a(v2));
        }
        if (v2.size() == 1) {
            return new DERTaggedObject(true, tag, v2.get(0));
        }
        return new DERTaggedObject(false, tag, c.a(v2));
    }

    public ASN1Encodable readObject() throws IOException {
        int tag = this._in.read();
        if (tag == -1) {
            return null;
        }
        this.set00Check(false);
        int tagNo = ASN1InputStream.readTagNumber(this._in, tag);
        boolean isConstructed = (tag & 0x20) != 0;
        int length = ASN1InputStream.readLength(this._in, this._limit);
        if (length < 0) {
            if (!isConstructed) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            e indIn = new e(this._in, this._limit);
            ASN1StreamParser sp = new ASN1StreamParser(indIn, this._limit);
            if ((tag & 0x40) != 0) {
                return new BERApplicationSpecificParser(tagNo, sp);
            }
            if ((tag & 0x80) != 0) {
                return new BERTaggedObjectParser(true, tagNo, sp);
            }
            return sp.readIndef(tagNo);
        }
        d defIn = new d(this._in, length);
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(isConstructed, tagNo, defIn.b());
        }
        if ((tag & 0x80) != 0) {
            return new BERTaggedObjectParser(isConstructed, tagNo, new ASN1StreamParser(defIn));
        }
        if (isConstructed) {
            switch (tagNo) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser(defIn));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser(defIn));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser(defIn));
                }
                case 8: {
                    return new DERExternalParser(new ASN1StreamParser(defIn));
                }
            }
            throw new IOException("unknown tag " + tagNo + " encountered");
        }
        switch (tagNo) {
            case 4: {
                return new DEROctetStringParser(defIn);
            }
        }
        try {
            return ASN1InputStream.createPrimitiveDERObject(tagNo, defIn, this.tmpBuffers);
        }
        catch (IllegalArgumentException e2) {
            throw new ASN1Exception("corrupted stream detected", e2);
        }
    }

    private void set00Check(boolean enabled) {
        if (this._in instanceof e) {
            ((e)this._in).a(enabled);
        }
    }

    ASN1EncodableVector readVector() throws IOException {
        ASN1Encodable obj;
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        while ((obj = this.readObject()) != null) {
            if (obj instanceof InMemoryRepresentable) {
                v2.add(((InMemoryRepresentable)((Object)obj)).getLoadedObject());
                continue;
            }
            v2.add(obj.toASN1Primitive());
        }
        return v2;
    }
}

