/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

public final class LittleEndianConversions {
    private LittleEndianConversions() {
    }

    public static int OS2IP(byte[] input) {
        return input[0] & 0xFF | (input[1] & 0xFF) << 8 | (input[2] & 0xFF) << 16 | (input[3] & 0xFF) << 24;
    }

    public static int OS2IP(byte[] input, int inOff) {
        int result = input[inOff++] & 0xFF;
        result |= (input[inOff++] & 0xFF) << 8;
        result |= (input[inOff++] & 0xFF) << 16;
        return result |= (input[inOff] & 0xFF) << 24;
    }

    public static int OS2IP(byte[] input, int inOff, int inLen) {
        int result = 0;
        for (int i2 = inLen - 1; i2 >= 0; --i2) {
            result |= (input[inOff + i2] & 0xFF) << i2 * 8;
        }
        return result;
    }

    public static long OS2LIP(byte[] input, int inOff) {
        long result = input[inOff++] & 0xFF;
        result |= (long)((input[inOff++] & 0xFF) << 8);
        result |= (long)((input[inOff++] & 0xFF) << 16);
        result |= ((long)input[inOff++] & 0xFFL) << 24;
        result |= ((long)input[inOff++] & 0xFFL) << 32;
        result |= ((long)input[inOff++] & 0xFFL) << 40;
        result |= ((long)input[inOff++] & 0xFFL) << 48;
        return result |= ((long)input[inOff] & 0xFFL) << 56;
    }

    public static byte[] I2OSP(int x2) {
        byte[] byArray = new byte[4];
        byte[] result = byArray;
        byArray[0] = (byte)x2;
        result[1] = (byte)(x2 >>> 8);
        result[2] = (byte)(x2 >>> 16);
        result[3] = x2 >> 24;
        return result;
    }

    public static void I2OSP(int value, byte[] output, int outOff) {
        output[outOff++] = (byte)value;
        output[outOff++] = (byte)(value >>> 8);
        output[outOff++] = (byte)(value >>> 16);
        output[outOff] = value >> 24;
    }

    public static void I2OSP(int value, byte[] output, int outOff, int outLen) {
        for (int i2 = outLen - 1; i2 >= 0; --i2) {
            output[outOff + i2] = (byte)(value >>> i2 * 8);
        }
    }

    public static byte[] I2OSP(long input) {
        byte[] byArray = new byte[8];
        byte[] output = byArray;
        byArray[0] = (byte)input;
        output[1] = (byte)(input >>> 8);
        output[2] = (byte)(input >>> 16);
        output[3] = (byte)(input >>> 24);
        output[4] = (byte)(input >>> 32);
        output[5] = (byte)(input >>> 40);
        output[6] = (byte)(input >>> 48);
        output[7] = (byte)(input >>> 56);
        return output;
    }

    public static void I2OSP(long input, byte[] output, int outOff) {
        output[outOff++] = (byte)input;
        output[outOff++] = (byte)(input >>> 8);
        output[outOff++] = (byte)(input >>> 16);
        output[outOff++] = (byte)(input >>> 24);
        output[outOff++] = (byte)(input >>> 32);
        output[outOff++] = (byte)(input >>> 40);
        output[outOff++] = (byte)(input >>> 48);
        output[outOff] = (byte)(input >>> 56);
    }

    public static byte[] toByteArray(int[] input, int outLen) {
        int intLen = input.length;
        byte[] result = new byte[outLen];
        int index = 0;
        int i2 = 0;
        while (i2 <= intLen - 2) {
            LittleEndianConversions.I2OSP(input[i2], result, index);
            ++i2;
            index += 4;
        }
        LittleEndianConversions.I2OSP(input[intLen - 1], result, index, outLen - index);
        return result;
    }

    public static int[] toIntArray(byte[] input) {
        int intLen = (input.length + 3) / 4;
        int lastLen = input.length & 3;
        int[] result = new int[intLen];
        int index = 0;
        int i2 = 0;
        while (i2 <= intLen - 2) {
            result[i2] = LittleEndianConversions.OS2IP(input, index);
            ++i2;
            index += 4;
        }
        result[intLen - 1] = lastLen != 0 ? LittleEndianConversions.OS2IP(input, index, lastLen) : LittleEndianConversions.OS2IP(input, index);
        return result;
    }
}

