/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.i;
import java.io.IOException;

public class DLTaggedObject
extends ASN1TaggedObject {
    private static final byte[] ZERO_BYTES = new byte[0];

    public DLTaggedObject(boolean explicit, int tagNo, ASN1Encodable obj) {
        super(explicit, tagNo, obj);
    }

    @Override
    boolean isConstructed() {
        if (!this.empty) {
            if (this.explicit) {
                return true;
            }
            ASN1Primitive primitive = this.obj.toASN1Primitive().toDLObject();
            return primitive.isConstructed();
        }
        return true;
    }

    @Override
    int encodedLength() throws IOException {
        if (!this.empty) {
            int length = this.obj.toASN1Primitive().toDLObject().encodedLength();
            if (this.explicit) {
                return i.b(this.tagNo) + i.a(length) + length;
            }
            return i.b(this.tagNo) + --length;
        }
        return i.b(this.tagNo) + 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void encode(ASN1OutputStream out) throws IOException {
        if (this.empty) {
            out.writeEncoded(160, this.tagNo, ZERO_BYTES);
            return;
        }
        ASN1Primitive primitive = this.obj.toASN1Primitive().toDLObject();
        if (this.explicit) {
            out.writeTag(160, this.tagNo);
            out.writeLength(primitive.encodedLength());
            out.writeObject(primitive);
            return;
        }
        int flags = primitive.isConstructed() ? 160 : 128;
        out.writeTag(flags, this.tagNo);
        out.writeImplicitObject(primitive);
    }
}

