/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.util.encoders;

import com.timevale.tgtext.bouncycastle.util.encoders.Translator;

public class HexTranslator
implements Translator {
    private static final byte[] hexTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    @Override
    public int getEncodedBlockSize() {
        return 2;
    }

    @Override
    public int encode(byte[] in, int inOff, int length, byte[] out, int outOff) {
        int i2 = 0;
        int j2 = 0;
        while (i2 < length) {
            out[outOff + j2] = hexTable[in[inOff] >> 4 & 0xF];
            out[outOff + j2 + 1] = hexTable[in[inOff] & 0xF];
            ++inOff;
            ++i2;
            j2 += 2;
        }
        return length << 1;
    }

    @Override
    public int getDecodedBlockSize() {
        return 1;
    }

    @Override
    public int decode(byte[] in, int inOff, int length, byte[] out, int outOff) {
        int halfLength = length / 2;
        for (int i2 = 0; i2 < halfLength; ++i2) {
            byte left = in[inOff + (i2 << 1)];
            byte right = in[inOff + (i2 << 1) + 1];
            out[outOff] = left < 97 ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 97) {
                int n2 = outOff;
                out[n2] = (byte)(out[n2] + (byte)(right - 48));
            } else {
                int n3 = outOff;
                out[n3] = (byte)(out[n3] + (byte)(right - 97 + 10));
            }
            ++outOff;
        }
        return halfLength;
    }
}

