/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.esf;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.esf.CrlListID;
import com.timevale.tgtext.bouncycastle.asn1.esf.OcspListID;
import com.timevale.tgtext.bouncycastle.asn1.esf.OtherRevRefs;
import java.util.Enumeration;

public class CrlOcspRef
extends ASN1Object {
    private CrlListID crlids;
    private OcspListID ocspids;
    private OtherRevRefs otherRev;

    public static CrlOcspRef getInstance(Object obj) {
        if (obj instanceof CrlOcspRef) {
            return (CrlOcspRef)obj;
        }
        if (obj != null) {
            return new CrlOcspRef(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private CrlOcspRef(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        block5: while (e2.hasMoreElements()) {
            DERTaggedObject o2 = (DERTaggedObject)e2.nextElement();
            switch (o2.getTagNo()) {
                case 0: {
                    this.crlids = CrlListID.getInstance(o2.getObject());
                    continue block5;
                }
                case 1: {
                    this.ocspids = OcspListID.getInstance(o2.getObject());
                    continue block5;
                }
                case 2: {
                    this.otherRev = OtherRevRefs.getInstance(o2.getObject());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("illegal tag");
        }
    }

    public CrlOcspRef(CrlListID crlids, OcspListID ocspids, OtherRevRefs otherRev) {
        this.crlids = crlids;
        this.ocspids = ocspids;
        this.otherRev = otherRev;
    }

    public CrlListID getCrlids() {
        return this.crlids;
    }

    public OcspListID getOcspids() {
        return this.ocspids;
    }

    public OtherRevRefs getOtherRev() {
        return this.otherRev;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.crlids != null) {
            v2.add(new DERTaggedObject(true, 0, this.crlids.toASN1Primitive()));
        }
        if (this.ocspids != null) {
            v2.add(new DERTaggedObject(true, 1, this.ocspids.toASN1Primitive()));
        }
        if (this.otherRev != null) {
            v2.add(new DERTaggedObject(true, 2, this.otherRev.toASN1Primitive()));
        }
        return new DERSequence(v2);
    }
}

