/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import java.math.BigInteger;
import java.util.Random;

public class GF2Polynomial {
    private int len;
    private int blocks;
    private int[] value;
    private static Random rand = new Random();
    private static final boolean[] parity = new boolean[]{false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false};
    private static final short[] squaringTable = new short[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85, 256, 257, 260, 261, 272, 273, 276, 277, 320, 321, 324, 325, 336, 337, 340, 341, 1024, 1025, 1028, 1029, 1040, 1041, 1044, 1045, 1088, 1089, 1092, 1093, 1104, 1105, 1108, 1109, 1280, 1281, 1284, 1285, 1296, 1297, 1300, 1301, 1344, 1345, 1348, 1349, 1360, 1361, 1364, 1365, 4096, 4097, 4100, 4101, 4112, 4113, 4116, 4117, 4160, 4161, 4164, 4165, 4176, 4177, 4180, 4181, 4352, 4353, 4356, 4357, 4368, 4369, 4372, 4373, 4416, 4417, 4420, 4421, 4432, 4433, 4436, 4437, 5120, 5121, 5124, 5125, 5136, 5137, 5140, 5141, 5184, 5185, 5188, 5189, 5200, 5201, 5204, 5205, 5376, 5377, 5380, 5381, 5392, 5393, 5396, 5397, 5440, 5441, 5444, 5445, 5456, 5457, 5460, 5461, 16384, 16385, 16388, 16389, 16400, 16401, 16404, 16405, 16448, 16449, 16452, 16453, 16464, 16465, 16468, 16469, 16640, 16641, 16644, 16645, 16656, 16657, 16660, 16661, 16704, 16705, 16708, 16709, 16720, 16721, 16724, 16725, 17408, 17409, 17412, 17413, 17424, 17425, 17428, 17429, 17472, 17473, 17476, 17477, 17488, 17489, 17492, 17493, 17664, 17665, 17668, 17669, 17680, 17681, 17684, 17685, 17728, 17729, 17732, 17733, 17744, 17745, 17748, 17749, 20480, 20481, 20484, 20485, 20496, 20497, 20500, 20501, 20544, 20545, 20548, 20549, 20560, 20561, 20564, 20565, 20736, 20737, 20740, 20741, 20752, 20753, 20756, 20757, 20800, 20801, 20804, 20805, 20816, 20817, 20820, 20821, 21504, 21505, 21508, 21509, 21520, 21521, 21524, 21525, 21568, 21569, 21572, 21573, 21584, 21585, 21588, 21589, 21760, 21761, 21764, 21765, 21776, 21777, 21780, 21781, 21824, 21825, 21828, 21829, 21840, 21841, 21844, 21845};
    private static final int[] bitMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE, 0};
    private static final int[] reverseRightMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};

    public GF2Polynomial(int length) {
        int l2 = length;
        if (length <= 0) {
            l2 = 1;
        }
        this.blocks = (l2 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = l2;
    }

    public GF2Polynomial(int length, Random rand) {
        int l2 = length;
        if (length <= 0) {
            l2 = 1;
        }
        this.blocks = (l2 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = l2;
        this.randomize(rand);
    }

    public GF2Polynomial(int length, String value) {
        int l2 = length;
        if (length <= 0) {
            l2 = 1;
        }
        this.blocks = (l2 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = l2;
        if (value.equalsIgnoreCase("ZERO")) {
            this.assignZero();
            return;
        }
        if (value.equalsIgnoreCase("ONE")) {
            this.assignOne();
            return;
        }
        if (value.equalsIgnoreCase("RANDOM")) {
            this.randomize();
            return;
        }
        if (value.equalsIgnoreCase("X")) {
            this.assignX();
            return;
        }
        if (value.equalsIgnoreCase("ALL")) {
            this.assignAll();
            return;
        }
        throw new IllegalArgumentException("Error: GF2Polynomial was called using " + value + " as value!");
    }

    public GF2Polynomial(int length, int[] bs2) {
        int leng = length;
        if (length <= 0) {
            leng = 1;
        }
        this.blocks = (leng - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = leng;
        int l2 = Math.min(this.blocks, bs2.length);
        System.arraycopy(bs2, 0, this.value, 0, l2);
        this.zeroUnusedBits();
    }

    public GF2Polynomial(int length, byte[] os) {
        int m2;
        int l2 = length;
        if (length <= 0) {
            l2 = 1;
        }
        this.blocks = (l2 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = l2;
        int k2 = Math.min((os.length - 1 >> 2) + 1, this.blocks);
        int i2 = 0;
        while (i2 < k2 - 1) {
            m2 = os.length - (i2 << 2) - 1;
            this.value[i2] = os[m2] & 0xFF;
            int n2 = i2;
            this.value[n2] = this.value[n2] | os[m2 - 1] << 8 & 0xFF00;
            int n3 = i2;
            this.value[n3] = this.value[n3] | os[m2 - 2] << 16 & 0xFF0000;
            int n4 = i2++;
            this.value[n4] = this.value[n4] | os[m2 - 3] << 24 & 0xFF000000;
        }
        i2 = k2 - 1;
        m2 = os.length - (i2 << 2) - 1;
        this.value[i2] = os[m2] & 0xFF;
        if (m2 > 0) {
            int n5 = i2;
            this.value[n5] = this.value[n5] | os[m2 - 1] << 8 & 0xFF00;
        }
        if (m2 > 1) {
            int n6 = i2;
            this.value[n6] = this.value[n6] | os[m2 - 2] << 16 & 0xFF0000;
        }
        if (m2 > 2) {
            int n7 = i2;
            this.value[n7] = this.value[n7] | os[m2 - 3] << 24 & 0xFF000000;
        }
        this.zeroUnusedBits();
        this.reduceN();
    }

    public GF2Polynomial(int length, BigInteger bi2) {
        int i2;
        int l2 = length;
        if (length <= 0) {
            l2 = 1;
        }
        this.blocks = (l2 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = l2;
        byte[] val = bi2.toByteArray();
        if (val[0] == 0) {
            byte[] dummy = new byte[val.length - 1];
            System.arraycopy(val, 1, dummy, 0, dummy.length);
            val = dummy;
        }
        int ov = val.length & 3;
        int k2 = (val.length - 1 >> 2) + 1;
        for (i2 = 0; i2 < ov; ++i2) {
            int n2 = k2 - 1;
            this.value[n2] = this.value[n2] | (val[i2] & 0xFF) << (ov - 1 - i2 << 3);
        }
        i2 = 0;
        while (i2 <= val.length - 4 >> 2) {
            int m2 = val.length - 1 - (i2 << 2);
            this.value[i2] = val[m2] & 0xFF;
            int n3 = i2;
            this.value[n3] = this.value[n3] | val[m2 - 1] << 8 & 0xFF00;
            int n4 = i2;
            this.value[n4] = this.value[n4] | val[m2 - 2] << 16 & 0xFF0000;
            int n5 = i2++;
            this.value[n5] = this.value[n5] | val[m2 - 3] << 24 & 0xFF000000;
        }
        if ((this.len & 0x1F) != 0) {
            int n6 = this.blocks - 1;
            this.value[n6] = this.value[n6] & reverseRightMask[this.len & 0x1F];
        }
        this.reduceN();
    }

    public GF2Polynomial(GF2Polynomial b2) {
        this.len = b2.len;
        this.blocks = b2.blocks;
        this.value = IntUtils.clone(b2.value);
    }

    public Object clone() {
        return new GF2Polynomial(this);
    }

    public int getLength() {
        return this.len;
    }

    public int[] toIntegerArray() {
        int[] result = new int[this.blocks];
        System.arraycopy(this.value, 0, result, 0, this.blocks);
        return result;
    }

    public String toString(int radix) {
        char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        String[] BIN_CHARS = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
        String res = new String();
        if (radix == 16) {
            for (int i2 = this.blocks - 1; i2 >= 0; --i2) {
                res = res + HEX_CHARS[this.value[i2] >>> 28 & 0xF];
                res = res + HEX_CHARS[this.value[i2] >>> 24 & 0xF];
                res = res + HEX_CHARS[this.value[i2] >>> 20 & 0xF];
                res = res + HEX_CHARS[this.value[i2] >>> 16 & 0xF];
                res = res + HEX_CHARS[this.value[i2] >>> 12 & 0xF];
                res = res + HEX_CHARS[this.value[i2] >>> 8 & 0xF];
                res = res + HEX_CHARS[this.value[i2] >>> 4 & 0xF];
                res = res + HEX_CHARS[this.value[i2] & 0xF];
                res = res + " ";
            }
        } else {
            for (int i3 = this.blocks - 1; i3 >= 0; --i3) {
                res = res + BIN_CHARS[this.value[i3] >>> 28 & 0xF];
                res = res + BIN_CHARS[this.value[i3] >>> 24 & 0xF];
                res = res + BIN_CHARS[this.value[i3] >>> 20 & 0xF];
                res = res + BIN_CHARS[this.value[i3] >>> 16 & 0xF];
                res = res + BIN_CHARS[this.value[i3] >>> 12 & 0xF];
                res = res + BIN_CHARS[this.value[i3] >>> 8 & 0xF];
                res = res + BIN_CHARS[this.value[i3] >>> 4 & 0xF];
                res = res + BIN_CHARS[this.value[i3] & 0xF];
                res = res + " ";
            }
        }
        return res;
    }

    public byte[] toByteArray() {
        int m2;
        int i2;
        int k2 = (this.len - 1 >> 3) + 1;
        int ov = k2 & 3;
        byte[] res = new byte[k2];
        for (i2 = 0; i2 < k2 >> 2; ++i2) {
            m2 = k2 - (i2 << 2) - 1;
            res[m2] = (byte)this.value[i2];
            res[m2 - 1] = (byte)(this.value[i2] >>> 8 & 0xFF);
            res[m2 - 2] = (byte)(this.value[i2] >>> 16 & 0xFF);
            res[m2 - 3] = (this.value[i2] & 0xFF000000) >> 24;
        }
        for (i2 = 0; i2 < ov; ++i2) {
            m2 = ov - i2 - 1 << 3;
            res[i2] = (byte)((this.value[this.blocks - 1] & 255 << m2) >>> m2);
        }
        return res;
    }

    public BigInteger toFlexiBigInt() {
        if (this.len == 0 || this.isZero()) {
            return new BigInteger(0, new byte[0]);
        }
        return new BigInteger(1, this.toByteArray());
    }

    public void assignOne() {
        for (int i2 = 1; i2 < this.blocks; ++i2) {
            this.value[i2] = 0;
        }
        this.value[0] = 1;
    }

    public void assignX() {
        for (int i2 = 1; i2 < this.blocks; ++i2) {
            this.value[i2] = 0;
        }
        this.value[0] = 2;
    }

    public void assignAll() {
        for (int i2 = 0; i2 < this.blocks; ++i2) {
            this.value[i2] = -1;
        }
        this.zeroUnusedBits();
    }

    public void assignZero() {
        for (int i2 = 0; i2 < this.blocks; ++i2) {
            this.value[i2] = 0;
        }
    }

    public void randomize() {
        for (int i2 = 0; i2 < this.blocks; ++i2) {
            this.value[i2] = rand.nextInt();
        }
        this.zeroUnusedBits();
    }

    public void randomize(Random rand) {
        for (int i2 = 0; i2 < this.blocks; ++i2) {
            this.value[i2] = rand.nextInt();
        }
        this.zeroUnusedBits();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2Polynomial)) {
            return false;
        }
        GF2Polynomial otherPol = (GF2Polynomial)other;
        if (this.len != otherPol.len) {
            return false;
        }
        for (int i2 = 0; i2 < this.blocks; ++i2) {
            if (this.value[i2] == otherPol.value[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.len + this.value.hashCode();
    }

    public boolean isZero() {
        if (this.len == 0) {
            return true;
        }
        for (int i2 = 0; i2 < this.blocks; ++i2) {
            if (this.value[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isOne() {
        for (int i2 = 1; i2 < this.blocks; ++i2) {
            if (this.value[i2] == 0) continue;
            return false;
        }
        return this.value[0] == 1;
    }

    public void addToThis(GF2Polynomial b2) {
        this.expandN(b2.len);
        this.xorThisBy(b2);
    }

    public GF2Polynomial add(GF2Polynomial b2) {
        return this.xor(b2);
    }

    public void subtractFromThis(GF2Polynomial b2) {
        this.expandN(b2.len);
        this.xorThisBy(b2);
    }

    public GF2Polynomial subtract(GF2Polynomial b2) {
        return this.xor(b2);
    }

    public void increaseThis() {
        this.xorBit(0);
    }

    public GF2Polynomial increase() {
        GF2Polynomial result = new GF2Polynomial(this);
        result.increaseThis();
        return result;
    }

    public GF2Polynomial multiplyClassic(GF2Polynomial b2) {
        int i2;
        GF2Polynomial result = new GF2Polynomial(Math.max(this.len, b2.len) << 1);
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[32];
        GF2Polynomial[] m2 = gF2PolynomialArray;
        gF2PolynomialArray[0] = new GF2Polynomial(this);
        for (i2 = 1; i2 <= 31; ++i2) {
            m2[i2] = m2[i2 - 1].shiftLeft();
        }
        for (i2 = 0; i2 < b2.blocks; ++i2) {
            int j2;
            for (j2 = 0; j2 <= 31; ++j2) {
                if ((b2.value[i2] & bitMask[j2]) == 0) continue;
                result.xorThisBy(m2[j2]);
            }
            for (j2 = 0; j2 <= 31; ++j2) {
                m2[j2].shiftBlocksLeft();
            }
        }
        return result;
    }

    public GF2Polynomial multiply(GF2Polynomial b2) {
        int n2 = Math.max(this.len, b2.len);
        this.expandN(n2);
        b2.expandN(n2);
        return this.karaMult(b2);
    }

    private GF2Polynomial karaMult(GF2Polynomial b2) {
        GF2Polynomial result = new GF2Polynomial(this.len << 1);
        if (this.len <= 32) {
            result.value = GF2Polynomial.mult32(this.value[0], b2.value[0]);
            return result;
        }
        if (this.len <= 64) {
            result.value = GF2Polynomial.mult64(this.value, b2.value);
            return result;
        }
        if (this.len <= 128) {
            result.value = GF2Polynomial.mult128(this.value, b2.value);
            return result;
        }
        if (this.len <= 256) {
            result.value = GF2Polynomial.mult256(this.value, b2.value);
            return result;
        }
        if (this.len <= 512) {
            result.value = GF2Polynomial.mult512(this.value, b2.value);
            return result;
        }
        int n2 = IntegerFunctions.floorLog(this.len - 1);
        n2 = bitMask[n2];
        GF2Polynomial a0 = this.lower((n2 - 1 >> 5) + 1);
        GF2Polynomial a1 = this.upper((n2 - 1 >> 5) + 1);
        GF2Polynomial b0 = b2.lower((n2 - 1 >> 5) + 1);
        GF2Polynomial b1 = b2.upper((n2 - 1 >> 5) + 1);
        GF2Polynomial c2 = a1.karaMult(b1);
        GF2Polynomial e2 = a0.karaMult(b0);
        a0.addToThis(a1);
        b0.addToThis(b1);
        GF2Polynomial d2 = a0.karaMult(b0);
        result.shiftLeftAddThis(c2, n2 << 1);
        result.shiftLeftAddThis(c2, n2);
        result.shiftLeftAddThis(d2, n2);
        result.shiftLeftAddThis(e2, n2);
        result.addToThis(e2);
        return result;
    }

    private static int[] mult512(int[] a2, int[] b2) {
        int[] result = new int[32];
        int[] a0 = new int[8];
        System.arraycopy(a2, 0, a0, 0, Math.min(8, a2.length));
        int[] a1 = new int[8];
        if (a2.length > 8) {
            System.arraycopy(a2, 8, a1, 0, Math.min(8, a2.length - 8));
        }
        int[] b0 = new int[8];
        System.arraycopy(b2, 0, b0, 0, Math.min(8, b2.length));
        int[] b1 = new int[8];
        if (b2.length > 8) {
            System.arraycopy(b2, 8, b1, 0, Math.min(8, b2.length - 8));
        }
        int[] c2 = GF2Polynomial.mult256(a1, b1);
        result[31] = result[31] ^ c2[15];
        result[30] = result[30] ^ c2[14];
        result[29] = result[29] ^ c2[13];
        result[28] = result[28] ^ c2[12];
        result[27] = result[27] ^ c2[11];
        result[26] = result[26] ^ c2[10];
        result[25] = result[25] ^ c2[9];
        result[24] = result[24] ^ c2[8];
        result[23] = result[23] ^ (c2[7] ^ c2[15]);
        result[22] = result[22] ^ (c2[6] ^ c2[14]);
        result[21] = result[21] ^ (c2[5] ^ c2[13]);
        result[20] = result[20] ^ (c2[4] ^ c2[12]);
        result[19] = result[19] ^ (c2[3] ^ c2[11]);
        result[18] = result[18] ^ (c2[2] ^ c2[10]);
        result[17] = result[17] ^ (c2[1] ^ c2[9]);
        result[16] = result[16] ^ (c2[0] ^ c2[8]);
        result[15] = result[15] ^ c2[7];
        result[14] = result[14] ^ c2[6];
        result[13] = result[13] ^ c2[5];
        result[12] = result[12] ^ c2[4];
        result[11] = result[11] ^ c2[3];
        result[10] = result[10] ^ c2[2];
        result[9] = result[9] ^ c2[1];
        result[8] = result[8] ^ c2[0];
        a1[0] = a1[0] ^ a0[0];
        a1[1] = a1[1] ^ a0[1];
        a1[2] = a1[2] ^ a0[2];
        a1[3] = a1[3] ^ a0[3];
        a1[4] = a1[4] ^ a0[4];
        a1[5] = a1[5] ^ a0[5];
        a1[6] = a1[6] ^ a0[6];
        a1[7] = a1[7] ^ a0[7];
        b1[0] = b1[0] ^ b0[0];
        b1[1] = b1[1] ^ b0[1];
        b1[2] = b1[2] ^ b0[2];
        b1[3] = b1[3] ^ b0[3];
        b1[4] = b1[4] ^ b0[4];
        b1[5] = b1[5] ^ b0[5];
        b1[6] = b1[6] ^ b0[6];
        b1[7] = b1[7] ^ b0[7];
        int[] d2 = GF2Polynomial.mult256(a1, b1);
        result[23] = result[23] ^ d2[15];
        result[22] = result[22] ^ d2[14];
        result[21] = result[21] ^ d2[13];
        result[20] = result[20] ^ d2[12];
        result[19] = result[19] ^ d2[11];
        result[18] = result[18] ^ d2[10];
        result[17] = result[17] ^ d2[9];
        result[16] = result[16] ^ d2[8];
        result[15] = result[15] ^ d2[7];
        result[14] = result[14] ^ d2[6];
        result[13] = result[13] ^ d2[5];
        result[12] = result[12] ^ d2[4];
        result[11] = result[11] ^ d2[3];
        result[10] = result[10] ^ d2[2];
        result[9] = result[9] ^ d2[1];
        result[8] = result[8] ^ d2[0];
        int[] e2 = GF2Polynomial.mult256(a0, b0);
        result[23] = result[23] ^ e2[15];
        result[22] = result[22] ^ e2[14];
        result[21] = result[21] ^ e2[13];
        result[20] = result[20] ^ e2[12];
        result[19] = result[19] ^ e2[11];
        result[18] = result[18] ^ e2[10];
        result[17] = result[17] ^ e2[9];
        result[16] = result[16] ^ e2[8];
        result[15] = result[15] ^ (e2[7] ^ e2[15]);
        result[14] = result[14] ^ (e2[6] ^ e2[14]);
        result[13] = result[13] ^ (e2[5] ^ e2[13]);
        result[12] = result[12] ^ (e2[4] ^ e2[12]);
        result[11] = result[11] ^ (e2[3] ^ e2[11]);
        result[10] = result[10] ^ (e2[2] ^ e2[10]);
        result[9] = result[9] ^ (e2[1] ^ e2[9]);
        result[8] = result[8] ^ (e2[0] ^ e2[8]);
        result[7] = result[7] ^ e2[7];
        result[6] = result[6] ^ e2[6];
        result[5] = result[5] ^ e2[5];
        result[4] = result[4] ^ e2[4];
        result[3] = result[3] ^ e2[3];
        result[2] = result[2] ^ e2[2];
        result[1] = result[1] ^ e2[1];
        result[0] = result[0] ^ e2[0];
        return result;
    }

    private static int[] mult256(int[] a2, int[] b2) {
        int[] c2;
        int[] result = new int[16];
        int[] a0 = new int[4];
        System.arraycopy(a2, 0, a0, 0, Math.min(4, a2.length));
        int[] a1 = new int[4];
        if (a2.length > 4) {
            System.arraycopy(a2, 4, a1, 0, Math.min(4, a2.length - 4));
        }
        int[] b0 = new int[4];
        System.arraycopy(b2, 0, b0, 0, Math.min(4, b2.length));
        int[] b1 = new int[4];
        if (b2.length > 4) {
            System.arraycopy(b2, 4, b1, 0, Math.min(4, b2.length - 4));
        }
        if (a1[3] == 0 && a1[2] == 0 && b1[3] == 0 && b1[2] == 0) {
            if (a1[1] == 0 && b1[1] == 0) {
                if (a1[0] != 0 || b1[0] != 0) {
                    c2 = GF2Polynomial.mult32(a1[0], b1[0]);
                    result[9] = result[9] ^ c2[1];
                    result[8] = result[8] ^ c2[0];
                    result[5] = result[5] ^ c2[1];
                    result[4] = result[4] ^ c2[0];
                }
            } else {
                c2 = GF2Polynomial.mult64(a1, b1);
                result[11] = result[11] ^ c2[3];
                result[10] = result[10] ^ c2[2];
                result[9] = result[9] ^ c2[1];
                result[8] = result[8] ^ c2[0];
                result[7] = result[7] ^ c2[3];
                result[6] = result[6] ^ c2[2];
                result[5] = result[5] ^ c2[1];
                result[4] = result[4] ^ c2[0];
            }
        } else {
            c2 = GF2Polynomial.mult128(a1, b1);
            result[15] = result[15] ^ c2[7];
            result[14] = result[14] ^ c2[6];
            result[13] = result[13] ^ c2[5];
            result[12] = result[12] ^ c2[4];
            result[11] = result[11] ^ (c2[3] ^ c2[7]);
            result[10] = result[10] ^ (c2[2] ^ c2[6]);
            result[9] = result[9] ^ (c2[1] ^ c2[5]);
            result[8] = result[8] ^ (c2[0] ^ c2[4]);
            result[7] = result[7] ^ c2[3];
            result[6] = result[6] ^ c2[2];
            result[5] = result[5] ^ c2[1];
            result[4] = result[4] ^ c2[0];
        }
        a1[0] = a1[0] ^ a0[0];
        a1[1] = a1[1] ^ a0[1];
        a1[2] = a1[2] ^ a0[2];
        a1[3] = a1[3] ^ a0[3];
        b1[0] = b1[0] ^ b0[0];
        b1[1] = b1[1] ^ b0[1];
        b1[2] = b1[2] ^ b0[2];
        b1[3] = b1[3] ^ b0[3];
        int[] d2 = GF2Polynomial.mult128(a1, b1);
        result[11] = result[11] ^ d2[7];
        result[10] = result[10] ^ d2[6];
        result[9] = result[9] ^ d2[5];
        result[8] = result[8] ^ d2[4];
        result[7] = result[7] ^ d2[3];
        result[6] = result[6] ^ d2[2];
        result[5] = result[5] ^ d2[1];
        result[4] = result[4] ^ d2[0];
        int[] e2 = GF2Polynomial.mult128(a0, b0);
        result[11] = result[11] ^ e2[7];
        result[10] = result[10] ^ e2[6];
        result[9] = result[9] ^ e2[5];
        result[8] = result[8] ^ e2[4];
        result[7] = result[7] ^ (e2[3] ^ e2[7]);
        result[6] = result[6] ^ (e2[2] ^ e2[6]);
        result[5] = result[5] ^ (e2[1] ^ e2[5]);
        result[4] = result[4] ^ (e2[0] ^ e2[4]);
        result[3] = result[3] ^ e2[3];
        result[2] = result[2] ^ e2[2];
        result[1] = result[1] ^ e2[1];
        result[0] = result[0] ^ e2[0];
        return result;
    }

    private static int[] mult128(int[] a2, int[] b2) {
        int[] e2;
        int[] d2;
        int[] c2;
        int[] result = new int[8];
        int[] a0 = new int[2];
        System.arraycopy(a2, 0, a0, 0, Math.min(2, a2.length));
        int[] a1 = new int[2];
        if (a2.length > 2) {
            System.arraycopy(a2, 2, a1, 0, Math.min(2, a2.length - 2));
        }
        int[] b0 = new int[2];
        System.arraycopy(b2, 0, b0, 0, Math.min(2, b2.length));
        int[] b1 = new int[2];
        if (b2.length > 2) {
            System.arraycopy(b2, 2, b1, 0, Math.min(2, b2.length - 2));
        }
        if (a1[1] == 0 && b1[1] == 0) {
            if (a1[0] != 0 || b1[0] != 0) {
                c2 = GF2Polynomial.mult32(a1[0], b1[0]);
                result[5] = result[5] ^ c2[1];
                result[4] = result[4] ^ c2[0];
                result[3] = result[3] ^ c2[1];
                result[2] = result[2] ^ c2[0];
            }
        } else {
            c2 = GF2Polynomial.mult64(a1, b1);
            result[7] = result[7] ^ c2[3];
            result[6] = result[6] ^ c2[2];
            result[5] = result[5] ^ (c2[1] ^ c2[3]);
            result[4] = result[4] ^ (c2[0] ^ c2[2]);
            result[3] = result[3] ^ c2[1];
            result[2] = result[2] ^ c2[0];
        }
        a1[0] = a1[0] ^ a0[0];
        a1[1] = a1[1] ^ a0[1];
        b1[0] = b1[0] ^ b0[0];
        b1[1] = b1[1] ^ b0[1];
        if (a1[1] == 0 && b1[1] == 0) {
            d2 = GF2Polynomial.mult32(a1[0], b1[0]);
            result[3] = result[3] ^ d2[1];
            result[2] = result[2] ^ d2[0];
        } else {
            d2 = GF2Polynomial.mult64(a1, b1);
            result[5] = result[5] ^ d2[3];
            result[4] = result[4] ^ d2[2];
            result[3] = result[3] ^ d2[1];
            result[2] = result[2] ^ d2[0];
        }
        if (a0[1] == 0 && b0[1] == 0) {
            e2 = GF2Polynomial.mult32(a0[0], b0[0]);
            result[3] = result[3] ^ e2[1];
            result[2] = result[2] ^ e2[0];
            result[1] = result[1] ^ e2[1];
            result[0] = result[0] ^ e2[0];
        } else {
            e2 = GF2Polynomial.mult64(a0, b0);
            result[5] = result[5] ^ e2[3];
            result[4] = result[4] ^ e2[2];
            result[3] = result[3] ^ (e2[1] ^ e2[3]);
            result[2] = result[2] ^ (e2[0] ^ e2[2]);
            result[1] = result[1] ^ e2[1];
            result[0] = result[0] ^ e2[0];
        }
        return result;
    }

    private static int[] mult64(int[] a2, int[] b2) {
        int[] result = new int[4];
        int a0 = a2[0];
        int a1 = 0;
        if (a2.length > 1) {
            a1 = a2[1];
        }
        int b0 = b2[0];
        int b1 = 0;
        if (b2.length > 1) {
            b1 = b2[1];
        }
        if (a1 != 0 || b1 != 0) {
            int[] c2 = GF2Polynomial.mult32(a1, b1);
            result[3] = result[3] ^ c2[1];
            result[2] = result[2] ^ (c2[0] ^ c2[1]);
            result[1] = result[1] ^ c2[0];
        }
        int[] d2 = GF2Polynomial.mult32(a0 ^ a1, b0 ^ b1);
        result[2] = result[2] ^ d2[1];
        result[1] = result[1] ^ d2[0];
        int[] e2 = GF2Polynomial.mult32(a0, b0);
        result[2] = result[2] ^ e2[1];
        result[1] = result[1] ^ (e2[0] ^ e2[1]);
        result[0] = result[0] ^ e2[0];
        return result;
    }

    private static int[] mult32(int a2, int b2) {
        int[] result = new int[2];
        if (a2 == 0 || b2 == 0) {
            return result;
        }
        long b22 = b2;
        b22 &= 0xFFFFFFFFL;
        long h2 = 0L;
        for (int i2 = 1; i2 <= 32; ++i2) {
            if ((a2 & bitMask[i2 - 1]) != 0) {
                h2 ^= b22;
            }
            b22 <<= 1;
        }
        result[1] = (int)(h2 >>> 32);
        result[0] = (int)h2;
        return result;
    }

    private GF2Polynomial upper(int k2) {
        int j2 = Math.min(k2, this.blocks - k2);
        GF2Polynomial result = new GF2Polynomial(j2 << 5);
        if (this.blocks >= k2) {
            System.arraycopy(this.value, k2, result.value, 0, j2);
        }
        return result;
    }

    private GF2Polynomial lower(int k2) {
        GF2Polynomial result = new GF2Polynomial(k2 << 5);
        System.arraycopy(this.value, 0, result.value, 0, Math.min(k2, this.blocks));
        return result;
    }

    public GF2Polynomial remainder(GF2Polynomial g2) throws RuntimeException {
        int i2;
        GF2Polynomial a2 = new GF2Polynomial(this);
        GF2Polynomial b2 = new GF2Polynomial(g2);
        if (b2.isZero()) {
            throw new RuntimeException();
        }
        a2.reduceN();
        b2.reduceN();
        if (a2.len < b2.len) {
            return a2;
        }
        while ((i2 = a2.len - b2.len) >= 0) {
            GF2Polynomial j2 = b2.shiftLeft(i2);
            a2.subtractFromThis(j2);
            a2.reduceN();
        }
        return a2;
    }

    public GF2Polynomial quotient(GF2Polynomial g2) throws RuntimeException {
        GF2Polynomial q2 = new GF2Polynomial(this.len);
        GF2Polynomial a2 = new GF2Polynomial(this);
        GF2Polynomial b2 = new GF2Polynomial(g2);
        if (b2.isZero()) {
            throw new RuntimeException();
        }
        a2.reduceN();
        b2.reduceN();
        if (a2.len < b2.len) {
            return new GF2Polynomial(0);
        }
        int i2 = a2.len - b2.len;
        q2.expandN(i2 + 1);
        while (i2 >= 0) {
            GF2Polynomial j2 = b2.shiftLeft(i2);
            a2.subtractFromThis(j2);
            a2.reduceN();
            q2.xorBit(i2);
            i2 = a2.len - b2.len;
        }
        return q2;
    }

    public GF2Polynomial[] divide(GF2Polynomial g2) throws RuntimeException {
        GF2Polynomial[] result = new GF2Polynomial[2];
        GF2Polynomial q2 = new GF2Polynomial(this.len);
        GF2Polynomial a2 = new GF2Polynomial(this);
        GF2Polynomial b2 = new GF2Polynomial(g2);
        if (b2.isZero()) {
            throw new RuntimeException();
        }
        a2.reduceN();
        b2.reduceN();
        if (a2.len < b2.len) {
            result[0] = new GF2Polynomial(0);
            result[1] = a2;
            return result;
        }
        int i2 = a2.len - b2.len;
        q2.expandN(i2 + 1);
        while (i2 >= 0) {
            GF2Polynomial j2 = b2.shiftLeft(i2);
            a2.subtractFromThis(j2);
            a2.reduceN();
            q2.xorBit(i2);
            i2 = a2.len - b2.len;
        }
        result[0] = q2;
        result[1] = a2;
        return result;
    }

    public GF2Polynomial gcd(GF2Polynomial g2) throws RuntimeException {
        if (this.isZero() && g2.isZero()) {
            throw new ArithmeticException("Both operands of gcd equal zero.");
        }
        if (this.isZero()) {
            return new GF2Polynomial(g2);
        }
        if (g2.isZero()) {
            return new GF2Polynomial(this);
        }
        GF2Polynomial a2 = new GF2Polynomial(this);
        GF2Polynomial b2 = new GF2Polynomial(g2);
        while (!b2.isZero()) {
            GF2Polynomial c2 = a2.remainder(b2);
            a2 = b2;
            b2 = c2;
        }
        return a2;
    }

    public boolean isIrreducible() {
        if (this.isZero()) {
            return false;
        }
        GF2Polynomial f2 = new GF2Polynomial(this);
        f2.reduceN();
        int d2 = f2.len - 1;
        GF2Polynomial u2 = new GF2Polynomial(f2.len, "X");
        for (int i2 = 1; i2 <= d2 >> 1; ++i2) {
            u2.squareThisPreCalc();
            u2 = u2.remainder(f2);
            GF2Polynomial dummy = u2.add(new GF2Polynomial(32, "X"));
            if (!dummy.isZero()) {
                GF2Polynomial g2 = f2.gcd(dummy);
                if (g2.isOne()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    void reduceTrinomial(int m2, int tc) {
        long t2;
        int max;
        int p0 = m2 >>> 5;
        int q0 = 32 - (m2 & 0x1F);
        int p1 = m2 - tc >>> 5;
        int q1 = 32 - (m2 - tc & 0x1F);
        for (int i2 = max = (m2 << 1) - 2 >>> 5; i2 > p0; --i2) {
            t2 = (long)this.value[i2] & 0xFFFFFFFFL;
            int n2 = i2 - p0 - 1;
            this.value[n2] = this.value[n2] ^ (int)(t2 << q0);
            int n3 = i2 - p0;
            this.value[n3] = (int)((long)this.value[n3] ^ t2 >>> 32 - q0);
            int n4 = i2 - p1 - 1;
            this.value[n4] = this.value[n4] ^ (int)(t2 << q1);
            int n5 = i2 - p1;
            this.value[n5] = (int)((long)this.value[n5] ^ t2 >>> 32 - q1);
            this.value[i2] = 0;
        }
        t2 = (long)this.value[p0] & 0xFFFFFFFFL & 0xFFFFFFFFL << (m2 & 0x1F);
        this.value[0] = (int)((long)this.value[0] ^ t2 >>> 32 - q0);
        if (p0 - p1 - 1 >= 0) {
            int n6 = p0 - p1 - 1;
            this.value[n6] = this.value[n6] ^ (int)(t2 << q1);
        }
        int n7 = p0 - p1;
        this.value[n7] = (int)((long)this.value[n7] ^ t2 >>> 32 - q1);
        int n8 = p0;
        this.value[n8] = this.value[n8] & reverseRightMask[m2 & 0x1F];
        this.blocks = (m2 - 1 >>> 5) + 1;
        this.len = m2;
    }

    void reducePentanomial(int m2, int[] pc) {
        long t2;
        int max;
        int p0 = m2 >>> 5;
        int q0 = 32 - (m2 & 0x1F);
        int p1 = m2 - pc[0] >>> 5;
        int q1 = 32 - (m2 - pc[0] & 0x1F);
        int p2 = m2 - pc[1] >>> 5;
        int q2 = 32 - (m2 - pc[1] & 0x1F);
        int p3 = m2 - pc[2] >>> 5;
        int q3 = 32 - (m2 - pc[2] & 0x1F);
        for (int i2 = max = (m2 << 1) - 2 >>> 5; i2 > p0; --i2) {
            t2 = (long)this.value[i2] & 0xFFFFFFFFL;
            int n2 = i2 - p0 - 1;
            this.value[n2] = this.value[n2] ^ (int)(t2 << q0);
            int n3 = i2 - p0;
            this.value[n3] = (int)((long)this.value[n3] ^ t2 >>> 32 - q0);
            int n4 = i2 - p1 - 1;
            this.value[n4] = this.value[n4] ^ (int)(t2 << q1);
            int n5 = i2 - p1;
            this.value[n5] = (int)((long)this.value[n5] ^ t2 >>> 32 - q1);
            int n6 = i2 - p2 - 1;
            this.value[n6] = this.value[n6] ^ (int)(t2 << q2);
            int n7 = i2 - p2;
            this.value[n7] = (int)((long)this.value[n7] ^ t2 >>> 32 - q2);
            int n8 = i2 - p3 - 1;
            this.value[n8] = this.value[n8] ^ (int)(t2 << q3);
            int n9 = i2 - p3;
            this.value[n9] = (int)((long)this.value[n9] ^ t2 >>> 32 - q3);
            this.value[i2] = 0;
        }
        t2 = (long)this.value[p0] & 0xFFFFFFFFL & 0xFFFFFFFFL << (m2 & 0x1F);
        this.value[0] = (int)((long)this.value[0] ^ t2 >>> 32 - q0);
        if (p0 - p1 - 1 >= 0) {
            int n10 = p0 - p1 - 1;
            this.value[n10] = this.value[n10] ^ (int)(t2 << q1);
        }
        int n11 = p0 - p1;
        this.value[n11] = (int)((long)this.value[n11] ^ t2 >>> 32 - q1);
        if (p0 - p2 - 1 >= 0) {
            int n12 = p0 - p2 - 1;
            this.value[n12] = this.value[n12] ^ (int)(t2 << q2);
        }
        int n13 = p0 - p2;
        this.value[n13] = (int)((long)this.value[n13] ^ t2 >>> 32 - q2);
        if (p0 - p3 - 1 >= 0) {
            int n14 = p0 - p3 - 1;
            this.value[n14] = this.value[n14] ^ (int)(t2 << q3);
        }
        int n15 = p0 - p3;
        this.value[n15] = (int)((long)this.value[n15] ^ t2 >>> 32 - q3);
        int n16 = p0;
        this.value[n16] = this.value[n16] & reverseRightMask[m2 & 0x1F];
        this.blocks = (m2 - 1 >>> 5) + 1;
        this.len = m2;
    }

    public void reduceN() {
        int i2;
        for (i2 = this.blocks - 1; this.value[i2] == 0 && i2 > 0; --i2) {
        }
        int h2 = this.value[i2];
        int j2 = 0;
        while (h2 != 0) {
            h2 >>>= 1;
            ++j2;
        }
        this.len = (i2 << 5) + j2;
        this.blocks = i2 + 1;
    }

    public void expandN(int i2) {
        if (this.len >= i2) {
            return;
        }
        this.len = i2;
        int k2 = (i2 - 1 >>> 5) + 1;
        if (this.blocks >= k2) {
            return;
        }
        if (this.value.length >= k2) {
            for (int j2 = this.blocks; j2 < k2; ++j2) {
                this.value[j2] = 0;
            }
            this.blocks = k2;
            return;
        }
        int[] bs2 = new int[k2];
        System.arraycopy(this.value, 0, bs2, 0, this.blocks);
        this.blocks = k2;
        this.value = null;
        this.value = bs2;
    }

    public void squareThisBitwise() {
        if (this.isZero()) {
            return;
        }
        int[] result = new int[this.blocks << 1];
        for (int i2 = this.blocks - 1; i2 >= 0; --i2) {
            int h2 = this.value[i2];
            int j2 = 1;
            for (int k2 = 0; k2 < 16; ++k2) {
                if ((h2 & 1) != 0) {
                    int n2 = i2 << 1;
                    result[n2] = result[n2] | j2;
                }
                if ((h2 & 0x10000) != 0) {
                    int n3 = (i2 << 1) + 1;
                    result[n3] = result[n3] | j2;
                }
                j2 <<= 2;
                h2 >>>= 1;
            }
        }
        this.value = null;
        this.value = result;
        this.blocks = result.length;
        this.len = (this.len << 1) - 1;
    }

    public void squareThisPreCalc() {
        if (this.isZero()) {
            return;
        }
        if (this.value.length >= this.blocks << 1) {
            for (int i2 = this.blocks - 1; i2 >= 0; --i2) {
                this.value[(i2 << 1) + 1] = squaringTable[this.value[i2] >>> 16 & 0xFF] | squaringTable[(this.value[i2] & 0xFF000000) >>> 24] << 16;
                this.value[i2 << 1] = squaringTable[this.value[i2] & 0xFF] | squaringTable[this.value[i2] >>> 8 & 0xFF] << 16;
            }
            this.blocks <<= 1;
            this.len = (this.len << 1) - 1;
            return;
        }
        int[] result = new int[this.blocks << 1];
        for (int i3 = 0; i3 < this.blocks; ++i3) {
            result[i3 << 1] = squaringTable[this.value[i3] & 0xFF] | squaringTable[this.value[i3] >>> 8 & 0xFF] << 16;
            result[(i3 << 1) + 1] = squaringTable[this.value[i3] >>> 16 & 0xFF] | squaringTable[(this.value[i3] & 0xFF000000) >>> 24] << 16;
        }
        this.value = null;
        this.value = result;
        this.blocks <<= 1;
        this.len = (this.len << 1) - 1;
    }

    public boolean vectorMult(GF2Polynomial b2) throws RuntimeException {
        boolean result = false;
        if (this.len != b2.len) {
            throw new RuntimeException();
        }
        for (int i2 = 0; i2 < this.blocks; ++i2) {
            int h2 = this.value[i2] & b2.value[i2];
            result ^= parity[h2 & 0xFF];
            result ^= parity[h2 >>> 8 & 0xFF];
            result ^= parity[h2 >>> 16 & 0xFF];
            result ^= parity[h2 >>> 24];
        }
        return result;
    }

    public GF2Polynomial xor(GF2Polynomial b2) {
        GF2Polynomial result;
        int k2 = Math.min(this.blocks, b2.blocks);
        if (this.len >= b2.len) {
            result = new GF2Polynomial(this);
            for (int i2 = 0; i2 < k2; ++i2) {
                int n2 = i2;
                result.value[n2] = result.value[n2] ^ b2.value[i2];
            }
        } else {
            result = new GF2Polynomial(b2);
            for (int i3 = 0; i3 < k2; ++i3) {
                int n3 = i3;
                result.value[n3] = result.value[n3] ^ this.value[i3];
            }
        }
        result.zeroUnusedBits();
        return result;
    }

    public void xorThisBy(GF2Polynomial b2) {
        for (int i2 = 0; i2 < Math.min(this.blocks, b2.blocks); ++i2) {
            int n2 = i2;
            this.value[n2] = this.value[n2] ^ b2.value[i2];
        }
        this.zeroUnusedBits();
    }

    private void zeroUnusedBits() {
        if ((this.len & 0x1F) != 0) {
            int n2 = this.blocks - 1;
            this.value[n2] = this.value[n2] & reverseRightMask[this.len & 0x1F];
        }
    }

    public void setBit(int i2) throws RuntimeException {
        if (i2 < 0 || i2 > this.len - 1) {
            throw new RuntimeException();
        }
        if (i2 > this.len - 1) {
            return;
        }
        int n2 = i2 >>> 5;
        this.value[n2] = this.value[n2] | bitMask[i2 & 0x1F];
    }

    public int getBit(int i2) {
        if (i2 < 0 || i2 > this.len - 1) {
            return 0;
        }
        if ((this.value[i2 >>> 5] & bitMask[i2 & 0x1F]) != 0) {
            return 1;
        }
        return 0;
    }

    public void resetBit(int i2) throws RuntimeException {
        if (i2 < 0 || i2 > this.len - 1) {
            throw new RuntimeException();
        }
        if (i2 > this.len - 1) {
            return;
        }
        int n2 = i2 >>> 5;
        this.value[n2] = this.value[n2] & ~bitMask[i2 & 0x1F];
    }

    public void xorBit(int i2) throws RuntimeException {
        if (i2 < 0 || i2 > this.len - 1) {
            throw new RuntimeException();
        }
        if (i2 > this.len - 1) {
            return;
        }
        int n2 = i2 >>> 5;
        this.value[n2] = this.value[n2] ^ bitMask[i2 & 0x1F];
    }

    public boolean testBit(int i2) {
        if (i2 < 0 || i2 > this.len - 1) {
            return false;
        }
        return (this.value[i2 >>> 5] & bitMask[i2 & 0x1F]) != 0;
    }

    public GF2Polynomial shiftLeft() {
        GF2Polynomial result = new GF2Polynomial(this.len + 1, this.value);
        for (int i2 = result.blocks - 1; i2 > 0; --i2) {
            int n2 = i2;
            result.value[n2] = result.value[n2] << 1;
            int n3 = i2;
            result.value[n3] = result.value[n3] | result.value[i2 - 1] >>> 31;
        }
        result.value[0] = result.value[0] << 1;
        return result;
    }

    public void shiftLeftThis() {
        if ((this.len & 0x1F) == 0) {
            ++this.len;
            ++this.blocks;
            if (this.blocks > this.value.length) {
                int[] bs2 = new int[this.blocks];
                System.arraycopy(this.value, 0, bs2, 0, this.value.length);
                this.value = null;
                this.value = bs2;
            }
            for (int i2 = this.blocks - 1; i2 > 0; --i2) {
                int n2 = i2;
                this.value[n2] = this.value[n2] | this.value[i2 - 1] >>> 31;
                int n3 = i2 - 1;
                this.value[n3] = this.value[n3] << 1;
            }
        } else {
            ++this.len;
            for (int i3 = this.blocks - 1; i3 > 0; --i3) {
                int n4 = i3;
                this.value[n4] = this.value[n4] << 1;
                int n5 = i3;
                this.value[n5] = this.value[n5] | this.value[i3 - 1] >>> 31;
            }
            this.value[0] = this.value[0] << 1;
        }
    }

    public GF2Polynomial shiftLeft(int k2) {
        int remaining;
        GF2Polynomial result = new GF2Polynomial(this.len + k2, this.value);
        if (k2 >= 32) {
            result.doShiftBlocksLeft(k2 >>> 5);
        }
        if ((remaining = k2 & 0x1F) != 0) {
            for (int i2 = result.blocks - 1; i2 > 0; --i2) {
                int n2 = i2;
                result.value[n2] = result.value[n2] << remaining;
                int n3 = i2;
                result.value[n3] = result.value[n3] | result.value[i2 - 1] >>> 32 - remaining;
            }
            result.value[0] = result.value[0] << remaining;
        }
        return result;
    }

    public void shiftLeftAddThis(GF2Polynomial b2, int k2) {
        if (k2 == 0) {
            this.addToThis(b2);
            return;
        }
        this.expandN(b2.len + k2);
        int d2 = k2 >>> 5;
        for (int i2 = b2.blocks - 1; i2 >= 0; --i2) {
            if (i2 + d2 + 1 < this.blocks && (k2 & 0x1F) != 0) {
                int n2 = i2 + d2 + 1;
                this.value[n2] = this.value[n2] ^ b2.value[i2] >>> 32 - (k2 & 0x1F);
            }
            int n3 = i2 + d2;
            this.value[n3] = this.value[n3] ^ b2.value[i2] << (k2 & 0x1F);
        }
    }

    void shiftBlocksLeft() {
        ++this.blocks;
        this.len += 32;
        if (this.blocks <= this.value.length) {
            for (int i2 = this.blocks - 1; i2 > 0; --i2) {
                this.value[i2] = this.value[i2 - 1];
            }
            this.value[0] = 0;
            return;
        }
        int[] result = new int[this.blocks];
        System.arraycopy(this.value, 0, result, 1, this.blocks - 1);
        this.value = null;
        this.value = result;
    }

    private void doShiftBlocksLeft(int b2) {
        if (this.blocks <= this.value.length) {
            int i2;
            for (i2 = this.blocks - 1; i2 >= b2; --i2) {
                this.value[i2] = this.value[i2 - b2];
            }
            for (i2 = 0; i2 < b2; ++i2) {
                this.value[i2] = 0;
            }
            return;
        }
        int[] result = new int[this.blocks];
        System.arraycopy(this.value, 0, result, b2, this.blocks - b2);
        this.value = null;
        this.value = result;
    }

    public GF2Polynomial shiftRight() {
        GF2Polynomial result = new GF2Polynomial(this.len - 1);
        System.arraycopy(this.value, 0, result.value, 0, result.blocks);
        for (int i2 = 0; i2 <= result.blocks - 2; ++i2) {
            int n2 = i2;
            result.value[n2] = result.value[n2] >>> 1;
            int n3 = i2;
            result.value[n3] = result.value[n3] | result.value[i2 + 1] << 31;
        }
        int n4 = result.blocks - 1;
        result.value[n4] = result.value[n4] >>> 1;
        if (result.blocks < this.blocks) {
            int n5 = result.blocks - 1;
            result.value[n5] = result.value[n5] | this.value[result.blocks] << 31;
        }
        return result;
    }

    public void shiftRightThis() {
        --this.len;
        this.blocks = (this.len - 1 >>> 5) + 1;
        for (int i2 = 0; i2 <= this.blocks - 2; ++i2) {
            int n2 = i2;
            this.value[n2] = this.value[n2] >>> 1;
            int n3 = i2;
            this.value[n3] = this.value[n3] | this.value[i2 + 1] << 31;
        }
        int n4 = this.blocks - 1;
        this.value[n4] = this.value[n4] >>> 1;
        if ((this.len & 0x1F) == 0) {
            int n5 = this.blocks - 1;
            this.value[n5] = this.value[n5] | this.value[this.blocks] << 31;
        }
    }
}

