/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pkcs;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DLSequence;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.MacData;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.Pfx;
import com.timevale.tgtext.bouncycastle.cms.CMSEncryptedDataGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSProcessableByteArray;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS12PfxPdu;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS12SafeBag;
import com.timevale.tgtext.bouncycastle.pkcs.PKCSException;
import com.timevale.tgtext.bouncycastle.pkcs.PKCSIOException;
import com.timevale.tgtext.bouncycastle.pkcs.a;
import java.io.IOException;

public class PKCS12PfxPduBuilder {
    private ASN1EncodableVector dataVector = new ASN1EncodableVector();

    public PKCS12PfxPduBuilder addData(PKCS12SafeBag data) throws IOException {
        this.dataVector.add(new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(new DLSequence(data.toASN1Structure()).getEncoded())));
        return this;
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, PKCS12SafeBag data) throws IOException {
        return this.addEncryptedData(dataEncryptor, new DERSequence(data.toASN1Structure()));
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, PKCS12SafeBag[] data) throws IOException {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 != data.length; ++i2) {
            v2.add(data[i2].toASN1Structure());
        }
        return this.addEncryptedData(dataEncryptor, new DLSequence(v2));
    }

    private PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, ASN1Sequence data) throws IOException {
        CMSEncryptedDataGenerator envGen = new CMSEncryptedDataGenerator();
        try {
            this.dataVector.add(envGen.generate(new CMSProcessableByteArray(data.getEncoded()), dataEncryptor).toASN1Structure());
        }
        catch (CMSException e2) {
            throw new PKCSIOException(e2.getMessage(), e2.getCause());
        }
        return this;
    }

    public PKCS12PfxPdu build(PKCS12MacCalculatorBuilder macCalcBuilder, char[] password) throws PKCSException {
        byte[] encAuth;
        AuthenticatedSafe auth = AuthenticatedSafe.getInstance(new DLSequence(this.dataVector));
        try {
            encAuth = auth.getEncoded();
        }
        catch (IOException e2) {
            throw new PKCSException("unable to encode AuthenticatedSafe: " + e2.getMessage(), e2);
        }
        ContentInfo mainInfo = new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(encAuth));
        MacData mData = null;
        if (macCalcBuilder != null) {
            a mdGen = new a(macCalcBuilder);
            mData = mdGen.a(password, encAuth);
        }
        Pfx pfx = new Pfx(mainInfo, mData);
        return new PKCS12PfxPdu(pfx);
    }
}

