/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.DisplayText;
import com.timevale.tgtext.bouncycastle.asn1.x509.NoticeReference;

public class UserNotice
extends ASN1Object {
    private NoticeReference noticeRef;
    private DisplayText explicitText;

    public UserNotice(NoticeReference noticeRef, DisplayText explicitText) {
        this.noticeRef = noticeRef;
        this.explicitText = explicitText;
    }

    public UserNotice(NoticeReference noticeRef, String str) {
        this(noticeRef, new DisplayText(str));
    }

    private UserNotice(ASN1Sequence as2) {
        if (as2.size() == 2) {
            this.noticeRef = NoticeReference.getInstance(as2.getObjectAt(0));
            this.explicitText = DisplayText.getInstance(as2.getObjectAt(1));
            return;
        }
        if (as2.size() == 1) {
            if (as2.getObjectAt(0).toASN1Primitive() instanceof ASN1Sequence) {
                this.noticeRef = NoticeReference.getInstance(as2.getObjectAt(0));
                return;
            }
            this.explicitText = DisplayText.getInstance(as2.getObjectAt(0));
            return;
        }
        throw new IllegalArgumentException("Bad sequence size: " + as2.size());
    }

    public static UserNotice getInstance(Object obj) {
        if (obj instanceof UserNotice) {
            return (UserNotice)obj;
        }
        if (obj != null) {
            return new UserNotice(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public NoticeReference getNoticeRef() {
        return this.noticeRef;
    }

    public DisplayText getExplicitText() {
        return this.explicitText;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector av2 = new ASN1EncodableVector();
        if (this.noticeRef != null) {
            av2.add(this.noticeRef);
        }
        if (this.explicitText != null) {
            av2.add(this.explicitText);
        }
        return new DERSequence(av2);
    }
}

