/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.eac;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ParsingException;
import com.timevale.tgtext.bouncycastle.asn1.eac.CVCertificate;
import com.timevale.tgtext.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.timevale.tgtext.bouncycastle.eac.EACException;
import com.timevale.tgtext.bouncycastle.eac.EACIOException;
import com.timevale.tgtext.bouncycastle.eac.operator.EACSignatureVerifier;
import java.io.IOException;
import java.io.OutputStream;

public class EACCertificateHolder {
    private CVCertificate cvCertificate;

    private static CVCertificate parseBytes(byte[] certEncoding) throws IOException {
        try {
            return CVCertificate.getInstance(certEncoding);
        }
        catch (ClassCastException e2) {
            throw new EACIOException("malformed data: " + e2.getMessage(), e2);
        }
        catch (IllegalArgumentException e3) {
            throw new EACIOException("malformed data: " + e3.getMessage(), e3);
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            ASN1ParsingException e4 = aSN1ParsingException;
            if (aSN1ParsingException.getCause() instanceof IOException) {
                throw (IOException)e4.getCause();
            }
            throw new EACIOException("malformed data: " + e4.getMessage(), e4);
        }
    }

    public EACCertificateHolder(byte[] certEncoding) throws IOException {
        this(EACCertificateHolder.parseBytes(certEncoding));
    }

    public EACCertificateHolder(CVCertificate cvCertificate) {
        this.cvCertificate = cvCertificate;
    }

    public CVCertificate toASN1Structure() {
        return this.cvCertificate;
    }

    public PublicKeyDataObject getPublicKeyDataObject() {
        return this.cvCertificate.getBody().getPublicKey();
    }

    public boolean isSignatureValid(EACSignatureVerifier verifier) throws EACException {
        try {
            OutputStream vOut = verifier.getOutputStream();
            vOut.write(this.cvCertificate.getBody().getEncoded("DER"));
            vOut.close();
            return verifier.verify(this.cvCertificate.getSignature());
        }
        catch (Exception e2) {
            throw new EACException("unable to process signature: " + e2.getMessage(), e2);
        }
    }
}

