/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.timevale.tgtext.bouncycastle.pqc.crypto.MessageEncryptor;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Primitives;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.a;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import java.security.SecureRandom;

public class McEliecePointchevalCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.2";
    private Digest messDigest;
    private SecureRandom sr;
    private int n;
    private int k;
    private int t;
    McElieceCCA2KeyParameters key;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.sr = rParam.getRandom();
                this.key = (McElieceCCA2PublicKeyParameters)rParam.getParameters();
                this.initCipherEncrypt((McElieceCCA2PublicKeyParameters)this.key);
                return;
            }
            this.sr = new SecureRandom();
            this.key = (McElieceCCA2PublicKeyParameters)param;
            this.initCipherEncrypt((McElieceCCA2PublicKeyParameters)this.key);
            return;
        }
        this.key = (McElieceCCA2PrivateKeyParameters)param;
        this.initCipherDecrypt((McElieceCCA2PrivateKeyParameters)this.key);
    }

    public int getKeySize(McElieceCCA2KeyParameters key) throws IllegalArgumentException {
        if (key instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)key).getN();
        }
        if (key instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)key).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    protected int decryptOutputSize(int inLen) {
        return 0;
    }

    protected int encryptOutputSize(int inLen) {
        return 0;
    }

    public void initCipherEncrypt(McElieceCCA2PublicKeyParameters pubKey) {
        this.sr = this.sr != null ? this.sr : new SecureRandom();
        this.messDigest = pubKey.getParameters().getDigest();
        this.n = pubKey.getN();
        this.k = pubKey.getK();
        this.t = pubKey.getT();
    }

    public void initCipherDecrypt(McElieceCCA2PrivateKeyParameters privKey) {
        this.messDigest = privKey.getParameters().getDigest();
        this.n = privKey.getN();
        this.k = privKey.getK();
        this.t = privKey.getT();
    }

    @Override
    public byte[] messageEncrypt(byte[] input) throws Exception {
        int i2;
        int kDiv8 = this.k >> 3;
        byte[] r2 = new byte[kDiv8];
        this.sr.nextBytes(r2);
        GF2Vector rPrime = new GF2Vector(this.k, this.sr);
        byte[] rPrimeBytes = rPrime.getEncoded();
        byte[] mr = ByteUtils.concatenate(input, r2);
        this.messDigest.update(mr, 0, mr.length);
        byte[] hmr = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(hmr, 0);
        GF2Vector z2 = a.a(this.n, this.t, hmr);
        byte[] c1 = McElieceCCA2Primitives.encryptionPrimitive((McElieceCCA2PublicKeyParameters)this.key, rPrime, z2).getEncoded();
        DigestRandomGenerator sr0 = new DigestRandomGenerator(new SHA1Digest());
        sr0.addSeedMaterial(rPrimeBytes);
        byte[] c2 = new byte[input.length + kDiv8];
        sr0.nextBytes(c2);
        for (i2 = 0; i2 < input.length; ++i2) {
            int n2 = i2;
            c2[n2] = (byte)(c2[n2] ^ input[i2]);
        }
        for (i2 = 0; i2 < kDiv8; ++i2) {
            int n3 = input.length + i2;
            c2[n3] = (byte)(c2[n3] ^ r2[i2]);
        }
        return ByteUtils.concatenate(c1, c2);
    }

    @Override
    public byte[] messageDecrypt(byte[] input) throws Exception {
        int c1Len = this.n + 7 >> 3;
        int c2Len = input.length - c1Len;
        byte[][] c1c2 = ByteUtils.split(input, c1Len);
        byte[] c1 = c1c2[0];
        byte[] c2 = c1c2[1];
        GF2Vector c1Vec = GF2Vector.OS2VP(this.n, c1);
        GF2Vector[] c1Dec = McElieceCCA2Primitives.decryptionPrimitive((McElieceCCA2PrivateKeyParameters)this.key, c1Vec);
        byte[] rPrimeBytes = c1Dec[0].getEncoded();
        GF2Vector z2 = c1Dec[1];
        DigestRandomGenerator sr0 = new DigestRandomGenerator(new SHA1Digest());
        sr0.addSeedMaterial(rPrimeBytes);
        byte[] mrBytes = new byte[c2Len];
        sr0.nextBytes(mrBytes);
        for (int i2 = 0; i2 < c2Len; ++i2) {
            int n2 = i2;
            mrBytes[n2] = (byte)(mrBytes[n2] ^ c2[i2]);
        }
        this.messDigest.update(mrBytes, 0, c2Len);
        byte[] hmr = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(hmr, 0);
        c1Vec = a.a(this.n, this.t, hmr);
        if (!c1Vec.equals(z2)) {
            throw new Exception("Bad Padding: Invalid ciphertext.");
        }
        int kDiv8 = this.k >> 3;
        byte[][] mr = ByteUtils.split(mrBytes, c2Len - kDiv8);
        return mr[0];
    }
}

