/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.modes;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;

public class SICBlockCipher
implements BlockCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;

    public SICBlockCipher(BlockCipher c2) {
        this.cipher = c2;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            ParametersWithIV ivParam = (ParametersWithIV)params;
            byte[] iv = ivParam.getIV();
            System.arraycopy(iv, 0, this.IV, 0, this.IV.length);
            this.reset();
            if (ivParam.getParameters() != null) {
                this.cipher.init(true, ivParam.getParameters());
            }
            return;
        }
        throw new IllegalArgumentException("SIC mode requires ParametersWithIV");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int i2;
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        for (i2 = 0; i2 < this.counterOut.length; ++i2) {
            out[outOff + i2] = (byte)(this.counterOut[i2] ^ in[inOff + i2]);
        }
        i2 = this.counter.length - 1;
        while (i2 >= 0) {
            int n2 = i2--;
            this.counter[n2] = (byte)(this.counter[n2] + 1);
            if (this.counter[n2] == 0) continue;
        }
        return this.counter.length;
    }

    @Override
    public void reset() {
        System.arraycopy(this.IV, 0, this.counter, 0, this.counter.length);
        this.cipher.reset();
    }
}

