/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.ess;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.ess.ESSCertIDv2;
import com.timevale.tgtext.bouncycastle.asn1.x509.PolicyInformation;

public class SigningCertificateV2
extends ASN1Object {
    ASN1Sequence certs;
    ASN1Sequence policies;

    public static SigningCertificateV2 getInstance(Object o2) {
        if (o2 == null || o2 instanceof SigningCertificateV2) {
            return (SigningCertificateV2)o2;
        }
        if (o2 instanceof ASN1Sequence) {
            return new SigningCertificateV2((ASN1Sequence)o2);
        }
        return null;
    }

    private SigningCertificateV2(ASN1Sequence seq) {
        if (seq.size() <= 0 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.certs = ASN1Sequence.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.policies = ASN1Sequence.getInstance(seq.getObjectAt(1));
        }
    }

    public SigningCertificateV2(ESSCertIDv2[] certs) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 < certs.length; ++i2) {
            v2.add(certs[i2]);
        }
        this.certs = new DERSequence(v2);
    }

    public SigningCertificateV2(ESSCertIDv2[] certs, PolicyInformation[] policies) {
        int i2;
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        for (i2 = 0; i2 < certs.length; ++i2) {
            v2.add(certs[i2]);
        }
        this.certs = new DERSequence(v2);
        if (policies != null) {
            v2 = new ASN1EncodableVector();
            for (i2 = 0; i2 < policies.length; ++i2) {
                v2.add(policies[i2]);
            }
            this.policies = new DERSequence(v2);
        }
    }

    public ESSCertIDv2[] getCerts() {
        ESSCertIDv2[] certIds = new ESSCertIDv2[this.certs.size()];
        for (int i2 = 0; i2 != this.certs.size(); ++i2) {
            certIds[i2] = ESSCertIDv2.getInstance(this.certs.getObjectAt(i2));
        }
        return certIds;
    }

    public PolicyInformation[] getPolicies() {
        if (this.policies == null) {
            return null;
        }
        PolicyInformation[] policyInformations = new PolicyInformation[this.policies.size()];
        for (int i2 = 0; i2 != this.policies.size(); ++i2) {
            policyInformations[i2] = PolicyInformation.getInstance(this.policies.getObjectAt(i2));
        }
        return policyInformations;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.certs);
        if (this.policies != null) {
            v2.add(this.policies);
        }
        return new DERSequence(v2);
    }
}

