/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.timevale.tgtext.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import com.timevale.tgtext.bouncycastle.asn1.cms.OriginatorPublicKey;
import com.timevale.tgtext.bouncycastle.asn1.cms.RecipientEncryptedKey;
import com.timevale.tgtext.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedStream;
import com.timevale.tgtext.bouncycastle.cms.KeyAgreeRecipient;
import com.timevale.tgtext.bouncycastle.cms.KeyAgreeRecipientId;
import com.timevale.tgtext.bouncycastle.cms.Recipient;
import com.timevale.tgtext.bouncycastle.cms.RecipientId;
import com.timevale.tgtext.bouncycastle.cms.RecipientInformation;
import com.timevale.tgtext.bouncycastle.cms.RecipientOperator;
import com.timevale.tgtext.bouncycastle.cms.a;
import com.timevale.tgtext.bouncycastle.cms.d;
import com.timevale.tgtext.bouncycastle.cms.g;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKeyAgreeAuthenticatedRecipient;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKeyAgreeEnvelopedRecipient;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKeyAgreeRecipient;
import com.timevale.tgtext.bouncycastle.cms.k;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.List;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo info;
    private ASN1OctetString encryptedKey;

    static void readRecipientInfo(List infos, KeyAgreeRecipientInfo info, AlgorithmIdentifier messageAlgorithm, g secureReadable, a additionalData) {
        ASN1Sequence s2 = info.getRecipientEncryptedKeys();
        for (int i2 = 0; i2 < s2.size(); ++i2) {
            KeyAgreeRecipientId rid;
            RecipientEncryptedKey id = RecipientEncryptedKey.getInstance(s2.getObjectAt(i2));
            KeyAgreeRecipientIdentifier karid = id.getIdentifier();
            IssuerAndSerialNumber iAndSN = karid.getIssuerAndSerialNumber();
            if (iAndSN != null) {
                rid = new KeyAgreeRecipientId(iAndSN.getName(), iAndSN.getSerialNumber().getValue());
            } else {
                RecipientKeyIdentifier rKeyID = karid.getRKeyID();
                rid = new KeyAgreeRecipientId(rKeyID.getSubjectKeyIdentifier().getOctets());
            }
            infos.add(new KeyAgreeRecipientInformation(info, rid, id.getEncryptedKey(), messageAlgorithm, secureReadable, additionalData));
        }
    }

    KeyAgreeRecipientInformation(KeyAgreeRecipientInfo info, RecipientId rid, ASN1OctetString encryptedKey, AlgorithmIdentifier messageAlgorithm, g secureReadable, a additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        this.rid = rid;
        this.encryptedKey = encryptedKey;
    }

    private SubjectPublicKeyInfo getSenderPublicKeyInfo(AlgorithmIdentifier recKeyAlgId, OriginatorIdentifierOrKey originator) throws CMSException, IOException {
        k origID;
        OriginatorPublicKey opk = originator.getOriginatorKey();
        if (opk != null) {
            return this.getPublicKeyInfoFromOriginatorPublicKey(recKeyAlgId, opk);
        }
        IssuerAndSerialNumber iAndSN = originator.getIssuerAndSerialNumber();
        if (iAndSN != null) {
            origID = new k(iAndSN.getName(), iAndSN.getSerialNumber().getValue());
        } else {
            SubjectKeyIdentifier ski = originator.getSubjectKeyIdentifier();
            origID = new k(ski.getKeyIdentifier());
        }
        return this.getPublicKeyInfoFromOriginatorId(origID);
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorPublicKey(AlgorithmIdentifier recKeyAlgId, OriginatorPublicKey originatorPublicKey) {
        SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(recKeyAlgId, originatorPublicKey.getPublicKey().getBytes());
        return pubInfo;
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorId(k origID) throws CMSException {
        throw new CMSException("No support for 'originator' as IssuerAndSerialNumber or SubjectKeyIdentifier");
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, i.a(prov));
    }

    @Override
    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            JceKeyAgreeRecipient recipient = this.secureReadable instanceof d.c ? new JceKeyAgreeEnvelopedRecipient((PrivateKey)key) : new JceKeyAgreeAuthenticatedRecipient((PrivateKey)key);
            if (prov != null) {
                recipient.setProvider(prov);
                if (prov.getName().equalsIgnoreCase("SunJCE")) {
                    recipient.setContentProvider((String)null);
                }
            }
            return this.getContentStream(recipient);
        }
        catch (IOException e2) {
            throw new CMSException("encoding error: " + e2.getMessage(), e2);
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        KeyAgreeRecipient agreeRecipient = (KeyAgreeRecipient)recipient;
        AlgorithmIdentifier recKeyAlgId = agreeRecipient.getPrivateKeyAlgorithmIdentifier();
        return ((KeyAgreeRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.getSenderPublicKeyInfo(recKeyAlgId, this.info.getOriginator()), this.info.getUserKeyingMaterial(), this.encryptedKey.getOctets());
    }
}

