/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce.provider;

import com.timevale.tgtext.bouncycastle.jce.exception.ExtCertPathValidatorException;
import com.timevale.tgtext.bouncycastle.jce.provider.AnnotatedException;
import com.timevale.tgtext.bouncycastle.jce.provider.CertPathValidatorUtilities;
import com.timevale.tgtext.bouncycastle.jce.provider.e;
import com.timevale.tgtext.bouncycastle.util.Selector;
import com.timevale.tgtext.bouncycastle.x509.ExtendedPKIXParameters;
import com.timevale.tgtext.bouncycastle.x509.X509AttributeCertStoreSelector;
import com.timevale.tgtext.bouncycastle.x509.X509AttributeCertificate;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.X509Certificate;
import java.util.Date;

public class PKIXAttrCertPathValidatorSpi
extends CertPathValidatorSpi {
    @Override
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Date date;
        if (!(params instanceof ExtendedPKIXParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be a " + ExtendedPKIXParameters.class.getName() + " instance.");
        }
        ExtendedPKIXParameters pkixParams = (ExtendedPKIXParameters)params;
        Selector certSelect = pkixParams.getTargetConstraints();
        if (!(certSelect instanceof X509AttributeCertStoreSelector)) {
            throw new InvalidAlgorithmParameterException("TargetConstraints must be an instance of " + X509AttributeCertStoreSelector.class.getName() + " for " + this.getClass().getName() + " class.");
        }
        X509AttributeCertificate attrCert = ((X509AttributeCertStoreSelector)certSelect).getAttributeCert();
        CertPath holderCertPath = e.c(attrCert, pkixParams);
        CertPathValidatorResult result = e.a(certPath, pkixParams);
        X509Certificate issuerCert = (X509Certificate)certPath.getCertificates().get(0);
        e.b(issuerCert, pkixParams);
        e.a(issuerCert, pkixParams);
        e.b(attrCert, pkixParams);
        e.a(attrCert, certPath, holderCertPath, pkixParams);
        e.a(attrCert, pkixParams);
        try {
            date = CertPathValidatorUtilities.getValidCertDateFromValidityModel(pkixParams, null, -1);
        }
        catch (AnnotatedException e2) {
            throw new ExtCertPathValidatorException("Could not get validity date from attribute certificate.", e2);
        }
        e.a(attrCert, pkixParams, issuerCert, date, certPath.getCertificates());
        return result;
    }
}

