/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1GeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERGeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.CertStatus;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.ResponseData;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.RevokedInfo;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.SingleResponse;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLReason;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509CertificateStructure;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import com.timevale.tgtext.bouncycastle.ocsp.BasicOCSPResp;
import com.timevale.tgtext.bouncycastle.ocsp.CertificateID;
import com.timevale.tgtext.bouncycastle.ocsp.CertificateStatus;
import com.timevale.tgtext.bouncycastle.ocsp.OCSPException;
import com.timevale.tgtext.bouncycastle.ocsp.RespID;
import com.timevale.tgtext.bouncycastle.ocsp.RevokedStatus;
import com.timevale.tgtext.bouncycastle.ocsp.UnknownStatus;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class BasicOCSPRespGenerator {
    private List list = new ArrayList();
    private X509Extensions responseExtensions = null;
    private RespID responderID;

    public BasicOCSPRespGenerator(RespID responderID) {
        this.responderID = responderID;
    }

    public BasicOCSPRespGenerator(PublicKey key) throws OCSPException {
        this.responderID = new RespID(key);
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus) {
        this.list.add(new a(certID, certStatus, new Date(), null, null));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, X509Extensions singleExtensions) {
        this.list.add(new a(certID, certStatus, new Date(), null, singleExtensions));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Date nextUpdate, X509Extensions singleExtensions) {
        this.list.add(new a(certID, certStatus, new Date(), nextUpdate, singleExtensions));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, X509Extensions singleExtensions) {
        this.list.add(new a(certID, certStatus, thisUpdate, nextUpdate, singleExtensions));
    }

    public void setResponseExtensions(X509Extensions responseExtensions) {
        this.responseExtensions = responseExtensions;
    }

    private BasicOCSPResp generateResponse(String signatureName, PrivateKey key, X509Certificate[] chain, Date producedAt, String provider, SecureRandom random) throws OCSPException, NoSuchProviderException {
        DERBitString bitSig;
        Signature sig;
        DERObjectIdentifier signingAlgorithm;
        Iterator it = this.list.iterator();
        try {
            signingAlgorithm = com.timevale.tgtext.bouncycastle.ocsp.a.a(signatureName);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("unknown signing algorithm specified");
        }
        ASN1EncodableVector responses = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                responses.add(((a)it.next()).a());
            }
            catch (Exception e2) {
                throw new OCSPException("exception creating Request", e2);
            }
        }
        ResponseData tbsResp = new ResponseData(this.responderID.toASN1Object(), new DERGeneralizedTime(producedAt), (ASN1Sequence)new DERSequence(responses), this.responseExtensions);
        try {
            sig = com.timevale.tgtext.bouncycastle.ocsp.a.b(signatureName, provider);
            if (random != null) {
                sig.initSign(key, random);
            } else {
                sig.initSign(key);
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            NoSuchProviderException e3 = noSuchProviderException;
            throw noSuchProviderException;
        }
        catch (GeneralSecurityException e4) {
            throw new OCSPException("exception creating signature: " + e4, e4);
        }
        try {
            sig.update(tbsResp.getEncoded("DER"));
            bitSig = new DERBitString(sig.sign());
        }
        catch (Exception e5) {
            throw new OCSPException("exception processing TBSRequest: " + e5, e5);
        }
        AlgorithmIdentifier sigAlgId = com.timevale.tgtext.bouncycastle.ocsp.a.b(signingAlgorithm);
        DERSequence chainSeq = null;
        if (chain != null && chain.length > 0) {
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            try {
                for (int i2 = 0; i2 != chain.length; ++i2) {
                    v2.add(new X509CertificateStructure((ASN1Sequence)ASN1Primitive.fromByteArray(chain[i2].getEncoded())));
                }
            }
            catch (IOException e6) {
                throw new OCSPException("error processing certs", e6);
            }
            catch (CertificateEncodingException e7) {
                throw new OCSPException("error encoding certs", e7);
            }
            chainSeq = new DERSequence(v2);
        }
        return new BasicOCSPResp(new BasicOCSPResponse(tbsResp, sigAlgId, bitSig, chainSeq));
    }

    public BasicOCSPResp generate(String signingAlgorithm, PrivateKey key, X509Certificate[] chain, Date thisUpdate, String provider) throws OCSPException, NoSuchProviderException, IllegalArgumentException {
        return this.generate(signingAlgorithm, key, chain, thisUpdate, provider, null);
    }

    public BasicOCSPResp generate(String signingAlgorithm, PrivateKey key, X509Certificate[] chain, Date producedAt, String provider, SecureRandom random) throws OCSPException, NoSuchProviderException, IllegalArgumentException {
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("no signing algorithm specified");
        }
        return this.generateResponse(signingAlgorithm, key, chain, producedAt, provider, random);
    }

    public Iterator getSignatureAlgNames() {
        return com.timevale.tgtext.bouncycastle.ocsp.a.a();
    }

    private class a {
        CertificateID a;
        CertStatus b;
        DERGeneralizedTime c;
        DERGeneralizedTime d;
        X509Extensions e;

        public a(CertificateID certId, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, X509Extensions extensions) {
            RevokedStatus rs;
            this.a = certId;
            this.b = certStatus == null ? new CertStatus() : (certStatus instanceof UnknownStatus ? new CertStatus(2, DERNull.INSTANCE) : ((rs = (RevokedStatus)certStatus).hasRevocationReason() ? new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(rs.getRevocationTime()), CRLReason.lookup(rs.getRevocationReason()))) : new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(rs.getRevocationTime()), null))));
            this.c = new DERGeneralizedTime(thisUpdate);
            this.d = nextUpdate != null ? new DERGeneralizedTime(nextUpdate) : null;
            this.e = extensions;
        }

        public SingleResponse a() throws Exception {
            return new SingleResponse(this.a.toASN1Object(), this.b, this.c, this.d, this.e);
        }
    }
}

