/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Choice;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttributeCertificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;

public class CMPCertificate
extends ASN1Object
implements ASN1Choice {
    private Certificate x509v3PKCert;
    private AttributeCertificate x509v2AttrCert;

    public CMPCertificate(AttributeCertificate x509v2AttrCert) {
        this.x509v2AttrCert = x509v2AttrCert;
    }

    public CMPCertificate(Certificate x509v3PKCert) {
        if (x509v3PKCert.getVersionNumber() != 3) {
            throw new IllegalArgumentException("only version 3 certificates allowed");
        }
        this.x509v3PKCert = x509v3PKCert;
    }

    public static CMPCertificate getInstance(Object o2) {
        if (o2 == null || o2 instanceof CMPCertificate) {
            return (CMPCertificate)o2;
        }
        if (o2 instanceof ASN1Sequence || o2 instanceof byte[]) {
            return new CMPCertificate(Certificate.getInstance(o2));
        }
        if (o2 instanceof ASN1TaggedObject) {
            return new CMPCertificate(AttributeCertificate.getInstance(((ASN1TaggedObject)o2).getObject()));
        }
        throw new IllegalArgumentException("Invalid object: " + o2.getClass().getName());
    }

    public boolean isX509v3PKCert() {
        return this.x509v3PKCert != null;
    }

    public Certificate getX509v3PKCert() {
        return this.x509v3PKCert;
    }

    public AttributeCertificate getX509v2AttrCert() {
        return this.x509v2AttrCert;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.x509v2AttrCert != null) {
            return new DERTaggedObject(true, 1, this.x509v2AttrCert);
        }
        return this.x509v3PKCert.toASN1Primitive();
    }
}

