/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;
import java.util.Vector;

public abstract class GF2nField {
    protected int mDegree;
    protected GF2Polynomial fieldPolynomial;
    protected Vector fields;
    protected Vector matrices;

    public final int getDegree() {
        return this.mDegree;
    }

    public final GF2Polynomial getFieldPolynomial() {
        if (this.fieldPolynomial == null) {
            this.computeFieldPolynomial();
        }
        return new GF2Polynomial(this.fieldPolynomial);
    }

    public final boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nField)) {
            return false;
        }
        GF2nField otherField = (GF2nField)other;
        if (otherField.mDegree != this.mDegree) {
            return false;
        }
        if (!this.fieldPolynomial.equals(otherField.fieldPolynomial)) {
            return false;
        }
        if (this instanceof GF2nPolynomialField && !(otherField instanceof GF2nPolynomialField)) {
            return false;
        }
        return !(this instanceof GF2nONBField) || otherField instanceof GF2nONBField;
    }

    public int hashCode() {
        return this.mDegree + this.fieldPolynomial.hashCode();
    }

    protected abstract GF2nElement getRandomRoot(GF2Polynomial var1);

    protected abstract void computeCOBMatrix(GF2nField var1);

    protected abstract void computeFieldPolynomial();

    protected final GF2Polynomial[] invertMatrix(GF2Polynomial[] matrix) {
        int j2;
        int i2;
        GF2Polynomial[] a2 = new GF2Polynomial[matrix.length];
        GF2Polynomial[] inv = new GF2Polynomial[matrix.length];
        for (i2 = 0; i2 < this.mDegree; ++i2) {
            try {
                a2[i2] = new GF2Polynomial(matrix[i2]);
                inv[i2] = new GF2Polynomial(this.mDegree);
                inv[i2].setBit(this.mDegree - 1 - i2);
                continue;
            }
            catch (RuntimeException runtimeException) {
                RuntimeException BDNEExc = runtimeException;
                runtimeException.printStackTrace();
            }
        }
        for (i2 = 0; i2 < this.mDegree - 1; ++i2) {
            for (j2 = i2; j2 < this.mDegree && !a2[j2].testBit(this.mDegree - 1 - i2); ++j2) {
            }
            if (j2 >= this.mDegree) {
                throw new RuntimeException("GF2nField.invertMatrix: Matrix cannot be inverted!");
            }
            if (i2 != j2) {
                GF2Polynomial dummy = a2[i2];
                a2[i2] = a2[j2];
                a2[j2] = dummy;
                dummy = inv[i2];
                inv[i2] = inv[j2];
                inv[j2] = dummy;
            }
            for (j2 = i2 + 1; j2 < this.mDegree; ++j2) {
                if (!a2[j2].testBit(this.mDegree - 1 - i2)) continue;
                a2[j2].addToThis(a2[i2]);
                inv[j2].addToThis(inv[i2]);
            }
        }
        for (i2 = this.mDegree - 1; i2 > 0; --i2) {
            for (j2 = i2 - 1; j2 >= 0; --j2) {
                if (!a2[j2].testBit(this.mDegree - 1 - i2)) continue;
                a2[j2].addToThis(a2[i2]);
                inv[j2].addToThis(inv[i2]);
            }
        }
        return inv;
    }

    public final GF2nElement convert(GF2nElement elem, GF2nField basis) throws RuntimeException {
        if (basis == this) {
            return (GF2nElement)elem.clone();
        }
        if (this.fieldPolynomial.equals(basis.fieldPolynomial)) {
            return (GF2nElement)elem.clone();
        }
        if (this.mDegree != basis.mDegree) {
            throw new RuntimeException("GF2nField.convert: B1 has a different degree and thus cannot be coverted to!");
        }
        int i2 = this.fields.indexOf(basis);
        if (i2 == -1) {
            this.computeCOBMatrix(basis);
            i2 = this.fields.indexOf(basis);
        }
        GF2Polynomial[] COBMatrix = (GF2Polynomial[])this.matrices.elementAt(i2);
        GF2nElement elemCopy = (GF2nElement)elem.clone();
        if (elemCopy instanceof GF2nONBElement) {
            ((GF2nONBElement)elemCopy).reverseOrder();
        }
        GF2Polynomial bs2 = new GF2Polynomial(this.mDegree, elemCopy.toFlexiBigInt());
        bs2.expandN(this.mDegree);
        GF2Polynomial result = new GF2Polynomial(this.mDegree);
        for (i2 = 0; i2 < this.mDegree; ++i2) {
            if (!bs2.vectorMult(COBMatrix[i2])) continue;
            result.setBit(this.mDegree - 1 - i2);
        }
        if (basis instanceof GF2nPolynomialField) {
            return new GF2nPolynomialElement((GF2nPolynomialField)basis, result);
        }
        if (basis instanceof GF2nONBField) {
            GF2nONBElement res = new GF2nONBElement((GF2nONBField)basis, result.toFlexiBigInt());
            res.reverseOrder();
            return res;
        }
        throw new RuntimeException("GF2nField.convert: B1 must be an instance of GF2nPolynomialField or GF2nONBField!");
    }
}

