/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.digest;

import com.timevale.tgtext.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.crypto.CipherKeyGenerator;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA384Digest;
import com.timevale.tgtext.bouncycastle.crypto.macs.HMac;
import com.timevale.tgtext.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.a;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.timevale.tgtext.bouncycastle.jce.provider.JCEMac;

public class SHA384 {

    public static class Mappings
    extends a {
        private static final String PREFIX = SHA384.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SHA-384", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SHA384", "SHA-384");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha384, "SHA-384");
            this.addHMACAlgorithm(provider, "SHA384", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(provider, "SHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA384", 384, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new SHA384Digest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA384Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d2 = (Digest)super.clone();
            ((Digest)super.clone()).digest = new SHA384Digest((SHA384Digest)this.digest);
            return d2;
        }
    }
}

