/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.crmf;

import com.timevale.tgtext.bouncycastle.asn1.crmf.EncryptedValue;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.crmf.CRMFException;
import com.timevale.tgtext.bouncycastle.cert.crmf.EncryptedValuePadder;
import com.timevale.tgtext.bouncycastle.cert.crmf.ValueDecryptorGenerator;
import com.timevale.tgtext.bouncycastle.operator.InputDecryptor;
import com.timevale.tgtext.bouncycastle.util.Strings;
import com.timevale.tgtext.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncryptedValueParser {
    private EncryptedValue value;
    private EncryptedValuePadder padder;

    public EncryptedValueParser(EncryptedValue value) {
        this.value = value;
    }

    public EncryptedValueParser(EncryptedValue value, EncryptedValuePadder padder) {
        this.value = value;
        this.padder = padder;
    }

    private byte[] decryptValue(ValueDecryptorGenerator decGen) throws CRMFException {
        if (this.value.getIntendedAlg() != null) {
            throw new UnsupportedOperationException();
        }
        if (this.value.getValueHint() != null) {
            throw new UnsupportedOperationException();
        }
        InputDecryptor decryptor = decGen.getValueDecryptor(this.value.getKeyAlg(), this.value.getSymmAlg(), this.value.getEncSymmKey().getBytes());
        InputStream dataIn = decryptor.getInputStream(new ByteArrayInputStream(this.value.getEncValue().getBytes()));
        try {
            byte[] data = Streams.readAll(dataIn);
            if (this.padder != null) {
                return this.padder.getUnpaddedData(data);
            }
            return data;
        }
        catch (IOException e2) {
            throw new CRMFException("Cannot parse decrypted data: " + e2.getMessage(), e2);
        }
    }

    public X509CertificateHolder readCertificateHolder(ValueDecryptorGenerator decGen) throws CRMFException {
        return new X509CertificateHolder(Certificate.getInstance(this.decryptValue(decGen)));
    }

    public char[] readPassphrase(ValueDecryptorGenerator decGen) throws CRMFException {
        return Strings.fromUTF8ByteArray(this.decryptValue(decGen)).toCharArray();
    }
}

