/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERInteger;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.DSAParameter;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.cert.X509AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.X509CRLHolder;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.openssl.PEMEncryptor;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.timevale.tgtext.bouncycastle.util.Strings;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemGenerationException;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemHeader;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemObject;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemObjectGenerator;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;

public class MiscPEMGenerator
implements PemObjectGenerator {
    private static final ASN1ObjectIdentifier[] dsaOids = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1};
    private static final byte[] hexEncodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private final Object obj;
    private final PEMEncryptor encryptor;

    public MiscPEMGenerator(Object o2) {
        this(o2, null);
    }

    public MiscPEMGenerator(Object o2, PEMEncryptor encryptor) {
        this.obj = o2;
        this.encryptor = encryptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PemObject createPemObject(Object o2) throws IOException {
        byte[] encoding;
        String type;
        if (o2 instanceof PemObject) {
            return (PemObject)o2;
        }
        if (o2 instanceof PemObjectGenerator) {
            return ((PemObjectGenerator)o2).generate();
        }
        if (o2 instanceof X509CertificateHolder) {
            type = "CERTIFICATE";
            encoding = ((X509CertificateHolder)o2).getEncoded();
        } else if (o2 instanceof X509CRLHolder) {
            type = "X509 CRL";
            encoding = ((X509CRLHolder)o2).getEncoded();
        } else if (o2 instanceof PrivateKeyInfo) {
            PrivateKeyInfo info = (PrivateKeyInfo)o2;
            ASN1ObjectIdentifier algOID = info.getPrivateKeyAlgorithm().getAlgorithm();
            if (algOID.equals(PKCSObjectIdentifiers.rsaEncryption)) {
                type = "RSA PRIVATE KEY";
                encoding = info.parsePrivateKey().toASN1Primitive().getEncoded();
            } else if (algOID.equals(dsaOids[0]) || algOID.equals(dsaOids[1])) {
                type = "DSA PRIVATE KEY";
                DSAParameter p2 = DSAParameter.getInstance(info.getPrivateKeyAlgorithm().getParameters());
                ASN1EncodableVector v2 = new ASN1EncodableVector();
                v2.add(new DERInteger(0L));
                v2.add(new DERInteger(p2.getP()));
                v2.add(new DERInteger(p2.getQ()));
                v2.add(new DERInteger(p2.getG()));
                BigInteger x2 = ASN1Integer.getInstance(info.parsePrivateKey()).getValue();
                BigInteger y2 = p2.getG().modPow(x2, p2.getP());
                v2.add(new DERInteger(y2));
                v2.add(new DERInteger(x2));
                encoding = new DERSequence(v2).getEncoded();
            } else {
                if (!algOID.equals(X9ObjectIdentifiers.id_ecPublicKey)) throw new IOException("Cannot identify private key");
                type = "EC PRIVATE KEY";
                encoding = info.parsePrivateKey().toASN1Primitive().getEncoded();
            }
        } else if (o2 instanceof SubjectPublicKeyInfo) {
            type = "PUBLIC KEY";
            encoding = ((SubjectPublicKeyInfo)o2).getEncoded();
        } else if (o2 instanceof X509AttributeCertificateHolder) {
            type = "ATTRIBUTE CERTIFICATE";
            encoding = ((X509AttributeCertificateHolder)o2).getEncoded();
        } else if (o2 instanceof PKCS10CertificationRequest) {
            type = "CERTIFICATE REQUEST";
            encoding = ((PKCS10CertificationRequest)o2).getEncoded();
        } else {
            if (!(o2 instanceof ContentInfo)) throw new PemGenerationException("unknown object passed - can't encode.");
            type = "PKCS7";
            encoding = ((ContentInfo)o2).getEncoded();
        }
        if (this.encryptor == null) return new PemObject(type, encoding);
        String dekAlgName = Strings.toUpperCase(this.encryptor.getAlgorithm());
        if (dekAlgName.equals("DESEDE")) {
            dekAlgName = "DES-EDE3-CBC";
        }
        byte[] iv = this.encryptor.getIV();
        byte[] encData = this.encryptor.encrypt(encoding);
        ArrayList<PemHeader> headers = new ArrayList<PemHeader>(2);
        headers.add(new PemHeader("Proc-Type", "4,ENCRYPTED"));
        headers.add(new PemHeader("DEK-Info", dekAlgName + "," + this.getHexEncoded(iv)));
        return new PemObject(type, headers, encData);
    }

    private String getHexEncoded(byte[] bytes) throws IOException {
        char[] chars = new char[bytes.length << 1];
        for (int i2 = 0; i2 != bytes.length; ++i2) {
            int v2 = bytes[i2] & 0xFF;
            chars[2 * i2] = (char)hexEncodingTable[v2 >>> 4];
            chars[2 * i2 + 1] = (char)hexEncodingTable[v2 & 0xF];
        }
        return new String(chars);
    }

    @Override
    public PemObject generate() throws PemGenerationException {
        try {
            return this.createPemObject(this.obj);
        }
        catch (IOException e2) {
            throw new PemGenerationException("encoding exception: " + e2.getMessage(), e2);
        }
    }
}

