/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.tgtext.bouncycastle.crypto.Wrapper;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.util.Arrays;

public class RFC3394WrapEngine
implements Wrapper {
    private BlockCipher engine;
    private KeyParameter param;
    private boolean forWrapping;
    private byte[] iv = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    public RFC3394WrapEngine(BlockCipher engine) {
        this.engine = engine;
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.forWrapping = forWrapping;
        if (param instanceof ParametersWithRandom) {
            param = ((ParametersWithRandom)param).getParameters();
        }
        if (param instanceof KeyParameter) {
            this.param = (KeyParameter)param;
            return;
        }
        if (param instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)param).getIV();
            this.param = (KeyParameter)((ParametersWithIV)param).getParameters();
            if (this.iv.length != 8) {
                throw new IllegalArgumentException("IV not equal to 8");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName();
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n2 = inLen / 8;
        if (n2 << 3 != inLen) {
            throw new DataLengthException("wrap data must be a multiple of 8 bytes");
        }
        byte[] block = new byte[inLen + this.iv.length];
        byte[] buf = new byte[8 + this.iv.length];
        System.arraycopy(this.iv, 0, block, 0, this.iv.length);
        System.arraycopy(in, 0, block, this.iv.length, inLen);
        this.engine.init(true, this.param);
        for (int j2 = 0; j2 != 6; ++j2) {
            for (int i2 = 1; i2 <= n2; ++i2) {
                System.arraycopy(block, 0, buf, 0, this.iv.length);
                System.arraycopy(block, i2 * 8, buf, this.iv.length, 8);
                this.engine.processBlock(buf, 0, buf, 0);
                int t2 = n2 * j2 + i2;
                int k2 = 1;
                while (t2 != 0) {
                    byte v2 = (byte)t2;
                    int n3 = this.iv.length - k2;
                    buf[n3] = (byte)(buf[n3] ^ v2);
                    t2 >>>= 8;
                    ++k2;
                }
                System.arraycopy(buf, 0, block, 0, 8);
                System.arraycopy(buf, 8, block, i2 * 8, 8);
            }
        }
        return block;
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n2 = inLen / 8;
        if (n2 << 3 != inLen) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        byte[] block = new byte[inLen - this.iv.length];
        byte[] a2 = new byte[this.iv.length];
        byte[] buf = new byte[8 + this.iv.length];
        System.arraycopy(in, 0, a2, 0, this.iv.length);
        System.arraycopy(in, this.iv.length, block, 0, inLen - this.iv.length);
        this.engine.init(false, this.param);
        --n2;
        for (int j2 = 5; j2 >= 0; --j2) {
            for (int i2 = n2; i2 > 0; --i2) {
                System.arraycopy(a2, 0, buf, 0, this.iv.length);
                System.arraycopy(block, 8 * (i2 - 1), buf, this.iv.length, 8);
                int t2 = n2 * j2 + i2;
                int k2 = 1;
                while (t2 != 0) {
                    byte v2 = (byte)t2;
                    int n3 = this.iv.length - k2;
                    buf[n3] = (byte)(buf[n3] ^ v2);
                    t2 >>>= 8;
                    ++k2;
                }
                this.engine.processBlock(buf, 0, buf, 0);
                System.arraycopy(buf, 0, a2, 0, 8);
                System.arraycopy(buf, 8, block, 8 * (i2 - 1), 8);
            }
        }
        if (!Arrays.constantTimeAreEqual(a2, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return block;
    }
}

