/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss;

import com.timevale.tgtext.bouncycastle.util.Arrays;

public class GMSSParameters {
    private int numOfLayers;
    private int[] heightOfTrees;
    private int[] winternitzParameter;
    private int[] K;

    public GMSSParameters(int layers, int[] heightOfTrees, int[] winternitzParameter, int[] K) throws IllegalArgumentException {
        this.init(layers, heightOfTrees, winternitzParameter, K);
    }

    private void init(int layers, int[] heightOfTrees, int[] winternitzParameter, int[] K) throws IllegalArgumentException {
        boolean valid = true;
        String errMsg = "";
        this.numOfLayers = layers;
        if (this.numOfLayers != winternitzParameter.length || this.numOfLayers != heightOfTrees.length || this.numOfLayers != K.length) {
            valid = false;
            errMsg = "Unexpected parameterset format";
        }
        for (int i2 = 0; i2 < this.numOfLayers; ++i2) {
            if (K[i2] < 2 || (heightOfTrees[i2] - K[i2]) % 2 != 0) {
                valid = false;
                errMsg = "Wrong parameter K (K >= 2 and H-K even required)!";
            }
            if (heightOfTrees[i2] >= 4 && winternitzParameter[i2] >= 2) continue;
            valid = false;
            errMsg = "Wrong parameter H or w (H > 3 and w > 1 required)!";
        }
        if (valid) {
            this.heightOfTrees = Arrays.clone(heightOfTrees);
            this.winternitzParameter = Arrays.clone(winternitzParameter);
            this.K = Arrays.clone(K);
            return;
        }
        throw new IllegalArgumentException(errMsg);
    }

    public GMSSParameters(int keySize) throws IllegalArgumentException {
        if (keySize <= 10) {
            int[] defh = new int[]{10};
            int[] defw = new int[]{3};
            int[] defk = new int[]{2};
            this.init(1, defh, defw, defk);
            return;
        }
        if (keySize <= 20) {
            int[] defh = new int[]{10, 10};
            int[] defw = new int[]{5, 4};
            int[] defk = new int[]{2, 2};
            this.init(2, defh, defw, defk);
            return;
        }
        int[] defh = new int[]{10, 10, 10, 10};
        int[] defw = new int[]{9, 9, 9, 3};
        int[] defk = new int[]{2, 2, 2, 2};
        this.init(4, defh, defw, defk);
    }

    public int getNumOfLayers() {
        return this.numOfLayers;
    }

    public int[] getHeightOfTrees() {
        return Arrays.clone(this.heightOfTrees);
    }

    public int[] getWinternitzParameter() {
        return Arrays.clone(this.winternitzParameter);
    }

    public int[] getK() {
        return Arrays.clone(this.K);
    }
}

