/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss;

import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSLeaf;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSRootCalc;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSRootSig;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.Treehash;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import java.util.Vector;

public class GMSSPrivateKeyParameters
extends GMSSKeyParameters {
    private int[] index;
    private byte[][] currentSeeds;
    private byte[][] nextNextSeeds;
    private byte[][][] currentAuthPaths;
    private byte[][][] nextAuthPaths;
    private Treehash[][] currentTreehash;
    private Treehash[][] nextTreehash;
    private Vector[] currentStack;
    private Vector[] nextStack;
    private Vector[][] currentRetain;
    private Vector[][] nextRetain;
    private byte[][][] keep;
    private GMSSLeaf[] nextNextLeaf;
    private GMSSLeaf[] upperLeaf;
    private GMSSLeaf[] upperTreehashLeaf;
    private int[] minTreehash;
    private GMSSParameters gmssPS;
    private byte[][] nextRoot;
    private GMSSRootCalc[] nextNextRoot;
    private byte[][] currentRootSig;
    private GMSSRootSig[] nextRootSig;
    private GMSSDigestProvider digestProvider;
    private int[] heightOfTrees;
    private int[] otsIndex;
    private int[] K;
    private int numLayer;
    private Digest messDigestTrees;
    private int mdLength;
    private GMSSRandom gmssRandom;
    private int[] numLeafs;

    public GMSSPrivateKeyParameters(byte[][] currentSeed, byte[][] nextNextSeed, byte[][][] currentAuthPath, byte[][][] nextAuthPath, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, byte[][] nextRoot, byte[][] currentRootSig, GMSSParameters gmssParameterset, GMSSDigestProvider digestProvider) {
        this(null, currentSeed, nextNextSeed, currentAuthPath, nextAuthPath, null, currentTreehash, nextTreehash, currentStack, nextStack, currentRetain, nextRetain, null, null, null, null, nextRoot, null, currentRootSig, null, gmssParameterset, digestProvider);
    }

    public GMSSPrivateKeyParameters(int[] index, byte[][] currentSeeds, byte[][] nextNextSeeds, byte[][][] currentAuthPaths, byte[][][] nextAuthPaths, byte[][][] keep, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, GMSSLeaf[] nextNextLeaf, GMSSLeaf[] upperLeaf, GMSSLeaf[] upperTreehashLeaf, int[] minTreehash, byte[][] nextRoot, GMSSRootCalc[] nextNextRoot, byte[][] currentRootSig, GMSSRootSig[] nextRootSig, GMSSParameters gmssParameterset, GMSSDigestProvider digestProvider) {
        super(true, gmssParameterset);
        int i2;
        this.messDigestTrees = digestProvider.get();
        this.mdLength = this.messDigestTrees.getDigestSize();
        this.gmssPS = gmssParameterset;
        this.otsIndex = gmssParameterset.getWinternitzParameter();
        this.K = gmssParameterset.getK();
        this.heightOfTrees = gmssParameterset.getHeightOfTrees();
        this.numLayer = this.gmssPS.getNumOfLayers();
        if (index == null) {
            this.index = new int[this.numLayer];
            for (i2 = 0; i2 < this.numLayer; ++i2) {
                this.index[i2] = 0;
            }
        } else {
            this.index = index;
        }
        this.currentSeeds = currentSeeds;
        this.nextNextSeeds = nextNextSeeds;
        this.currentAuthPaths = currentAuthPaths;
        this.nextAuthPaths = nextAuthPaths;
        if (keep == null) {
            this.keep = new byte[this.numLayer][][];
            for (i2 = 0; i2 < this.numLayer; ++i2) {
                this.keep[i2] = new byte[(int)Math.floor(this.heightOfTrees[i2] / 2)][this.mdLength];
            }
        } else {
            this.keep = keep;
        }
        if (currentStack == null) {
            this.currentStack = new Vector[this.numLayer];
            for (i2 = 0; i2 < this.numLayer; ++i2) {
                this.currentStack[i2] = new Vector();
            }
        } else {
            this.currentStack = currentStack;
        }
        if (nextStack == null) {
            this.nextStack = new Vector[this.numLayer - 1];
            for (i2 = 0; i2 < this.numLayer - 1; ++i2) {
                this.nextStack[i2] = new Vector();
            }
        } else {
            this.nextStack = nextStack;
        }
        this.currentTreehash = currentTreehash;
        this.nextTreehash = nextTreehash;
        this.currentRetain = currentRetain;
        this.nextRetain = nextRetain;
        this.nextRoot = nextRoot;
        this.digestProvider = digestProvider;
        if (nextNextRoot == null) {
            this.nextNextRoot = new GMSSRootCalc[this.numLayer - 1];
            for (i2 = 0; i2 < this.numLayer - 1; ++i2) {
                this.nextNextRoot[i2] = new GMSSRootCalc(this.heightOfTrees[i2 + 1], this.K[i2 + 1], this.digestProvider);
            }
        } else {
            this.nextNextRoot = nextNextRoot;
        }
        this.currentRootSig = currentRootSig;
        this.numLeafs = new int[this.numLayer];
        for (i2 = 0; i2 < this.numLayer; ++i2) {
            this.numLeafs[i2] = 1 << this.heightOfTrees[i2];
        }
        this.gmssRandom = new GMSSRandom(this.messDigestTrees);
        if (this.numLayer > 1) {
            if (nextNextLeaf == null) {
                this.nextNextLeaf = new GMSSLeaf[this.numLayer - 2];
                for (i2 = 0; i2 < this.numLayer - 2; ++i2) {
                    this.nextNextLeaf[i2] = new GMSSLeaf(digestProvider.get(), this.otsIndex[i2 + 1], this.numLeafs[i2 + 2]);
                    this.nextNextLeaf[i2].initLeafCalc(this.nextNextSeeds[i2]);
                }
            } else {
                this.nextNextLeaf = nextNextLeaf;
            }
        } else {
            this.nextNextLeaf = new GMSSLeaf[0];
        }
        if (upperLeaf == null) {
            this.upperLeaf = new GMSSLeaf[this.numLayer - 1];
            for (i2 = 0; i2 < this.numLayer - 1; ++i2) {
                this.upperLeaf[i2] = new GMSSLeaf(digestProvider.get(), this.otsIndex[i2], this.numLeafs[i2 + 1]);
                this.upperLeaf[i2].initLeafCalc(this.currentSeeds[i2]);
            }
        } else {
            this.upperLeaf = upperLeaf;
        }
        if (upperTreehashLeaf == null) {
            this.upperTreehashLeaf = new GMSSLeaf[this.numLayer - 1];
            for (i2 = 0; i2 < this.numLayer - 1; ++i2) {
                this.upperTreehashLeaf[i2] = new GMSSLeaf(digestProvider.get(), this.otsIndex[i2], this.numLeafs[i2 + 1]);
            }
        } else {
            this.upperTreehashLeaf = upperTreehashLeaf;
        }
        if (minTreehash == null) {
            this.minTreehash = new int[this.numLayer - 1];
            for (i2 = 0; i2 < this.numLayer - 1; ++i2) {
                this.minTreehash[i2] = -1;
            }
        } else {
            this.minTreehash = minTreehash;
        }
        byte[] dummy = new byte[this.mdLength];
        if (nextRootSig == null) {
            this.nextRootSig = new GMSSRootSig[this.numLayer - 1];
            for (int i3 = 0; i3 < this.numLayer - 1; ++i3) {
                System.arraycopy(currentSeeds[i3], 0, dummy, 0, this.mdLength);
                this.gmssRandom.nextSeed(dummy);
                byte[] OTSseed = this.gmssRandom.nextSeed(dummy);
                this.nextRootSig[i3] = new GMSSRootSig(digestProvider.get(), this.otsIndex[i3], this.heightOfTrees[i3 + 1]);
                this.nextRootSig[i3].initSign(OTSseed, nextRoot[i3]);
            }
            return;
        }
        this.nextRootSig = nextRootSig;
    }

    public void nextKey(int layer) {
        if (layer == this.numLayer - 1) {
            int n2 = layer;
            this.index[n2] = this.index[n2] + 1;
        }
        if (this.index[layer] == this.numLeafs[layer]) {
            if (this.numLayer != 1) {
                this.nextTree(layer);
                this.index[layer] = 0;
                return;
            }
        } else {
            this.updateKey(layer);
        }
    }

    private void nextTree(int layer) {
        if (layer > 0) {
            int n2 = layer - 1;
            this.index[n2] = this.index[n2] + 1;
            boolean lastTree = true;
            int z2 = layer;
            do {
                if (this.index[--z2] >= this.numLeafs[z2]) continue;
                lastTree = false;
            } while (lastTree && z2 > 0);
            if (!lastTree) {
                int i2;
                this.gmssRandom.nextSeed(this.currentSeeds[layer]);
                this.nextRootSig[layer - 1].updateSign();
                if (layer > 1) {
                    this.nextNextLeaf[layer - 1 - 1].updateLeafCalc();
                }
                this.upperLeaf[layer - 1].updateLeafCalc();
                if (this.minTreehash[layer - 1] >= 0) {
                    this.upperTreehashLeaf[layer - 1].updateLeafCalc();
                    byte[] leaf = this.upperTreehashLeaf[layer - 1].getLeaf();
                    try {
                        this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].update(this.gmssRandom, leaf);
                        this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].wasFinished();
                    }
                    catch (Exception e2) {
                        System.out.println(e2);
                    }
                }
                this.updateNextNextAuthRoot(layer);
                this.currentRootSig[layer - 1] = this.nextRootSig[layer - 1].getSig();
                for (i2 = 0; i2 < this.heightOfTrees[layer] - this.K[layer]; ++i2) {
                    this.currentTreehash[layer][i2] = this.nextTreehash[layer - 1][i2];
                    this.nextTreehash[layer - 1][i2] = this.nextNextRoot[layer - 1].getTreehash()[i2];
                }
                for (i2 = 0; i2 < this.heightOfTrees[layer]; ++i2) {
                    System.arraycopy(this.nextAuthPaths[layer - 1][i2], 0, this.currentAuthPaths[layer][i2], 0, this.mdLength);
                    System.arraycopy(this.nextNextRoot[layer - 1].getAuthPath()[i2], 0, this.nextAuthPaths[layer - 1][i2], 0, this.mdLength);
                }
                for (i2 = 0; i2 < this.K[layer] - 1; ++i2) {
                    this.currentRetain[layer][i2] = this.nextRetain[layer - 1][i2];
                    this.nextRetain[layer - 1][i2] = this.nextNextRoot[layer - 1].getRetain()[i2];
                }
                this.currentStack[layer] = this.nextStack[layer - 1];
                this.nextStack[layer - 1] = this.nextNextRoot[layer - 1].getStack();
                this.nextRoot[layer - 1] = this.nextNextRoot[layer - 1].getRoot();
                byte[] dummy = new byte[this.mdLength];
                System.arraycopy(this.currentSeeds[layer - 1], 0, dummy, 0, this.mdLength);
                this.gmssRandom.nextSeed(dummy);
                this.gmssRandom.nextSeed(dummy);
                byte[] OTSseed = this.gmssRandom.nextSeed(dummy);
                this.nextRootSig[layer - 1].initSign(OTSseed, this.nextRoot[layer - 1]);
                this.nextKey(layer - 1);
            }
        }
    }

    private void updateKey(int layer) {
        this.computeAuthPaths(layer);
        if (layer > 0) {
            if (layer > 1) {
                this.nextNextLeaf[layer - 1 - 1].updateLeafCalc();
            }
            this.upperLeaf[layer - 1].updateLeafCalc();
            int t2 = (int)Math.floor((double)(this.getNumLeafs(layer) << 1) / (double)(this.heightOfTrees[layer - 1] - this.K[layer - 1]));
            if (this.index[layer] % t2 == 1) {
                if (this.index[layer] > 1 && this.minTreehash[layer - 1] >= 0) {
                    byte[] leaf = this.upperTreehashLeaf[layer - 1].getLeaf();
                    try {
                        this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].update(this.gmssRandom, leaf);
                        this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].wasFinished();
                    }
                    catch (Exception e2) {
                        System.out.println(e2);
                    }
                }
                this.minTreehash[layer - 1] = this.getMinTreehashIndex(layer - 1);
                if (this.minTreehash[layer - 1] >= 0) {
                    byte[] seed = this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].getSeedActive();
                    this.upperTreehashLeaf[layer - 1] = new GMSSLeaf(this.digestProvider.get(), this.otsIndex[layer - 1], t2);
                    this.upperTreehashLeaf[layer - 1].initLeafCalc(seed);
                    this.upperTreehashLeaf[layer - 1].updateLeafCalc();
                }
            } else if (this.minTreehash[layer - 1] >= 0) {
                this.upperTreehashLeaf[layer - 1].updateLeafCalc();
            }
            this.nextRootSig[layer - 1].updateSign();
            if (this.index[layer] == 1) {
                this.nextNextRoot[layer - 1].initialize(new Vector());
            }
            this.updateNextNextAuthRoot(layer);
        }
    }

    private int getMinTreehashIndex(int layer) {
        int minTreehash = -1;
        for (int h2 = 0; h2 < this.heightOfTrees[layer] - this.K[layer]; ++h2) {
            if (!this.currentTreehash[layer][h2].wasInitialized() || this.currentTreehash[layer][h2].wasFinished()) continue;
            if (minTreehash == -1) {
                minTreehash = h2;
                continue;
            }
            if (this.currentTreehash[layer][h2].getLowestNodeHeight() >= this.currentTreehash[layer][minTreehash].getLowestNodeHeight()) continue;
            minTreehash = h2;
        }
        return minTreehash;
    }

    private void computeAuthPaths(int layer) {
        int Phi = this.index[layer];
        int H = this.heightOfTrees[layer];
        int K = this.K[layer];
        for (int i2 = 0; i2 < H - K; ++i2) {
            this.currentTreehash[layer][i2].updateNextSeed(this.gmssRandom);
        }
        int Tau = this.heightOfPhi(Phi);
        byte[] OTSseed = this.gmssRandom.nextSeed(this.currentSeeds[layer]);
        int L = Phi >>> Tau + 1 & 1;
        byte[] tempKeep = new byte[this.mdLength];
        if (Tau < H - 1 && L == 0) {
            System.arraycopy(this.currentAuthPaths[layer][Tau], 0, tempKeep, 0, this.mdLength);
        }
        if (Tau == 0) {
            byte[] help;
            if (layer == this.numLayer - 1) {
                WinternitzOTSignature ots = new WinternitzOTSignature(OTSseed, this.digestProvider.get(), this.otsIndex[layer]);
                help = ots.getPublicKey();
            } else {
                byte[] dummy = new byte[this.mdLength];
                System.arraycopy(this.currentSeeds[layer], 0, dummy, 0, this.mdLength);
                this.gmssRandom.nextSeed(dummy);
                help = this.upperLeaf[layer].getLeaf();
                this.upperLeaf[layer].initLeafCalc(dummy);
            }
            System.arraycopy(help, 0, this.currentAuthPaths[layer][0], 0, this.mdLength);
        } else {
            byte[] toBeHashed = new byte[this.mdLength << 1];
            System.arraycopy(this.currentAuthPaths[layer][Tau - 1], 0, toBeHashed, 0, this.mdLength);
            System.arraycopy(this.keep[layer][(int)Math.floor((Tau - 1) / 2)], 0, toBeHashed, this.mdLength, this.mdLength);
            this.messDigestTrees.update(toBeHashed, 0, toBeHashed.length);
            this.currentAuthPaths[layer][Tau] = new byte[this.messDigestTrees.getDigestSize()];
            this.messDigestTrees.doFinal(this.currentAuthPaths[layer][Tau], 0);
            for (int i3 = 0; i3 < Tau; ++i3) {
                int startPoint;
                if (i3 < H - K) {
                    if (this.currentTreehash[layer][i3].wasFinished()) {
                        System.arraycopy(this.currentTreehash[layer][i3].getFirstNode(), 0, this.currentAuthPaths[layer][i3], 0, this.mdLength);
                        this.currentTreehash[layer][i3].destroy();
                    } else {
                        System.err.println("Treehash (" + layer + "," + i3 + ") not finished when needed in AuthPathComputation");
                    }
                }
                if (i3 < H - 1 && i3 >= H - K && this.currentRetain[layer][i3 - (H - K)].size() > 0) {
                    System.arraycopy(this.currentRetain[layer][i3 - (H - K)].lastElement(), 0, this.currentAuthPaths[layer][i3], 0, this.mdLength);
                    this.currentRetain[layer][i3 - (H - K)].removeElementAt(this.currentRetain[layer][i3 - (H - K)].size() - 1);
                }
                if (i3 >= H - K || (startPoint = Phi + 3 * (1 << i3)) >= this.numLeafs[layer]) continue;
                this.currentTreehash[layer][i3].initialize();
            }
        }
        if (Tau < H - 1 && L == 0) {
            System.arraycopy(tempKeep, 0, this.keep[layer][(int)Math.floor(Tau / 2)], 0, this.mdLength);
        }
        if (layer == this.numLayer - 1) {
            for (int tmp = 1; tmp <= (H - K) / 2; ++tmp) {
                int minTreehash = this.getMinTreehashIndex(layer);
                if (minTreehash < 0) continue;
                try {
                    byte[] seed = new byte[this.mdLength];
                    System.arraycopy(this.currentTreehash[layer][minTreehash].getSeedActive(), 0, seed, 0, this.mdLength);
                    byte[] seed2 = this.gmssRandom.nextSeed(seed);
                    WinternitzOTSignature ots = new WinternitzOTSignature(seed2, this.digestProvider.get(), this.otsIndex[layer]);
                    byte[] leaf = ots.getPublicKey();
                    this.currentTreehash[layer][minTreehash].update(this.gmssRandom, leaf);
                    continue;
                }
                catch (Exception e2) {
                    System.out.println(e2);
                }
            }
            return;
        }
        this.minTreehash[layer] = this.getMinTreehashIndex(layer);
    }

    private int heightOfPhi(int Phi) {
        if (Phi == 0) {
            return -1;
        }
        int Tau = 0;
        int modul = 1;
        while (Phi % modul == 0) {
            modul <<= 1;
            ++Tau;
        }
        return Tau - 1;
    }

    private void updateNextNextAuthRoot(int layer) {
        byte[] OTSseed = this.gmssRandom.nextSeed(this.nextNextSeeds[layer - 1]);
        if (layer == this.numLayer - 1) {
            WinternitzOTSignature ots = new WinternitzOTSignature(OTSseed, this.digestProvider.get(), this.otsIndex[layer]);
            this.nextNextRoot[layer - 1].update(this.nextNextSeeds[layer - 1], ots.getPublicKey());
            return;
        }
        this.nextNextRoot[layer - 1].update(this.nextNextSeeds[layer - 1], this.nextNextLeaf[layer - 1].getLeaf());
        this.nextNextLeaf[layer - 1].initLeafCalc(this.nextNextSeeds[layer - 1]);
    }

    public int[] getIndex() {
        return this.index;
    }

    public int getIndex(int i2) {
        return this.index[i2];
    }

    public byte[][] getCurrentSeeds() {
        return this.currentSeeds;
    }

    public byte[][] getNextNextSeeds() {
        return this.nextNextSeeds;
    }

    public byte[][][] getCurrentAuthPaths() {
        return this.currentAuthPaths;
    }

    public byte[][][] getNextAuthPaths() {
        return this.nextAuthPaths;
    }

    public Treehash[][] getCurrentTreehash() {
        return this.currentTreehash;
    }

    public Treehash[][] getNextTreehash() {
        return this.nextTreehash;
    }

    public byte[][][] getKeep() {
        return this.keep;
    }

    public Vector[] getCurrentStack() {
        return this.currentStack;
    }

    public Vector[] getNextStack() {
        return this.nextStack;
    }

    public Vector[][] getCurrentRetain() {
        return this.currentRetain;
    }

    public Vector[][] getNextRetain() {
        return this.nextRetain;
    }

    public GMSSLeaf[] getNextNextLeaf() {
        return this.nextNextLeaf;
    }

    public GMSSLeaf[] getUpperLeaf() {
        return this.upperLeaf;
    }

    public GMSSLeaf[] getUpperTreehashLeaf() {
        return this.upperTreehashLeaf;
    }

    public int[] getMinTreehash() {
        return this.minTreehash;
    }

    public GMSSRootSig[] getNextRootSig() {
        return this.nextRootSig;
    }

    public byte[][] getNextRoot() {
        return this.nextRoot;
    }

    public GMSSRootCalc[] getNextNextRoot() {
        return this.nextNextRoot;
    }

    public byte[][] getCurrentRootSig() {
        return this.currentRootSig;
    }

    public byte[] getSubtreeRootSig(int i2) {
        return this.currentRootSig[i2];
    }

    public GMSSDigestProvider getName() {
        return this.digestProvider;
    }

    public int getNumLeafs(int i2) {
        return this.numLeafs[i2];
    }

    public int[] getNumLeafs() {
        return this.numLeafs;
    }
}

