/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERUTF8String;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import java.util.Enumeration;
import java.util.Vector;

public class IetfAttrSyntax
extends ASN1Object {
    public static final int VALUE_OCTETS = 1;
    public static final int VALUE_OID = 2;
    public static final int VALUE_UTF8 = 3;
    GeneralNames policyAuthority = null;
    Vector values = new Vector();
    int valueChoice = -1;

    public static IetfAttrSyntax getInstance(Object obj) {
        if (obj instanceof IetfAttrSyntax) {
            return (IetfAttrSyntax)obj;
        }
        if (obj != null) {
            return new IetfAttrSyntax(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private IetfAttrSyntax(ASN1Sequence seq) {
        int i2 = 0;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.policyAuthority = GeneralNames.getInstance((ASN1TaggedObject)seq.getObjectAt(0), false);
            ++i2;
        } else if (seq.size() == 2) {
            this.policyAuthority = GeneralNames.getInstance(seq.getObjectAt(0));
            ++i2;
        }
        if (!(seq.getObjectAt(i2) instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Non-IetfAttrSyntax encoding");
        }
        seq = (ASN1Sequence)seq.getObjectAt(i2);
        Enumeration e2 = seq.getObjects();
        while (e2.hasMoreElements()) {
            int type;
            ASN1Primitive obj = (ASN1Primitive)e2.nextElement();
            if (obj instanceof ASN1ObjectIdentifier) {
                type = 2;
            } else if (obj instanceof DERUTF8String) {
                type = 3;
            } else if (obj instanceof DEROctetString) {
                type = 1;
            } else {
                throw new IllegalArgumentException("Bad value type encoding IetfAttrSyntax");
            }
            if (this.valueChoice < 0) {
                this.valueChoice = type;
            }
            if (type != this.valueChoice) {
                throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
            }
            this.values.addElement(obj);
        }
    }

    public GeneralNames getPolicyAuthority() {
        return this.policyAuthority;
    }

    public int getValueType() {
        return this.valueChoice;
    }

    public Object[] getValues() {
        if (this.getValueType() == 1) {
            Object[] tmp = new ASN1OctetString[this.values.size()];
            for (int i2 = 0; i2 != tmp.length; ++i2) {
                tmp[i2] = (ASN1OctetString)this.values.elementAt(i2);
            }
            return tmp;
        }
        if (this.getValueType() == 2) {
            Object[] tmp = new ASN1ObjectIdentifier[this.values.size()];
            for (int i3 = 0; i3 != tmp.length; ++i3) {
                tmp[i3] = (ASN1ObjectIdentifier)this.values.elementAt(i3);
            }
            return tmp;
        }
        Object[] tmp = new DERUTF8String[this.values.size()];
        for (int i4 = 0; i4 != tmp.length; ++i4) {
            tmp[i4] = (DERUTF8String)this.values.elementAt(i4);
        }
        return tmp;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.policyAuthority != null) {
            v2.add(new DERTaggedObject(0, this.policyAuthority));
        }
        ASN1EncodableVector v22 = new ASN1EncodableVector();
        Enumeration i2 = this.values.elements();
        while (i2.hasMoreElements()) {
            v22.add((ASN1Encodable)i2.nextElement());
        }
        v2.add(new DERSequence(v22));
        return new DERSequence(v2);
    }
}

