/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce.provider;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.PBEParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.io.DigestInputStream;
import com.timevale.tgtext.bouncycastle.crypto.io.DigestOutputStream;
import com.timevale.tgtext.bouncycastle.crypto.io.MacInputStream;
import com.timevale.tgtext.bouncycastle.crypto.io.MacOutputStream;
import com.timevale.tgtext.bouncycastle.crypto.macs.HMac;
import com.timevale.tgtext.bouncycastle.jce.interfaces.BCKeyStore;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.io.Streams;
import com.timevale.tgtext.bouncycastle.util.io.TeeOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JDKKeyStore
extends KeyStoreSpi
implements BCKeyStore {
    private static final int STORE_VERSION = 2;
    private static final int STORE_SALT_SIZE = 20;
    private static final String STORE_CIPHER = "PBEWithSHAAndTwofish-CBC";
    private static final int KEY_SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 1024;
    private static final String KEY_CIPHER = "PBEWithSHAAnd3-KeyTripleDES-CBC";
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected Hashtable table = new Hashtable();
    protected SecureRandom random = new SecureRandom();

    private void encodeCertificate(Certificate cert, DataOutputStream dOut) throws IOException {
        try {
            byte[] cEnc = cert.getEncoded();
            dOut.writeUTF(cert.getType());
            dOut.writeInt(cEnc.length);
            dOut.write(cEnc);
            return;
        }
        catch (CertificateEncodingException ex2) {
            throw new IOException(ex2.toString());
        }
    }

    private Certificate decodeCertificate(DataInputStream dIn) throws IOException {
        String type = dIn.readUTF();
        byte[] cEnc = new byte[dIn.readInt()];
        dIn.readFully(cEnc);
        try {
            CertificateFactory cFact = CertificateFactory.getInstance(type, BouncyCastleProvider.PROVIDER_NAME);
            ByteArrayInputStream bIn = new ByteArrayInputStream(cEnc);
            return cFact.generateCertificate(bIn);
        }
        catch (NoSuchProviderException ex2) {
            throw new IOException(ex2.toString());
        }
        catch (CertificateException ex3) {
            throw new IOException(ex3.toString());
        }
    }

    private void encodeKey(Key key, DataOutputStream dOut) throws IOException {
        byte[] enc = key.getEncoded();
        if (key instanceof PrivateKey) {
            dOut.write(0);
        } else if (key instanceof PublicKey) {
            dOut.write(1);
        } else {
            dOut.write(2);
        }
        dOut.writeUTF(key.getFormat());
        dOut.writeUTF(key.getAlgorithm());
        dOut.writeInt(enc.length);
        dOut.write(enc);
    }

    private Key decodeKey(DataInputStream dIn) throws IOException {
        EncodedKeySpec spec;
        int keyType = dIn.read();
        String format = dIn.readUTF();
        String algorithm = dIn.readUTF();
        byte[] enc = new byte[dIn.readInt()];
        dIn.readFully(enc);
        if (format.equals("PKCS#8") || format.equals("PKCS8")) {
            spec = new PKCS8EncodedKeySpec(enc);
        } else if (format.equals("X.509") || format.equals("X509")) {
            spec = new X509EncodedKeySpec(enc);
        } else {
            if (format.equals("RAW")) {
                return new SecretKeySpec(enc, algorithm);
            }
            throw new IOException("Key format " + format + " not recognised!");
        }
        try {
            switch (keyType) {
                case 0: {
                    return KeyFactory.getInstance(algorithm, BouncyCastleProvider.PROVIDER_NAME).generatePrivate(spec);
                }
                case 1: {
                    return KeyFactory.getInstance(algorithm, BouncyCastleProvider.PROVIDER_NAME).generatePublic(spec);
                }
                case 2: {
                    return SecretKeyFactory.getInstance(algorithm, BouncyCastleProvider.PROVIDER_NAME).generateSecret(spec);
                }
            }
            throw new IOException("Key type " + keyType + " not recognised!");
        }
        catch (Exception e2) {
            throw new IOException("Exception creating key: " + e2.toString());
        }
    }

    protected Cipher makePBECipher(String algorithm, int mode, char[] password, byte[] salt, int iterationCount) throws IOException {
        try {
            PBEKeySpec pbeSpec = new PBEKeySpec(password);
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, BouncyCastleProvider.PROVIDER_NAME);
            PBEParameterSpec defParams = new PBEParameterSpec(salt, iterationCount);
            Cipher cipher = Cipher.getInstance(algorithm, BouncyCastleProvider.PROVIDER_NAME);
            cipher.init(mode, (Key)keyFact.generateSecret(pbeSpec), defParams);
            return cipher;
        }
        catch (Exception e2) {
            throw new IOException("Error initialising store of key store: " + e2);
        }
    }

    @Override
    public void setRandom(SecureRandom rand) {
        this.random = rand;
    }

    public Enumeration engineAliases() {
        return this.table.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.table.get(alias) != null;
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Object entry = this.table.get(alias);
        if (entry == null) {
            throw new KeyStoreException("no such entry as " + alias);
        }
        this.table.remove(alias);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        a entry = (a)this.table.get(alias);
        if (entry != null) {
            if (entry.a() == 1) {
                return (Certificate)entry.c();
            }
            Certificate[] chain = entry.d();
            if (chain != null) {
                return chain[0];
            }
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        Enumeration e2 = this.table.elements();
        while (e2.hasMoreElements()) {
            Certificate[] chain;
            Certificate c2;
            a entry = (a)e2.nextElement();
            if (!(entry.c() instanceof Certificate ? (c2 = (Certificate)entry.c()).equals(cert) : (chain = entry.d()) != null && chain[0].equals(cert))) continue;
            return entry.b();
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        a entry = (a)this.table.get(alias);
        if (entry != null) {
            return entry.d();
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        a entry = (a)this.table.get(alias);
        if (entry != null) {
            return entry.e();
        }
        return null;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        a entry = (a)this.table.get(alias);
        if (entry == null || entry.a() == 1) {
            return null;
        }
        return (Key)entry.a(password);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        a entry = (a)this.table.get(alias);
        return entry != null && entry.a() == 1;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        a entry = (a)this.table.get(alias);
        return entry != null && entry.a() != 1;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        a entry = (a)this.table.get(alias);
        if (entry != null && entry.a() != 1) {
            throw new KeyStoreException("key store already has a key entry with alias " + alias);
        }
        this.table.put(alias, new a(alias, cert));
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        this.table.put(alias, new a(alias, key, chain));
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (key instanceof PrivateKey && chain == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        try {
            this.table.put(alias, new a(alias, key, password, chain));
            return;
        }
        catch (Exception e2) {
            throw new KeyStoreException(e2.toString());
        }
    }

    @Override
    public int engineSize() {
        return this.table.size();
    }

    protected void loadStore(InputStream in) throws IOException {
        DataInputStream dIn = new DataInputStream(in);
        int type = dIn.read();
        while (type > 0) {
            String alias = dIn.readUTF();
            Date date = new Date(dIn.readLong());
            int chainLength = dIn.readInt();
            Certificate[] chain = null;
            if (chainLength != 0) {
                chain = new Certificate[chainLength];
                for (int i2 = 0; i2 != chainLength; ++i2) {
                    chain[i2] = this.decodeCertificate(dIn);
                }
            }
            switch (type) {
                case 1: {
                    Certificate cert = this.decodeCertificate(dIn);
                    this.table.put(alias, new a(alias, date, 1, cert));
                    break;
                }
                case 2: {
                    Key key = this.decodeKey(dIn);
                    this.table.put(alias, new a(alias, date, 2, key, chain));
                    break;
                }
                case 3: 
                case 4: {
                    byte[] b2 = new byte[dIn.readInt()];
                    dIn.readFully(b2);
                    this.table.put(alias, new a(alias, date, type, b2, chain));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown object type in store.");
                }
            }
            type = dIn.read();
        }
    }

    protected void saveStore(OutputStream out) throws IOException {
        Enumeration e2 = this.table.elements();
        DataOutputStream dOut = new DataOutputStream(out);
        block5: while (e2.hasMoreElements()) {
            a entry = (a)e2.nextElement();
            dOut.write(entry.a());
            dOut.writeUTF(entry.b());
            dOut.writeLong(entry.e().getTime());
            Certificate[] chain = entry.d();
            if (chain == null) {
                dOut.writeInt(0);
            } else {
                dOut.writeInt(chain.length);
                for (int i2 = 0; i2 != chain.length; ++i2) {
                    this.encodeCertificate(chain[i2], dOut);
                }
            }
            switch (entry.a()) {
                case 1: {
                    this.encodeCertificate((Certificate)entry.c(), dOut);
                    continue block5;
                }
                case 2: {
                    this.encodeKey((Key)entry.c(), dOut);
                    continue block5;
                }
                case 3: 
                case 4: {
                    byte[] b2 = (byte[])entry.c();
                    dOut.writeInt(b2.length);
                    dOut.write(b2);
                    continue block5;
                }
            }
            throw new RuntimeException("Unknown object type in store.");
        }
        dOut.write(0);
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        this.table.clear();
        if (stream == null) {
            return;
        }
        DataInputStream dIn = new DataInputStream(stream);
        int version = dIn.readInt();
        if (version != 2 && version != 0 && version != 1) {
            throw new IOException("Wrong version of key store.");
        }
        int saltLength = dIn.readInt();
        if (saltLength <= 0) {
            throw new IOException("Invalid salt detected");
        }
        byte[] salt = new byte[saltLength];
        dIn.readFully(salt);
        int iterationCount = dIn.readInt();
        HMac hMac = new HMac(new SHA1Digest());
        if (password != null && password.length != 0) {
            byte[] passKey = PBEParametersGenerator.PKCS12PasswordToBytes(password);
            PKCS12ParametersGenerator pbeGen = new PKCS12ParametersGenerator(new SHA1Digest());
            pbeGen.init(passKey, salt, iterationCount);
            CipherParameters macParams = version != 2 ? ((PBEParametersGenerator)pbeGen).generateDerivedMacParameters(hMac.getMacSize()) : ((PBEParametersGenerator)pbeGen).generateDerivedMacParameters(hMac.getMacSize() << 3);
            Arrays.fill(passKey, (byte)0);
            hMac.init(macParams);
            MacInputStream mIn = new MacInputStream(dIn, hMac);
            this.loadStore(mIn);
            byte[] mac = new byte[hMac.getMacSize()];
            hMac.doFinal(mac, 0);
            byte[] oldMac = new byte[hMac.getMacSize()];
            dIn.readFully(oldMac);
            if (!Arrays.constantTimeAreEqual(mac, oldMac)) {
                this.table.clear();
                throw new IOException("KeyStore integrity check failed.");
            }
            return;
        }
        this.loadStore(dIn);
        byte[] oldMac = new byte[hMac.getMacSize()];
        dIn.readFully(oldMac);
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException {
        DataOutputStream dOut = new DataOutputStream(stream);
        byte[] salt = new byte[20];
        int iterationCount = 1024 + (this.random.nextInt() & 0x3FF);
        this.random.nextBytes(salt);
        dOut.writeInt(2);
        dOut.writeInt(20);
        dOut.write(salt);
        dOut.writeInt(iterationCount);
        HMac hMac = new HMac(new SHA1Digest());
        MacOutputStream mOut = new MacOutputStream(hMac);
        PKCS12ParametersGenerator pbeGen = new PKCS12ParametersGenerator(new SHA1Digest());
        byte[] passKey = PBEParametersGenerator.PKCS12PasswordToBytes(password);
        pbeGen.init(passKey, salt, iterationCount);
        hMac.init(((PBEParametersGenerator)pbeGen).generateDerivedMacParameters(hMac.getMacSize() << 3));
        for (int i2 = 0; i2 != passKey.length; ++i2) {
            passKey[i2] = 0;
        }
        this.saveStore(new TeeOutputStream(dOut, mOut));
        byte[] mac = new byte[hMac.getMacSize()];
        hMac.doFinal(mac, 0);
        dOut.write(mac);
        dOut.close();
    }

    public static class BouncyCastleStore
    extends JDKKeyStore {
        @Override
        public void engineLoad(InputStream stream, char[] password) throws IOException {
            this.table.clear();
            if (stream == null) {
                return;
            }
            DataInputStream dIn = new DataInputStream(stream);
            int version = dIn.readInt();
            if (version != 2 && version != 0 && version != 1) {
                throw new IOException("Wrong version of key store.");
            }
            byte[] salt = new byte[dIn.readInt()];
            if (salt.length != 20) {
                throw new IOException("Key store corrupted.");
            }
            dIn.readFully(salt);
            int iterationCount = dIn.readInt();
            if (iterationCount < 0 || iterationCount > 4096) {
                throw new IOException("Key store corrupted.");
            }
            String cipherAlg = version == 0 ? "OldPBEWithSHAAndTwofish-CBC" : JDKKeyStore.STORE_CIPHER;
            Cipher cipher = this.makePBECipher(cipherAlg, 2, password, salt, iterationCount);
            CipherInputStream cIn = new CipherInputStream(dIn, cipher);
            SHA1Digest dig = new SHA1Digest();
            DigestInputStream dgIn = new DigestInputStream(cIn, dig);
            this.loadStore(dgIn);
            byte[] hash = new byte[dig.getDigestSize()];
            dig.doFinal(hash, 0);
            byte[] oldHash = new byte[dig.getDigestSize()];
            Streams.readFully(cIn, oldHash);
            if (!Arrays.constantTimeAreEqual(hash, oldHash)) {
                this.table.clear();
                throw new IOException("KeyStore integrity check failed.");
            }
        }

        @Override
        public void engineStore(OutputStream stream, char[] password) throws IOException {
            DataOutputStream dOut = new DataOutputStream(stream);
            byte[] salt = new byte[20];
            int iterationCount = 1024 + (this.random.nextInt() & 0x3FF);
            this.random.nextBytes(salt);
            dOut.writeInt(2);
            dOut.writeInt(20);
            dOut.write(salt);
            dOut.writeInt(iterationCount);
            Cipher cipher = this.makePBECipher(JDKKeyStore.STORE_CIPHER, 1, password, salt, iterationCount);
            CipherOutputStream cOut = new CipherOutputStream(dOut, cipher);
            DigestOutputStream dgOut = new DigestOutputStream(new SHA1Digest());
            this.saveStore(new TeeOutputStream(cOut, dgOut));
            byte[] dig = dgOut.getDigest();
            cOut.write(dig);
            cOut.close();
        }
    }

    private class a {
        int a;
        String b;
        Object c;
        Certificate[] d;
        Date e = new Date();

        a(String alias, Certificate obj) {
            this.a = 1;
            this.b = alias;
            this.c = obj;
            this.d = null;
        }

        a(String alias, byte[] obj, Certificate[] certChain) {
            this.a = 3;
            this.b = alias;
            this.c = obj;
            this.d = certChain;
        }

        a(String alias, Key key, char[] password, Certificate[] certChain) throws Exception {
            this.a = 4;
            this.b = alias;
            this.d = certChain;
            byte[] salt = new byte[20];
            JDKKeyStore.this.random.setSeed(System.currentTimeMillis());
            JDKKeyStore.this.random.nextBytes(salt);
            int iterationCount = 1024 + (JDKKeyStore.this.random.nextInt() & 0x3FF);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DataOutputStream dOut = new DataOutputStream(bOut);
            dOut.writeInt(20);
            dOut.write(salt);
            dOut.writeInt(iterationCount);
            Cipher cipher = JDKKeyStore.this.makePBECipher(JDKKeyStore.KEY_CIPHER, 1, password, salt, iterationCount);
            CipherOutputStream cOut = new CipherOutputStream(dOut, cipher);
            dOut = new DataOutputStream(cOut);
            JDKKeyStore.this.encodeKey(key, dOut);
            dOut.close();
            this.c = bOut.toByteArray();
        }

        a(String alias, Date date, int type, Object obj) {
            this.b = alias;
            this.e = date;
            this.a = type;
            this.c = obj;
        }

        a(String alias, Date date, int type, Object obj, Certificate[] certChain) {
            this.b = alias;
            this.e = date;
            this.a = type;
            this.c = obj;
            this.d = certChain;
        }

        int a() {
            return this.a;
        }

        String b() {
            return this.b;
        }

        Object c() {
            return this.c;
        }

        Object a(char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            if ((password == null || password.length == 0) && this.c instanceof Key) {
                return this.c;
            }
            if (this.a == 4) {
                ByteArrayInputStream bIn = new ByteArrayInputStream((byte[])this.c);
                DataInputStream dIn = new DataInputStream(bIn);
                try {
                    byte[] salt = new byte[dIn.readInt()];
                    dIn.readFully(salt);
                    int iterationCount = dIn.readInt();
                    Cipher cipher = JDKKeyStore.this.makePBECipher(JDKKeyStore.KEY_CIPHER, 2, password, salt, iterationCount);
                    CipherInputStream cIn = new CipherInputStream(dIn, cipher);
                    try {
                        return JDKKeyStore.this.decodeKey(new DataInputStream(cIn));
                    }
                    catch (Exception exception) {
                        Key k2;
                        bIn = new ByteArrayInputStream((byte[])this.c);
                        dIn = new DataInputStream(bIn);
                        salt = new byte[dIn.readInt()];
                        dIn.readFully(salt);
                        iterationCount = dIn.readInt();
                        cipher = JDKKeyStore.this.makePBECipher("BrokenPBEWithSHAAnd3-KeyTripleDES-CBC", 2, password, salt, iterationCount);
                        cIn = new CipherInputStream(dIn, cipher);
                        try {
                            k2 = JDKKeyStore.this.decodeKey(new DataInputStream(cIn));
                        }
                        catch (Exception exception2) {
                            bIn = new ByteArrayInputStream((byte[])this.c);
                            dIn = new DataInputStream(bIn);
                            salt = new byte[dIn.readInt()];
                            dIn.readFully(salt);
                            iterationCount = dIn.readInt();
                            cipher = JDKKeyStore.this.makePBECipher("OldPBEWithSHAAnd3-KeyTripleDES-CBC", 2, password, salt, iterationCount);
                            cIn = new CipherInputStream(dIn, cipher);
                            k2 = JDKKeyStore.this.decodeKey(new DataInputStream(cIn));
                        }
                        if (k2 != null) {
                            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                            DataOutputStream dOut = new DataOutputStream(bOut);
                            dOut.writeInt(salt.length);
                            dOut.write(salt);
                            dOut.writeInt(iterationCount);
                            Cipher out = JDKKeyStore.this.makePBECipher(JDKKeyStore.KEY_CIPHER, 1, password, salt, iterationCount);
                            CipherOutputStream cOut = new CipherOutputStream(dOut, out);
                            dOut = new DataOutputStream(cOut);
                            JDKKeyStore.this.encodeKey(k2, dOut);
                            dOut.close();
                            this.c = bOut.toByteArray();
                            return k2;
                        }
                        throw new UnrecoverableKeyException("no match");
                    }
                }
                catch (Exception exception) {
                    throw new UnrecoverableKeyException("no match");
                }
            }
            throw new RuntimeException("forget something!");
        }

        Certificate[] d() {
            return this.d;
        }

        Date e() {
            return this.e;
        }
    }
}

