/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.ResponderID;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.ocsp.OCSPException;
import com.timevale.tgtext.bouncycastle.ocsp.a;
import java.security.MessageDigest;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;

public class RespID {
    ResponderID id;

    public RespID(ResponderID id) {
        this.id = id;
    }

    public RespID(X500Principal name) {
        this.id = new ResponderID(X500Name.getInstance(name.getEncoded()));
    }

    public RespID(PublicKey key) throws OCSPException {
        try {
            MessageDigest digest = a.a("SHA1", null);
            ASN1InputStream aIn = new ASN1InputStream(key.getEncoded());
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(aIn.readObject());
            digest.update(info.getPublicKeyData().getBytes());
            DEROctetString keyHash = new DEROctetString(digest.digest());
            this.id = new ResponderID(keyHash);
            return;
        }
        catch (Exception e2) {
            throw new OCSPException("problem creating ID: " + e2, e2);
        }
    }

    public ResponderID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof RespID)) {
            return false;
        }
        RespID obj = (RespID)o2;
        return this.id.equals(obj.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

