/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.RecipientEncryptedKey;
import com.timevale.tgtext.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.cms.CMSAlgorithm;
import com.timevale.tgtext.bouncycastle.cms.CMSEnvelopedGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.KeyAgreeRecipientInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.jcajce.a;
import com.timevale.tgtext.bouncycastle.cms.jcajce.b;
import com.timevale.tgtext.bouncycastle.cms.jcajce.c;
import com.timevale.tgtext.bouncycastle.cms.jcajce.d;
import com.timevale.tgtext.bouncycastle.cms.jcajce.e;
import com.timevale.tgtext.bouncycastle.jce.spec.MQVPrivateKeySpec;
import com.timevale.tgtext.bouncycastle.jce.spec.MQVPublicKeySpec;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;

public class JceKeyAgreeRecipientInfoGenerator
extends KeyAgreeRecipientInfoGenerator {
    private List recipientIDs = new ArrayList();
    private List recipientKeys = new ArrayList();
    private PublicKey senderPublicKey;
    private PrivateKey senderPrivateKey;
    private c helper = new c(new b());
    private SecureRandom random;
    private KeyPair ephemeralKP;

    public JceKeyAgreeRecipientInfoGenerator(ASN1ObjectIdentifier keyAgreementOID, PrivateKey senderPrivateKey, PublicKey senderPublicKey, ASN1ObjectIdentifier keyEncryptionOID) {
        super(keyAgreementOID, SubjectPublicKeyInfo.getInstance(senderPublicKey.getEncoded()), keyEncryptionOID);
        this.senderPublicKey = senderPublicKey;
        this.senderPrivateKey = senderPrivateKey;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(Provider provider) {
        this.helper = new c(new e(provider));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(String providerName) {
        this.helper = new c(new d(providerName));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(X509Certificate recipientCert) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(a.b(recipientCert)));
        this.recipientKeys.add(recipientCert.getPublicKey());
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(byte[] subjectKeyID, PublicKey publicKey) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(new RecipientKeyIdentifier(subjectKeyID)));
        this.recipientKeys.add(publicKey);
        return this;
    }

    @Override
    public ASN1Sequence generateRecipientEncryptedKeys(AlgorithmIdentifier keyAgreeAlgorithm, AlgorithmIdentifier keyEncryptionAlgorithm, GenericKey contentEncryptionKey) throws CMSException {
        this.init(keyAgreeAlgorithm.getAlgorithm());
        PrivateKey senderPrivateKey = this.senderPrivateKey;
        ASN1ObjectIdentifier keyAgreementOID = keyAgreeAlgorithm.getAlgorithm();
        if (keyAgreementOID.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            senderPrivateKey = new MQVPrivateKeySpec(senderPrivateKey, this.ephemeralKP.getPrivate(), this.ephemeralKP.getPublic());
        }
        ASN1EncodableVector recipientEncryptedKeys = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.recipientIDs.size(); ++i2) {
            PublicKey recipientPublicKey = (PublicKey)this.recipientKeys.get(i2);
            KeyAgreeRecipientIdentifier karId = (KeyAgreeRecipientIdentifier)this.recipientIDs.get(i2);
            if (keyAgreementOID.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
                recipientPublicKey = new MQVPublicKeySpec(recipientPublicKey, recipientPublicKey);
            }
            try {
                KeyAgreement keyAgreement = this.helper.e(keyAgreementOID);
                keyAgreement.init((Key)senderPrivateKey, this.random);
                keyAgreement.doPhase(recipientPublicKey, true);
                SecretKey keyEncryptionKey = keyAgreement.generateSecret(keyEncryptionAlgorithm.getAlgorithm().getId());
                Cipher keyEncryptionCipher = this.helper.b(keyEncryptionAlgorithm.getAlgorithm());
                keyEncryptionCipher.init(3, (Key)keyEncryptionKey, this.random);
                byte[] encryptedKeyBytes = keyEncryptionCipher.wrap(this.helper.a(contentEncryptionKey));
                DEROctetString encryptedKey = new DEROctetString(encryptedKeyBytes);
                recipientEncryptedKeys.add(new RecipientEncryptedKey(karId, encryptedKey));
                continue;
            }
            catch (GeneralSecurityException e2) {
                throw new CMSException("cannot perform agreement step: " + e2.getMessage(), e2);
            }
        }
        return new DERSequence(recipientEncryptedKeys);
    }

    @Override
    protected ASN1Encodable getUserKeyingMaterial(AlgorithmIdentifier keyAgreeAlg) throws CMSException {
        this.init(keyAgreeAlg.getAlgorithm());
        if (this.ephemeralKP != null) {
            return new MQVuserKeyingMaterial(this.createOriginatorPublicKey(SubjectPublicKeyInfo.getInstance(this.ephemeralKP.getPublic().getEncoded())), null);
        }
        return null;
    }

    private void init(ASN1ObjectIdentifier keyAgreementOID) throws CMSException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (keyAgreementOID.equals(CMSAlgorithm.ECMQV_SHA1KDF) && this.ephemeralKP == null) {
            try {
                ECParameterSpec ecParamSpec = ((ECPublicKey)this.senderPublicKey).getParams();
                KeyPairGenerator ephemKPG = this.helper.h(keyAgreementOID);
                ephemKPG.initialize(ecParamSpec, this.random);
                this.ephemeralKP = ephemKPG.generateKeyPair();
                return;
            }
            catch (InvalidAlgorithmParameterException e2) {
                throw new CMSException("cannot determine MQV ephemeral key pair parameters from public key: " + e2);
            }
        }
    }
}

