/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.graphics;

import com.timevale.seal.graphics.ImageType;
import esign.utils.exception.ag;
import esign.utils.exception.aj;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsOutput {
    private BufferedImage image;
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphicsOutput.class);

    public GraphicsOutput(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage image() {
        return this.image;
    }

    public byte[] imageData(ImageType type) throws aj {
        return this.innerImage(type).toByteArray();
    }

    public InputStream imageStream(ImageType type) throws aj {
        ByteArrayOutputStream baos = this.innerImage(type);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public void imageFile(ImageType type, String file) throws aj {
        try {
            ImageIO.write((RenderedImage)this.image, type.disc(), new File(file));
            return;
        }
        catch (IOException iOException) {
            LOGGER.error("unsupport image type. type:{}");
            throw ag.aw.c();
        }
    }

    private ByteArrayOutputStream innerImage(ImageType type) throws aj {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.image, type.disc(), baos);
        }
        catch (IOException iOException) {
            LOGGER.error("unsupport image type. type:{}");
            throw ag.aw.c();
        }
        return baos;
    }
}

