/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.eac;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.timevale.tgtext.bouncycastle.asn1.eac.UnsignedInteger;
import java.math.BigInteger;
import java.util.Enumeration;

public class ECDSAPublicKey
extends PublicKeyDataObject {
    private ASN1ObjectIdentifier usage;
    private BigInteger primeModulusP;
    private BigInteger firstCoefA;
    private BigInteger secondCoefB;
    private byte[] basePointG;
    private BigInteger orderOfBasePointR;
    private byte[] publicPointY;
    private BigInteger cofactorF;
    private int options;
    private static final int P = 1;
    private static final int A = 2;
    private static final int B = 4;
    private static final int G = 8;
    private static final int R = 16;
    private static final int Y = 32;
    private static final int F = 64;

    ECDSAPublicKey(ASN1Sequence seq) throws IllegalArgumentException {
        Enumeration en2 = seq.getObjects();
        this.usage = ASN1ObjectIdentifier.getInstance(en2.nextElement());
        this.options = 0;
        block9: while (en2.hasMoreElements()) {
            Object obj = en2.nextElement();
            if (obj instanceof ASN1TaggedObject) {
                ASN1TaggedObject to = (ASN1TaggedObject)obj;
                switch (to.getTagNo()) {
                    case 1: {
                        this.setPrimeModulusP(UnsignedInteger.getInstance(to).getValue());
                        continue block9;
                    }
                    case 2: {
                        this.setFirstCoefA(UnsignedInteger.getInstance(to).getValue());
                        continue block9;
                    }
                    case 3: {
                        this.setSecondCoefB(UnsignedInteger.getInstance(to).getValue());
                        continue block9;
                    }
                    case 4: {
                        this.setBasePointG(ASN1OctetString.getInstance(to, false));
                        continue block9;
                    }
                    case 5: {
                        this.setOrderOfBasePointR(UnsignedInteger.getInstance(to).getValue());
                        continue block9;
                    }
                    case 6: {
                        this.setPublicPointY(ASN1OctetString.getInstance(to, false));
                        continue block9;
                    }
                    case 7: {
                        this.setCofactorF(UnsignedInteger.getInstance(to).getValue());
                        continue block9;
                    }
                }
                this.options = 0;
                throw new IllegalArgumentException("Unknown Object Identifier!");
            }
            throw new IllegalArgumentException("Unknown Object Identifier!");
        }
        if (this.options != 32 && this.options != 127) {
            throw new IllegalArgumentException("All options must be either present or absent!");
        }
    }

    public ECDSAPublicKey(ASN1ObjectIdentifier usage, byte[] ppY) throws IllegalArgumentException {
        this.usage = usage;
        this.setPublicPointY(new DEROctetString(ppY));
    }

    public ECDSAPublicKey(ASN1ObjectIdentifier usage, BigInteger p2, BigInteger a2, BigInteger b2, byte[] basePoint, BigInteger order, byte[] publicPoint, int cofactor) {
        this.usage = usage;
        this.setPrimeModulusP(p2);
        this.setFirstCoefA(a2);
        this.setSecondCoefB(b2);
        this.setBasePointG(new DEROctetString(basePoint));
        this.setOrderOfBasePointR(order);
        this.setPublicPointY(new DEROctetString(publicPoint));
        this.setCofactorF(BigInteger.valueOf(cofactor));
    }

    @Override
    public ASN1ObjectIdentifier getUsage() {
        return this.usage;
    }

    public byte[] getBasePointG() {
        if ((this.options & 8) != 0) {
            return this.basePointG;
        }
        return null;
    }

    private void setBasePointG(ASN1OctetString basePointG) throws IllegalArgumentException {
        if ((this.options & 8) == 0) {
            this.options |= 8;
            this.basePointG = basePointG.getOctets();
            return;
        }
        throw new IllegalArgumentException("Base Point G already set");
    }

    public BigInteger getCofactorF() {
        if ((this.options & 0x40) != 0) {
            return this.cofactorF;
        }
        return null;
    }

    private void setCofactorF(BigInteger cofactorF) throws IllegalArgumentException {
        if ((this.options & 0x40) == 0) {
            this.options |= 0x40;
            this.cofactorF = cofactorF;
            return;
        }
        throw new IllegalArgumentException("Cofactor F already set");
    }

    public BigInteger getFirstCoefA() {
        if ((this.options & 2) != 0) {
            return this.firstCoefA;
        }
        return null;
    }

    private void setFirstCoefA(BigInteger firstCoefA) throws IllegalArgumentException {
        if ((this.options & 2) == 0) {
            this.options |= 2;
            this.firstCoefA = firstCoefA;
            return;
        }
        throw new IllegalArgumentException("First Coef A already set");
    }

    public BigInteger getOrderOfBasePointR() {
        if ((this.options & 0x10) != 0) {
            return this.orderOfBasePointR;
        }
        return null;
    }

    private void setOrderOfBasePointR(BigInteger orderOfBasePointR) throws IllegalArgumentException {
        if ((this.options & 0x10) == 0) {
            this.options |= 0x10;
            this.orderOfBasePointR = orderOfBasePointR;
            return;
        }
        throw new IllegalArgumentException("Order of base point R already set");
    }

    public BigInteger getPrimeModulusP() {
        if ((this.options & 1) != 0) {
            return this.primeModulusP;
        }
        return null;
    }

    private void setPrimeModulusP(BigInteger primeModulusP) {
        if ((this.options & 1) == 0) {
            this.options |= 1;
            this.primeModulusP = primeModulusP;
            return;
        }
        throw new IllegalArgumentException("Prime Modulus P already set");
    }

    public byte[] getPublicPointY() {
        if ((this.options & 0x20) != 0) {
            return this.publicPointY;
        }
        return null;
    }

    private void setPublicPointY(ASN1OctetString publicPointY) throws IllegalArgumentException {
        if ((this.options & 0x20) == 0) {
            this.options |= 0x20;
            this.publicPointY = publicPointY.getOctets();
            return;
        }
        throw new IllegalArgumentException("Public Point Y already set");
    }

    public BigInteger getSecondCoefB() {
        if ((this.options & 4) != 0) {
            return this.secondCoefB;
        }
        return null;
    }

    private void setSecondCoefB(BigInteger secondCoefB) throws IllegalArgumentException {
        if ((this.options & 4) == 0) {
            this.options |= 4;
            this.secondCoefB = secondCoefB;
            return;
        }
        throw new IllegalArgumentException("Second Coef B already set");
    }

    public boolean hasParameters() {
        return this.primeModulusP != null;
    }

    public ASN1EncodableVector getASN1EncodableVector(ASN1ObjectIdentifier oid, boolean publicPointOnly) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(oid);
        if (!publicPointOnly) {
            v2.add(new UnsignedInteger(1, this.getPrimeModulusP()));
            v2.add(new UnsignedInteger(2, this.getFirstCoefA()));
            v2.add(new UnsignedInteger(3, this.getSecondCoefB()));
            v2.add(new DERTaggedObject(false, 4, new DEROctetString(this.getBasePointG())));
            v2.add(new UnsignedInteger(5, this.getOrderOfBasePointR()));
        }
        v2.add(new DERTaggedObject(false, 6, new DEROctetString(this.getPublicPointY())));
        if (!publicPointOnly) {
            v2.add(new UnsignedInteger(7, this.getCofactorF()));
        }
        return v2;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.getASN1EncodableVector(this.usage, false));
    }
}

