/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1GeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CMPCertificate;
import com.timevale.tgtext.bouncycastle.asn1.cmp.InfoTypeAndValue;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIBody;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIFreeText;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIHeader;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIMessage;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.cmp.CMPException;
import com.timevale.tgtext.bouncycastle.cert.cmp.ProtectedPKIMessage;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import com.timevale.tgtext.bouncycastle.operator.MacCalculator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProtectedPKIMessageBuilder {
    private PKIHeaderBuilder hdrBuilder;
    private PKIBody body;
    private List generalInfos = new ArrayList();
    private List extraCerts = new ArrayList();

    public ProtectedPKIMessageBuilder(GeneralName sender, GeneralName recipient) {
        this(2, sender, recipient);
    }

    public ProtectedPKIMessageBuilder(int pvno, GeneralName sender, GeneralName recipient) {
        this.hdrBuilder = new PKIHeaderBuilder(pvno, sender, recipient);
    }

    public ProtectedPKIMessageBuilder setTransactionID(byte[] tid) {
        this.hdrBuilder.setTransactionID(tid);
        return this;
    }

    public ProtectedPKIMessageBuilder setFreeText(PKIFreeText freeText) {
        this.hdrBuilder.setFreeText(freeText);
        return this;
    }

    public ProtectedPKIMessageBuilder addGeneralInfo(InfoTypeAndValue genInfo) {
        this.generalInfos.add(genInfo);
        return this;
    }

    public ProtectedPKIMessageBuilder setMessageTime(Date time) {
        this.hdrBuilder.setMessageTime(new ASN1GeneralizedTime(time));
        return this;
    }

    public ProtectedPKIMessageBuilder setRecipKID(byte[] kid) {
        this.hdrBuilder.setRecipKID(kid);
        return this;
    }

    public ProtectedPKIMessageBuilder setRecipNonce(byte[] nonce) {
        this.hdrBuilder.setRecipNonce(nonce);
        return this;
    }

    public ProtectedPKIMessageBuilder setSenderKID(byte[] kid) {
        this.hdrBuilder.setSenderKID(kid);
        return this;
    }

    public ProtectedPKIMessageBuilder setSenderNonce(byte[] nonce) {
        this.hdrBuilder.setSenderNonce(nonce);
        return this;
    }

    public ProtectedPKIMessageBuilder setBody(PKIBody body) {
        this.body = body;
        return this;
    }

    public ProtectedPKIMessageBuilder addCMPCertificate(X509CertificateHolder extraCert) {
        this.extraCerts.add(extraCert);
        return this;
    }

    public ProtectedPKIMessage build(MacCalculator macCalculator) throws CMPException {
        this.finaliseHeader(macCalculator.getAlgorithmIdentifier());
        PKIHeader header = this.hdrBuilder.build();
        try {
            DERBitString protection = new DERBitString(this.calculateMac(macCalculator, header, this.body));
            return this.finaliseMessage(header, protection);
        }
        catch (IOException e2) {
            throw new CMPException("unable to encode MAC input: " + e2.getMessage(), e2);
        }
    }

    public ProtectedPKIMessage build(ContentSigner signer) throws CMPException {
        this.finaliseHeader(signer.getAlgorithmIdentifier());
        PKIHeader header = this.hdrBuilder.build();
        try {
            DERBitString protection = new DERBitString(this.calculateSignature(signer, header, this.body));
            return this.finaliseMessage(header, protection);
        }
        catch (IOException e2) {
            throw new CMPException("unable to encode signature input: " + e2.getMessage(), e2);
        }
    }

    private void finaliseHeader(AlgorithmIdentifier algorithmIdentifier) {
        this.hdrBuilder.setProtectionAlg(algorithmIdentifier);
        if (!this.generalInfos.isEmpty()) {
            InfoTypeAndValue[] genInfos = new InfoTypeAndValue[this.generalInfos.size()];
            this.hdrBuilder.setGeneralInfo(this.generalInfos.toArray(genInfos));
        }
    }

    private ProtectedPKIMessage finaliseMessage(PKIHeader header, DERBitString protection) {
        if (!this.extraCerts.isEmpty()) {
            CMPCertificate[] cmpCerts = new CMPCertificate[this.extraCerts.size()];
            for (int i2 = 0; i2 != cmpCerts.length; ++i2) {
                cmpCerts[i2] = new CMPCertificate(((X509CertificateHolder)this.extraCerts.get(i2)).toASN1Structure());
            }
            return new ProtectedPKIMessage(new PKIMessage(header, this.body, protection, cmpCerts));
        }
        return new ProtectedPKIMessage(new PKIMessage(header, this.body, protection));
    }

    private byte[] calculateSignature(ContentSigner signer, PKIHeader header, PKIBody body) throws IOException {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(header);
        v2.add(body);
        OutputStream sOut = signer.getOutputStream();
        sOut.write(new DERSequence(v2).getEncoded("DER"));
        sOut.close();
        return signer.getSignature();
    }

    private byte[] calculateMac(MacCalculator macCalculator, PKIHeader header, PKIBody body) throws IOException {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(header);
        v2.add(body);
        OutputStream sOut = macCalculator.getOutputStream();
        sOut.write(new DERSequence(v2).getEncoded("DER"));
        sOut.close();
        return macCalculator.getMac();
    }
}

