/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.tgtext.bouncycastle.crypto.engines.IndexGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUEncryptionParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUEncryptionPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUEncryptionPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.DenseTernaryPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Polynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.ProductFormPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.SparseTernaryPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.TernaryPolynomial;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class NTRUEngine
implements AsymmetricBlockCipher {
    private boolean forEncryption;
    private NTRUEncryptionParameters params;
    private NTRUEncryptionPublicKeyParameters pubKey;
    private NTRUEncryptionPrivateKeyParameters privKey;
    private SecureRandom random;

    @Override
    public void init(boolean forEncryption, CipherParameters parameters) {
        this.forEncryption = forEncryption;
        if (forEncryption) {
            if (parameters instanceof ParametersWithRandom) {
                ParametersWithRandom p2 = (ParametersWithRandom)parameters;
                this.random = p2.getRandom();
                this.pubKey = (NTRUEncryptionPublicKeyParameters)p2.getParameters();
            } else {
                this.random = new SecureRandom();
                this.pubKey = (NTRUEncryptionPublicKeyParameters)parameters;
            }
            this.params = this.pubKey.getParameters();
            return;
        }
        this.privKey = (NTRUEncryptionPrivateKeyParameters)parameters;
        this.params = this.privKey.getParameters();
    }

    @Override
    public int getInputBlockSize() {
        return this.params.maxMsgLenBytes;
    }

    @Override
    public int getOutputBlockSize() {
        return (this.params.N * this.log2(this.params.q) + 7) / 8;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int len) throws InvalidCipherTextException {
        byte[] tmp = new byte[len];
        System.arraycopy(in, inOff, tmp, 0, len);
        if (this.forEncryption) {
            return this.encrypt(tmp, this.pubKey);
        }
        return this.decrypt(tmp, this.privKey);
    }

    private byte[] encrypt(byte[] m2, NTRUEncryptionPublicKeyParameters pubKey) {
        IntegerPolynomial R;
        IntegerPolynomial mTrin;
        IntegerPolynomial pub = pubKey.h;
        int N = this.params.N;
        int q2 = this.params.q;
        int maxLenBytes = this.params.maxMsgLenBytes;
        int db2 = this.params.db;
        int bufferLenBits = this.params.bufferLenBits;
        int dm0 = this.params.dm0;
        int pkLen = this.params.pkLen;
        int minCallsMask = this.params.minCallsMask;
        boolean hashSeed = this.params.hashSeed;
        byte[] oid = this.params.oid;
        int l2 = m2.length;
        if (maxLenBytes > 255) {
            throw new IllegalArgumentException("llen values bigger than 1 are not supported");
        }
        if (l2 > maxLenBytes) {
            throw new DataLengthException("Message too long: " + l2 + ">" + maxLenBytes);
        }
        do {
            byte[] b2 = new byte[db2 / 8];
            this.random.nextBytes(b2);
            byte[] p0 = new byte[maxLenBytes + 1 - l2];
            byte[] M = new byte[bufferLenBits / 8];
            System.arraycopy(b2, 0, M, 0, b2.length);
            M[b2.length] = (byte)l2;
            System.arraycopy(m2, 0, M, b2.length + 1, m2.length);
            System.arraycopy(p0, 0, M, b2.length + 1 + m2.length, p0.length);
            mTrin = IntegerPolynomial.fromBinary3Sves(M, N);
            byte[] bh2 = pub.toBinary(q2);
            byte[] hTrunc = this.copyOf(bh2, pkLen / 8);
            byte[] sData = this.buildSData(oid, m2, l2, b2, hTrunc);
            Polynomial r2 = this.generateBlindingPoly(sData, M);
            R = r2.mult(pub, q2);
            IntegerPolynomial R4 = (IntegerPolynomial)R.clone();
            R4.modPositive(4);
            byte[] oR4 = R4.toBinary(4);
            IntegerPolynomial mask = this.MGF(oR4, N, minCallsMask, hashSeed);
            mTrin.add(mask);
            mTrin.mod3();
        } while (mTrin.count(-1) < dm0 || mTrin.count(0) < dm0 || mTrin.count(1) < dm0);
        R.add(mTrin, q2);
        R.ensurePositive(q2);
        return R.toBinary(q2);
    }

    private byte[] buildSData(byte[] oid, byte[] m2, int l2, byte[] b2, byte[] hTrunc) {
        byte[] sData = new byte[oid.length + l2 + b2.length + hTrunc.length];
        System.arraycopy(oid, 0, sData, 0, oid.length);
        System.arraycopy(m2, 0, sData, oid.length, m2.length);
        System.arraycopy(b2, 0, sData, oid.length + m2.length, b2.length);
        System.arraycopy(hTrunc, 0, sData, oid.length + m2.length + b2.length, hTrunc.length);
        return sData;
    }

    protected IntegerPolynomial encrypt(IntegerPolynomial m2, TernaryPolynomial r2, IntegerPolynomial pubKey) {
        IntegerPolynomial e2 = r2.mult(pubKey, this.params.q);
        e2.add(m2, this.params.q);
        e2.ensurePositive(this.params.q);
        return e2;
    }

    private Polynomial generateBlindingPoly(byte[] seed, byte[] M) {
        IndexGenerator ig = new IndexGenerator(seed, this.params);
        if (this.params.polyType == 1) {
            SparseTernaryPolynomial r1 = new SparseTernaryPolynomial(this.generateBlindingCoeffs(ig, this.params.dr1));
            SparseTernaryPolynomial r2 = new SparseTernaryPolynomial(this.generateBlindingCoeffs(ig, this.params.dr2));
            SparseTernaryPolynomial r3 = new SparseTernaryPolynomial(this.generateBlindingCoeffs(ig, this.params.dr3));
            return new ProductFormPolynomial(r1, r2, r3);
        }
        int dr2 = this.params.dr;
        boolean sparse = this.params.sparse;
        int[] r2 = this.generateBlindingCoeffs(ig, dr2);
        if (sparse) {
            return new SparseTernaryPolynomial(r2);
        }
        return new DenseTernaryPolynomial(r2);
    }

    private int[] generateBlindingCoeffs(IndexGenerator ig, int dr2) {
        int N = this.params.N;
        int[] r2 = new int[N];
        for (int coeff = -1; coeff <= 1; coeff += 2) {
            int t2 = 0;
            while (t2 < dr2) {
                int i2 = ig.nextIndex();
                if (r2[i2] != 0) continue;
                r2[i2] = coeff;
                ++t2;
            }
        }
        return r2;
    }

    private IntegerPolynomial MGF(byte[] seed, int N, int minCallsR, boolean hashSeed) {
        int counter;
        Digest hashAlg = this.params.hashAlg;
        int hashLen = hashAlg.getDigestSize();
        byte[] buf = new byte[minCallsR * hashLen];
        byte[] Z = hashSeed ? this.calcHash(hashAlg, seed) : seed;
        for (counter = 0; counter < minCallsR; ++counter) {
            hashAlg.update(Z, 0, Z.length);
            this.putInt(hashAlg, counter);
            byte[] hash = this.calcHash(hashAlg);
            System.arraycopy(hash, 0, buf, counter * hashLen, hashLen);
        }
        IntegerPolynomial i2 = new IntegerPolynomial(N);
        while (true) {
            int cur = 0;
            for (int index = 0; index != buf.length; ++index) {
                int O = buf[index] & 0xFF;
                if (O >= 243) continue;
                for (int terIdx = 0; terIdx < 4; ++terIdx) {
                    int rem3 = O % 3;
                    i2.coeffs[cur] = rem3 - 1;
                    if (++cur == N) {
                        return i2;
                    }
                    O = (O - rem3) / 3;
                }
                i2.coeffs[cur] = O - 1;
                if (++cur != N) continue;
                return i2;
            }
            if (cur >= N) {
                return i2;
            }
            hashAlg.update(Z, 0, Z.length);
            this.putInt(hashAlg, counter);
            byte[] hash = this.calcHash(hashAlg);
            buf = hash;
            ++counter;
        }
    }

    private void putInt(Digest hashAlg, int counter) {
        hashAlg.update(counter >> 24);
        hashAlg.update((byte)(counter >> 16));
        hashAlg.update((byte)(counter >> 8));
        hashAlg.update((byte)counter);
    }

    private byte[] calcHash(Digest hashAlg) {
        byte[] tmp = new byte[hashAlg.getDigestSize()];
        hashAlg.doFinal(tmp, 0);
        return tmp;
    }

    private byte[] calcHash(Digest hashAlg, byte[] input) {
        byte[] tmp = new byte[hashAlg.getDigestSize()];
        hashAlg.update(input, 0, input.length);
        hashAlg.doFinal(tmp, 0);
        return tmp;
    }

    private byte[] decrypt(byte[] data, NTRUEncryptionPrivateKeyParameters privKey) throws InvalidCipherTextException {
        Polynomial priv_t = privKey.t;
        IntegerPolynomial priv_fp = privKey.fp;
        IntegerPolynomial pub = privKey.h;
        int N = this.params.N;
        int q2 = this.params.q;
        int db2 = this.params.db;
        int maxMsgLenBytes = this.params.maxMsgLenBytes;
        int dm0 = this.params.dm0;
        int pkLen = this.params.pkLen;
        int minCallsMask = this.params.minCallsMask;
        boolean hashSeed = this.params.hashSeed;
        byte[] oid = this.params.oid;
        if (maxMsgLenBytes > 255) {
            throw new DataLengthException("maxMsgLenBytes values bigger than 255 are not supported");
        }
        int bLen = db2 / 8;
        IntegerPolynomial e2 = IntegerPolynomial.fromBinary(data, N, q2);
        IntegerPolynomial ci2 = this.decrypt(e2, priv_t, priv_fp);
        if (ci2.count(-1) < dm0) {
            throw new InvalidCipherTextException("Less than dm0 coefficients equal -1");
        }
        if (ci2.count(0) < dm0) {
            throw new InvalidCipherTextException("Less than dm0 coefficients equal 0");
        }
        if (ci2.count(1) < dm0) {
            throw new InvalidCipherTextException("Less than dm0 coefficients equal 1");
        }
        IntegerPolynomial cR = (IntegerPolynomial)e2.clone();
        cR.sub(ci2);
        cR.modPositive(q2);
        IntegerPolynomial cR4 = (IntegerPolynomial)cR.clone();
        cR4.modPositive(4);
        byte[] coR4 = cR4.toBinary(4);
        IntegerPolynomial mask = this.MGF(coR4, N, minCallsMask, hashSeed);
        IntegerPolynomial cMTrin = ci2;
        cMTrin.sub(mask);
        cMTrin.mod3();
        byte[] cM = cMTrin.toBinary3Sves();
        byte[] cb2 = new byte[bLen];
        System.arraycopy(cM, 0, cb2, 0, bLen);
        int cl2 = cM[bLen] & 0xFF;
        if (cl2 > maxMsgLenBytes) {
            throw new InvalidCipherTextException("Message too long: " + cl2 + ">" + maxMsgLenBytes);
        }
        byte[] cm2 = new byte[cl2];
        System.arraycopy(cM, bLen + 1, cm2, 0, cl2);
        byte[] p0 = new byte[cM.length - (bLen + 1 + cl2)];
        System.arraycopy(cM, bLen + 1 + cl2, p0, 0, p0.length);
        if (!Arrays.areEqual(p0, new byte[p0.length])) {
            throw new InvalidCipherTextException("The message is not followed by zeroes");
        }
        byte[] bh2 = pub.toBinary(q2);
        byte[] hTrunc = this.copyOf(bh2, pkLen / 8);
        byte[] sData = this.buildSData(oid, cm2, cl2, cb2, hTrunc);
        Polynomial cr2 = this.generateBlindingPoly(sData, cm2);
        IntegerPolynomial cRPrime = cr2.mult(pub);
        cRPrime.modPositive(q2);
        if (!cRPrime.equals(cR)) {
            throw new InvalidCipherTextException("Invalid message encoding");
        }
        return cm2;
    }

    protected IntegerPolynomial decrypt(IntegerPolynomial e2, Polynomial priv_t, IntegerPolynomial priv_fp) {
        IntegerPolynomial a2;
        if (this.params.fastFp) {
            a2 = priv_t.mult(e2, this.params.q);
            a2.mult(3);
            a2.add(e2);
        } else {
            a2 = priv_t.mult(e2, this.params.q);
        }
        a2.center0(this.params.q);
        a2.mod3();
        IntegerPolynomial c2 = this.params.fastFp ? a2 : new DenseTernaryPolynomial(a2).mult(priv_fp, 3);
        c2.center0(3);
        return c2;
    }

    private byte[] copyOf(byte[] src, int len) {
        byte[] tmp = new byte[len];
        System.arraycopy(src, 0, tmp, 0, len < src.length ? len : src.length);
        return tmp;
    }

    private int log2(int value) {
        if (value == 2048) {
            return 11;
        }
        throw new IllegalStateException("log2 not fully implemented");
    }
}

