/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.tls.TlsRuntimeException;

public class ByteQueue {
    private static final int INITBUFSIZE = 1024;
    private byte[] databuf = new byte[1024];
    private int skipped = 0;
    private int available = 0;

    public static final int nextTwoPow(int i2) {
        i2 |= i2 >> 1;
        i2 |= i2 >> 2;
        i2 |= i2 >> 4;
        i2 |= i2 >> 8;
        i2 |= i2 >> 16;
        return i2 + 1;
    }

    public void read(byte[] buf, int offset, int len, int skip) {
        if (this.available - skip < len) {
            throw new TlsRuntimeException("Not enough data to read");
        }
        if (buf.length - offset < len) {
            throw new TlsRuntimeException("Buffer size of " + buf.length + " is too small for a read of " + len + " bytes");
        }
        System.arraycopy(this.databuf, this.skipped + skip, buf, offset, len);
    }

    public void addData(byte[] data, int offset, int len) {
        if (this.skipped + this.available + len > this.databuf.length) {
            byte[] tmp = new byte[ByteQueue.nextTwoPow(data.length)];
            System.arraycopy(this.databuf, this.skipped, tmp, 0, this.available);
            this.skipped = 0;
            this.databuf = tmp;
        }
        System.arraycopy(data, offset, this.databuf, this.skipped + this.available, len);
        this.available += len;
    }

    public void removeData(int i2) {
        if (i2 > this.available) {
            throw new TlsRuntimeException("Cannot remove " + i2 + " bytes, only got " + this.available);
        }
        this.available -= i2;
        this.skipped += i2;
        if (this.skipped > this.databuf.length / 2) {
            System.arraycopy(this.databuf, this.skipped, this.databuf, 0, this.available);
            this.skipped = 0;
        }
    }

    public int size() {
        return this.available;
    }
}

