/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.BERSequenceGenerator;
import com.timevale.tgtext.bouncycastle.asn1.BERSet;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cms.EnvelopedData;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSEnvelopedGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.RecipientInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.d;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.KeyGenerator;

public class CMSEnvelopedDataStreamGenerator
extends CMSEnvelopedGenerator {
    private ASN1Set _unprotectedAttributes = null;
    private int _bufferSize;
    private boolean _berEncodeRecipientSet;

    public CMSEnvelopedDataStreamGenerator() {
    }

    public CMSEnvelopedDataStreamGenerator(SecureRandom rand) {
        super(rand);
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setBEREncodeRecipients(boolean berEncodeRecipientSet) {
        this._berEncodeRecipientSet = berEncodeRecipientSet;
    }

    private ASN1Integer getVersion() {
        if (this.originatorInfo != null || this._unprotectedAttributes != null) {
            return new ASN1Integer(2L);
        }
        return new ASN1Integer(0L);
    }

    private OutputStream open(OutputStream out, String encryptionOID, int keySize, Provider encProvider, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        this.convertOldRecipients(this.rand, provider);
        JceCMSContentEncryptorBuilder builder = keySize != -1 ? new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(encryptionOID), keySize) : new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(encryptionOID));
        builder.setProvider(encProvider);
        builder.setSecureRandom(this.rand);
        return this.doOpen(CMSObjectIdentifiers.data, out, builder.build());
    }

    private OutputStream doOpen(ASN1ObjectIdentifier dataType, OutputStream out, OutputEncryptor encryptor) throws IOException, CMSException {
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        GenericKey encKey = encryptor.getKey();
        for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
            recipientInfos.add(recipient.generate(encKey));
        }
        return this.open(dataType, out, recipientInfos, encryptor);
    }

    protected OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, ASN1EncodableVector recipientInfos, OutputEncryptor encryptor) throws IOException {
        BERSequenceGenerator cGen = new BERSequenceGenerator(out);
        cGen.addObject(CMSObjectIdentifiers.envelopedData);
        BERSequenceGenerator envGen = new BERSequenceGenerator(cGen.getRawOutputStream(), 0, true);
        envGen.addObject(this.getVersion());
        if (this.originatorInfo != null) {
            envGen.addObject(new DERTaggedObject(false, 0, this.originatorInfo));
        }
        if (this._berEncodeRecipientSet) {
            envGen.getRawOutputStream().write(new BERSet(recipientInfos).getEncoded());
        } else {
            envGen.getRawOutputStream().write(new DERSet(recipientInfos).getEncoded());
        }
        BERSequenceGenerator eiGen = new BERSequenceGenerator(envGen.getRawOutputStream());
        eiGen.addObject(dataType);
        AlgorithmIdentifier encAlgId = encryptor.getAlgorithmIdentifier();
        eiGen.getRawOutputStream().write(encAlgId.getEncoded());
        OutputStream octetStream = i.a(eiGen.getRawOutputStream(), 0, false, this._bufferSize);
        OutputStream cOut = encryptor.getOutputStream(octetStream);
        return new a(cOut, cGen, envGen, eiGen);
    }

    protected OutputStream open(OutputStream out, ASN1EncodableVector recipientInfos, OutputEncryptor encryptor) throws CMSException {
        try {
            BERSequenceGenerator cGen = new BERSequenceGenerator(out);
            cGen.addObject(CMSObjectIdentifiers.envelopedData);
            BERSequenceGenerator envGen = new BERSequenceGenerator(cGen.getRawOutputStream(), 0, true);
            ASN1Set recipients = this._berEncodeRecipientSet ? new BERSet(recipientInfos) : new DERSet(recipientInfos);
            envGen.addObject(new ASN1Integer(EnvelopedData.calculateVersion(this.originatorInfo, recipients, this._unprotectedAttributes)));
            if (this.originatorInfo != null) {
                envGen.addObject(new DERTaggedObject(false, 0, this.originatorInfo));
            }
            envGen.getRawOutputStream().write(recipients.getEncoded());
            BERSequenceGenerator eiGen = new BERSequenceGenerator(envGen.getRawOutputStream());
            eiGen.addObject(CMSObjectIdentifiers.data);
            AlgorithmIdentifier encAlgId = encryptor.getAlgorithmIdentifier();
            eiGen.getRawOutputStream().write(encAlgId.getEncoded());
            OutputStream octetStream = i.a(eiGen.getRawOutputStream(), 0, false, this._bufferSize);
            return new a(encryptor.getOutputStream(octetStream), cGen, envGen, eiGen);
        }
        catch (IOException e2) {
            throw new CMSException("exception decoding algorithm parameters.", e2);
        }
    }

    public OutputStream open(OutputStream out, String encryptionOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(out, encryptionOID, i.a(provider));
    }

    public OutputStream open(OutputStream out, String encryptionOID, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGen = d.a.a(encryptionOID, provider);
        keyGen.init(this.rand);
        return this.open(out, encryptionOID, -1, keyGen.getProvider(), provider);
    }

    public OutputStream open(OutputStream out, String encryptionOID, int keySize, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(out, encryptionOID, keySize, i.a(provider));
    }

    public OutputStream open(OutputStream out, String encryptionOID, int keySize, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGen = d.a.a(encryptionOID, provider);
        keyGen.init(keySize, this.rand);
        return this.open(out, encryptionOID, -1, keyGen.getProvider(), provider);
    }

    public OutputStream open(OutputStream out, OutputEncryptor encryptor) throws CMSException, IOException {
        return this.doOpen(new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()), out, encryptor);
    }

    public OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, OutputEncryptor encryptor) throws CMSException, IOException {
        return this.doOpen(dataType, out, encryptor);
    }

    private class a
    extends OutputStream {
        private OutputStream b;
        private BERSequenceGenerator c;
        private BERSequenceGenerator d;
        private BERSequenceGenerator e;

        public a(OutputStream out, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this.b = out;
            this.c = cGen;
            this.d = envGen;
            this.e = eiGen;
        }

        @Override
        public void write(int b2) throws IOException {
            this.b.write(b2);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.b.write(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.b.write(bytes);
        }

        @Override
        public void close() throws IOException {
            this.b.close();
            this.e.close();
            if (CMSEnvelopedDataStreamGenerator.this.unprotectedAttributeGenerator != null) {
                AttributeTable attrTable = CMSEnvelopedDataStreamGenerator.this.unprotectedAttributeGenerator.getAttributes(new HashMap());
                BERSet unprotectedAttrs = new BERSet(attrTable.toASN1EncodableVector());
                this.d.addObject(new DERTaggedObject(false, 1, unprotectedAttrs));
            }
            this.d.close();
            this.c.close();
        }
    }
}

