/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.BEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.SignedData;
import com.timevale.tgtext.bouncycastle.asn1.cms.SignerInfo;
import com.timevale.tgtext.bouncycastle.cms.CMSAbsentContent;
import com.timevale.tgtext.bouncycastle.cms.CMSAttributeTableGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSProcessable;
import com.timevale.tgtext.bouncycastle.cms.CMSProcessableByteArray;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedData;
import com.timevale.tgtext.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import com.timevale.tgtext.bouncycastle.cms.SignerInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.bouncycastle.cms.SimpleAttributeTableGenerator;
import com.timevale.tgtext.bouncycastle.cms.h;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID) throws IllegalArgumentException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID) throws IllegalArgumentException {
        this.doAddSigner(key, cert, encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(), null, null);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID) throws IllegalArgumentException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID) throws IllegalArgumentException {
        this.doAddSigner(key, subjectKeyID, encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(), null, null);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID, signedAttr, unsignedAttr);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.doAddSigner(key, cert, encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID, signedAttr, unsignedAttr);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.doAddSigner(key, subjectKeyID, encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID, signedAttrGen, unsignedAttrGen);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.doAddSigner(key, cert, encryptionOID, digestOID, signedAttrGen, unsignedAttrGen, null);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID, signedAttrGen, unsignedAttrGen);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.doAddSigner(key, subjectKeyID, encryptionOID, digestOID, signedAttrGen, unsignedAttrGen, null);
    }

    private void doAddSigner(PrivateKey key, Object signerIdentifier, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen, AttributeTable baseSignedTable) throws IllegalArgumentException {
        this.signerInfs.add(new a(key, signerIdentifier, digestOID, encryptionOID, signedAttrGen, unsignedAttrGen, baseSignedTable));
    }

    public CMSSignedData generate(CMSProcessable content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, i.a(sigProvider));
    }

    public CMSSignedData generate(CMSProcessable content, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(content, false, sigProvider);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(eContentType, content, encapsulate, i.a(sigProvider), true);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(eContentType, content, encapsulate, sigProvider, true);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, String sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(eContentType, content, encapsulate, i.a(sigProvider), addDefaultAttributes);
    }

    public CMSSignedData generate(String eContentType, final CMSProcessable content, boolean encapsulate, Provider sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, CMSException {
        boolean isCounterSignature = eContentType == null;
        final ASN1ObjectIdentifier contentTypeOID = isCounterSignature ? null : new ASN1ObjectIdentifier(eContentType);
        for (a signer : this.signerInfs) {
            try {
                this.signerGens.add(signer.a(this.rand, sigProvider, addDefaultAttributes));
            }
            catch (OperatorCreationException e2) {
                throw new CMSException("exception creating signerInf", e2);
            }
            catch (IOException e3) {
                throw new CMSException("exception encoding attributes", e3);
            }
            catch (CertificateEncodingException e4) {
                throw new CMSException("error creating sid.", e4);
            }
        }
        this.signerInfs.clear();
        if (content != null) {
            return this.generate(new CMSTypedData(){

                @Override
                public ASN1ObjectIdentifier getContentType() {
                    return contentTypeOID;
                }

                @Override
                public void write(OutputStream out) throws IOException, CMSException {
                    content.write(out);
                }

                @Override
                public Object getContent() {
                    return content.getContent();
                }
            }, encapsulate);
        }
        return this.generate(new CMSAbsentContent(contentTypeOID), encapsulate);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (content instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)content).getContentType().getId(), content, encapsulate, sigProvider);
        }
        return this.generate(DATA, content, encapsulate, sigProvider);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        if (content instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)content).getContentType().getId(), content, encapsulate, sigProvider);
        }
        return this.generate(DATA, content, encapsulate, sigProvider);
    }

    public CMSSignedData generate(CMSTypedData content) throws CMSException {
        return this.generate(content, false);
    }

    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add(h.a.a(signer.getDigestAlgorithmID()));
            signerInfos.add(signer.toASN1Structure());
        }
        ASN1ObjectIdentifier contentTypeOID = content.getContentType();
        BEROctetString octs = null;
        if (content != null) {
            ByteArrayOutputStream bOut = null;
            if (encapsulate) {
                bOut = new ByteArrayOutputStream();
            }
            OutputStream cOut = i.a((Collection)this.signerGens, (OutputStream)bOut);
            cOut = i.a(cOut);
            try {
                content.write(cOut);
                cOut.close();
            }
            catch (IOException e2) {
                throw new CMSException("data processing exception: " + e2.getMessage(), e2);
            }
            if (encapsulate) {
                octs = new BEROctetString(bOut.toByteArray());
            }
        }
        for (SignerInfoGenerator sGen : this.signerGens) {
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add(inf.getDigestAlgorithm());
            signerInfos.add(inf);
            byte[] calcDigest = sGen.getCalculatedDigest();
            if (calcDigest == null) continue;
            this.digests.put(inf.getDigestAlgorithm().getAlgorithm().getId(), calcDigest);
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = i.a(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = i.a(this.crls);
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, sd);
        return new CMSSignedData((CMSProcessable)content, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signer.getSignature()), false, sigProvider).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signer.getSignature()), false, i.a(sigProvider)).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer) throws CMSException {
        return this.generate(new CMSProcessableByteArray(null, signer.getSignature()), false).getSignerInfos();
    }

    private class a {
        final PrivateKey a;
        final Object b;
        final String c;
        final String d;
        final CMSAttributeTableGenerator e;
        final CMSAttributeTableGenerator f;
        final AttributeTable g;

        a(PrivateKey key, Object signerIdentifier, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSignedTable) {
            this.a = key;
            this.b = signerIdentifier;
            this.c = digestOID;
            this.d = encOID;
            this.e = sAttr;
            this.f = unsAttr;
            this.g = baseSignedTable;
        }

        SignerInfoGenerator a(SecureRandom random, Provider sigProvider, boolean addDefaultAttributes) throws IOException, CertificateEncodingException, CMSException, OperatorCreationException, NoSuchAlgorithmException {
            JcaContentSignerBuilder signerBuilder;
            String digestName = com.timevale.tgtext.bouncycastle.cms.h.a.a(this.c);
            String signatureName = digestName + "with" + com.timevale.tgtext.bouncycastle.cms.h.a.b(this.d);
            JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new BcDigestCalculatorProvider());
            if (addDefaultAttributes) {
                builder.setSignedAttributeGenerator(this.e);
            }
            builder.setDirectSignature(!addDefaultAttributes);
            builder.setUnsignedAttributeGenerator(this.f);
            try {
                signerBuilder = new JcaContentSignerBuilder(signatureName).setSecureRandom(random);
            }
            catch (IllegalArgumentException e2) {
                throw new NoSuchAlgorithmException(e2.getMessage());
            }
            if (sigProvider != null) {
                signerBuilder.setProvider(sigProvider);
            }
            ContentSigner contentSigner = signerBuilder.build(this.a);
            if (this.b instanceof X509Certificate) {
                return builder.build(contentSigner, (X509Certificate)this.b);
            }
            return builder.build(contentSigner, (byte[])this.b);
        }
    }
}

