/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public class PolynomialRingGF2m {
    private GF2mField field;
    private PolynomialGF2mSmallM p;
    protected PolynomialGF2mSmallM[] sqMatrix;
    protected PolynomialGF2mSmallM[] sqRootMatrix;

    public PolynomialRingGF2m(GF2mField field, PolynomialGF2mSmallM p2) {
        this.field = field;
        this.p = p2;
        this.computeSquaringMatrix();
        this.computeSquareRootMatrix();
    }

    public PolynomialGF2mSmallM[] getSquaringMatrix() {
        return this.sqMatrix;
    }

    public PolynomialGF2mSmallM[] getSquareRootMatrix() {
        return this.sqRootMatrix;
    }

    private void computeSquaringMatrix() {
        int[] monomCoeffs;
        int i2;
        int numColumns = this.p.getDegree();
        this.sqMatrix = new PolynomialGF2mSmallM[numColumns];
        for (i2 = 0; i2 < numColumns >> 1; ++i2) {
            int[] nArray = new int[(i2 << 1) + 1];
            monomCoeffs = nArray;
            nArray[i2 << 1] = 1;
            this.sqMatrix[i2] = new PolynomialGF2mSmallM(this.field, monomCoeffs);
        }
        for (i2 = numColumns >> 1; i2 < numColumns; ++i2) {
            int[] nArray = new int[(i2 << 1) + 1];
            monomCoeffs = nArray;
            nArray[i2 << 1] = 1;
            PolynomialGF2mSmallM monomial = new PolynomialGF2mSmallM(this.field, monomCoeffs);
            this.sqMatrix[i2] = monomial.mod(this.p);
        }
    }

    private void computeSquareRootMatrix() {
        int i2;
        int numColumns = this.p.getDegree();
        PolynomialGF2mSmallM[] tmpMatrix = new PolynomialGF2mSmallM[numColumns];
        for (i2 = numColumns - 1; i2 >= 0; --i2) {
            tmpMatrix[i2] = new PolynomialGF2mSmallM(this.sqMatrix[i2]);
        }
        this.sqRootMatrix = new PolynomialGF2mSmallM[numColumns];
        for (i2 = numColumns - 1; i2 >= 0; --i2) {
            this.sqRootMatrix[i2] = new PolynomialGF2mSmallM(this.field, i2);
        }
        for (i2 = 0; i2 < numColumns; ++i2) {
            if (tmpMatrix[i2].getCoefficient(i2) == 0) {
                boolean foundNonZero = false;
                for (int j2 = i2 + 1; j2 < numColumns; ++j2) {
                    if (tmpMatrix[j2].getCoefficient(i2) == 0) continue;
                    foundNonZero = true;
                    PolynomialRingGF2m.swapColumns(tmpMatrix, i2, j2);
                    PolynomialRingGF2m.swapColumns(this.sqRootMatrix, i2, j2);
                    j2 = numColumns;
                }
                if (!foundNonZero) {
                    throw new ArithmeticException("Squaring matrix is not invertible.");
                }
            }
            int coef = tmpMatrix[i2].getCoefficient(i2);
            int invCoef = this.field.inverse(coef);
            tmpMatrix[i2].multThisWithElement(invCoef);
            this.sqRootMatrix[i2].multThisWithElement(invCoef);
            for (int j3 = 0; j3 < numColumns; ++j3) {
                if (j3 == i2 || (coef = tmpMatrix[j3].getCoefficient(i2)) == 0) continue;
                PolynomialGF2mSmallM tmpSqColumn = tmpMatrix[i2].multWithElement(coef);
                PolynomialGF2mSmallM tmpInvColumn = this.sqRootMatrix[i2].multWithElement(coef);
                tmpMatrix[j3].addToThis(tmpSqColumn);
                this.sqRootMatrix[j3].addToThis(tmpInvColumn);
            }
        }
    }

    private static void swapColumns(PolynomialGF2mSmallM[] matrix, int first, int second) {
        PolynomialGF2mSmallM tmp = matrix[first];
        matrix[first] = matrix[second];
        matrix[second] = tmp;
    }
}

