/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.crypto.CryptoException;
import com.timevale.tgtext.bouncycastle.crypto.Signer;
import com.timevale.tgtext.bouncycastle.crypto.agreement.srp.SRP6Client;
import com.timevale.tgtext.bouncycastle.crypto.agreement.srp.SRP6Util;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.io.SignerInputStream;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.tls.Certificate;
import com.timevale.tgtext.bouncycastle.crypto.tls.CertificateRequest;
import com.timevale.tgtext.bouncycastle.crypto.tls.SecurityParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClientContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsKeyExchange;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.crypto.tls.g;
import com.timevale.tgtext.bouncycastle.crypto.tls.o;
import com.timevale.tgtext.bouncycastle.crypto.tls.q;
import com.timevale.tgtext.bouncycastle.crypto.util.PublicKeyFactory;
import com.timevale.tgtext.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

class p
implements TlsKeyExchange {
    protected TlsClientContext a;
    protected int b;
    protected q c;
    protected byte[] d;
    protected byte[] e;
    protected AsymmetricKeyParameter f = null;
    protected byte[] g = null;
    protected BigInteger h = null;
    protected SRP6Client i = new SRP6Client();

    p(TlsClientContext context, int keyExchange, byte[] identity, byte[] password) {
        switch (keyExchange) {
            case 21: {
                this.c = null;
                break;
            }
            case 23: {
                this.c = new o();
                break;
            }
            case 22: {
                this.c = new g();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.a = context;
        this.b = keyExchange;
        this.d = identity;
        this.e = password;
    }

    @Override
    public void skipServerCertificate() throws IOException {
        if (this.c != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.c == null) {
            throw new TlsFatalAlert(10);
        }
        com.timevale.tgtext.bouncycastle.asn1.x509.Certificate x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.f = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43);
        }
        if (!this.c.b(this.f)) {
            throw new TlsFatalAlert(46);
        }
        TlsUtils.validateKeyUsage(x509Cert, 128);
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        byte[] sigByte;
        SecurityParameters securityParameters = this.a.getSecurityParameters();
        InputStream sigIn = is;
        Signer signer = null;
        if (this.c != null) {
            signer = this.a(this.c, securityParameters);
            sigIn = new SignerInputStream(is, signer);
        }
        byte[] NBytes = TlsUtils.readOpaque16(sigIn);
        byte[] gBytes = TlsUtils.readOpaque16(sigIn);
        byte[] sBytes = TlsUtils.readOpaque8(sigIn);
        byte[] BBytes = TlsUtils.readOpaque16(sigIn);
        if (signer != null && !signer.verifySignature(sigByte = TlsUtils.readOpaque16(is))) {
            throw new TlsFatalAlert(42);
        }
        BigInteger N = new BigInteger(1, NBytes);
        BigInteger g2 = new BigInteger(1, gBytes);
        this.g = sBytes;
        try {
            this.h = SRP6Util.validatePublicValue(N, new BigInteger(1, BBytes));
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(47);
        }
        this.i.init(N, g2, new SHA1Digest(), this.a.getSecureRandom());
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void skipClientCredentials() throws IOException {
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream os) throws IOException {
        byte[] keData = BigIntegers.asUnsignedByteArray(this.i.generateClientCredentials(this.g, this.d, this.e));
        TlsUtils.writeOpaque16(keData, os);
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        try {
            return BigIntegers.asUnsignedByteArray(this.i.calculateSecret(this.h));
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(47);
        }
    }

    protected Signer a(q tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.a(this.f);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

