/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.params;

import com.timevale.tgtext.bouncycastle.crypto.params.NTRUEncryptionKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUEncryptionParameters;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NTRUEncryptionPublicKeyParameters
extends NTRUEncryptionKeyParameters {
    public IntegerPolynomial h;

    public NTRUEncryptionPublicKeyParameters(IntegerPolynomial h2, NTRUEncryptionParameters params) {
        super(false, params);
        this.h = h2;
    }

    public NTRUEncryptionPublicKeyParameters(byte[] b2, NTRUEncryptionParameters params) {
        super(false, params);
        this.h = IntegerPolynomial.fromBinary(b2, params.N, params.q);
    }

    public NTRUEncryptionPublicKeyParameters(InputStream is, NTRUEncryptionParameters params) throws IOException {
        super(false, params);
        this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
    }

    public byte[] getEncoded() {
        return this.h.toBinary(this.params.q);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int result = 31 + (this.h == null ? 0 : this.h.hashCode());
        result = result * 31 + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NTRUEncryptionPublicKeyParameters)) {
            return false;
        }
        NTRUEncryptionPublicKeyParameters other = (NTRUEncryptionPublicKeyParameters)obj;
        if (this.h == null ? other.h != null : !this.h.equals(other.h)) {
            return false;
        }
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }
}

