/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.jcajce;

import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.util.CollectionStore;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

public class JcaCertStore
extends CollectionStore {
    public JcaCertStore(Collection collection) throws CertificateEncodingException {
        super(JcaCertStore.convertCerts(collection));
    }

    private static Collection convertCerts(Collection collection) throws CertificateEncodingException {
        ArrayList<X509CertificateHolder> list = new ArrayList<X509CertificateHolder>(collection.size());
        for (Object o2 : collection) {
            if (o2 instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)o2;
                try {
                    list.add(new X509CertificateHolder(cert.getEncoded()));
                    continue;
                }
                catch (IOException e2) {
                    throw new CertificateEncodingException("unable to read encoding: " + e2.getMessage());
                }
            }
            list.add((X509CertificateHolder)o2);
        }
        return list;
    }
}

