/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.eac.operator.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERInteger;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.eac.operator.EACSignatureVerifier;
import com.timevale.tgtext.bouncycastle.eac.operator.jcajce.b;
import com.timevale.tgtext.bouncycastle.eac.operator.jcajce.d;
import com.timevale.tgtext.bouncycastle.eac.operator.jcajce.e;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.OperatorStreamException;
import com.timevale.tgtext.bouncycastle.operator.RuntimeOperatorException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class JcaEACSignatureVerifierBuilder {
    private b helper = new com.timevale.tgtext.bouncycastle.eac.operator.jcajce.a();

    public JcaEACSignatureVerifierBuilder setProvider(String providerName) {
        this.helper = new d(providerName);
        return this;
    }

    public JcaEACSignatureVerifierBuilder setProvider(Provider provider) {
        this.helper = new e(provider);
        return this;
    }

    public EACSignatureVerifier build(final ASN1ObjectIdentifier usageOid, PublicKey pubKey) throws OperatorCreationException {
        Signature sig;
        try {
            sig = this.helper.a(usageOid);
            sig.initVerify(pubKey);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new OperatorCreationException("unable to find algorithm: " + e2.getMessage(), e2);
        }
        catch (NoSuchProviderException e3) {
            throw new OperatorCreationException("unable to find provider: " + e3.getMessage(), e3);
        }
        catch (InvalidKeyException e4) {
            throw new OperatorCreationException("invalid key: " + e4.getMessage(), e4);
        }
        final a sigStream = new a(sig);
        return new EACSignatureVerifier(){

            @Override
            public ASN1ObjectIdentifier getUsageIdentifier() {
                return usageOid;
            }

            @Override
            public OutputStream getOutputStream() {
                return sigStream;
            }

            @Override
            public boolean verify(byte[] expected) {
                block5: {
                    try {
                        if (!usageOid.on(EACObjectIdentifiers.id_TA_ECDSA)) break block5;
                        try {
                            byte[] reencoded = JcaEACSignatureVerifierBuilder.derEncode(expected);
                            return sigStream.a(reencoded);
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    catch (SignatureException e2) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + e2.getMessage(), e2);
                    }
                }
                return sigStream.a(expected);
            }
        };
    }

    private static byte[] derEncode(byte[] rawSign) throws IOException {
        int len = rawSign.length / 2;
        byte[] r2 = new byte[len];
        byte[] s2 = new byte[len];
        System.arraycopy(rawSign, 0, r2, 0, len);
        System.arraycopy(rawSign, len, s2, 0, len);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(new DERInteger(new BigInteger(1, r2)));
        v2.add(new DERInteger(new BigInteger(1, s2)));
        DERSequence seq = new DERSequence(v2);
        return seq.getEncoded();
    }

    private class a
    extends OutputStream {
        private Signature b;

        a(Signature sig) {
            this.b = sig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.b.update(bytes, off, len);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                this.b.update(bytes);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        @Override
        public void write(int b2) throws IOException {
            try {
                this.b.update((byte)b2);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        boolean a(byte[] expected) throws SignatureException {
            return this.b.verify(expected);
        }
    }
}

